/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.utils.PapyrusEcoreUtils;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.umlutils.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    public static void setMessageSignature(Message message, Operation newOperation, TransactionalEditingDomain domain) {
        MessageUtil.setMessageSignature(message, (Element)newOperation, domain, UMLPackage.eINSTANCE.getSendSignalEvent(), UMLPackage.eINSTANCE.getSendOperationEvent(), (EStructuralFeature)UMLPackage.eINSTANCE.getSendOperationEvent_Operation(), UMLPackage.eINSTANCE.getReceiveSignalEvent(), UMLPackage.eINSTANCE.getReceiveOperationEvent(), (EStructuralFeature)UMLPackage.eINSTANCE.getReceiveOperationEvent_Operation(), MessageSort.ASYNCH_SIGNAL_LITERAL, MessageSort.ASYNCH_CALL_LITERAL);
    }

    public static void setMessageSignature(Message message, Signal newSignal, TransactionalEditingDomain domain) {
        MessageUtil.setMessageSignature(message, (Element)newSignal, domain, UMLPackage.eINSTANCE.getSendOperationEvent(), UMLPackage.eINSTANCE.getSendSignalEvent(), (EStructuralFeature)UMLPackage.eINSTANCE.getSendSignalEvent_Signal(), UMLPackage.eINSTANCE.getReceiveOperationEvent(), UMLPackage.eINSTANCE.getReceiveSignalEvent(), (EStructuralFeature)UMLPackage.eINSTANCE.getReceiveSignalEvent_Signal(), MessageSort.ASYNCH_CALL_LITERAL, MessageSort.ASYNCH_SIGNAL_LITERAL);
    }

    private static void setMessageSignature(Message message, Element signature, TransactionalEditingDomain domain, EClass fromSendClass, EClass toSendClass, EStructuralFeature toSendFeature, EClass fromReceiveClass, EClass toReceiveClass, EStructuralFeature toReceiveFeature, MessageSort fromSort, MessageSort toSort) {
        BasicEList ownedElements;
        if (message == null) {
            return;
        }
        MessageEnd receiveEnd = message.getReceiveEvent();
        MessageEnd sendEnd = message.getSendEvent();
        CompoundCommand command = new CompoundCommand("");
        LinkedList<Element> receiveElementsToAdd = new LinkedList<Element>();
        LinkedList<Element> receiveElementsToRemove = new LinkedList<Element>();
        Package receiveEventParent = MessageUtil.refactor(receiveEnd, fromReceiveClass, toReceiveClass, toReceiveFeature, signature, command, domain, receiveElementsToAdd, receiveElementsToRemove);
        LinkedList<Element> sendElementsToAdd = new LinkedList<Element>();
        LinkedList<Element> sendElementsToRemove = new LinkedList<Element>();
        Package sendEventParent = MessageUtil.refactor(sendEnd, fromSendClass, toSendClass, toSendFeature, signature, command, domain, sendElementsToAdd, sendElementsToRemove);
        if (sendEventParent != null && receiveEventParent == sendEventParent) {
            ownedElements = new BasicEList((Collection)sendEventParent.getPackagedElements());
            ownedElements.addAll(sendElementsToAdd);
            ownedElements.addAll(receiveElementsToAdd);
            ownedElements.removeAll(sendElementsToRemove);
            ownedElements.removeAll(receiveElementsToRemove);
            command.append(MessageUtil.setValueToElement((Element)sendEventParent, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), ownedElements, domain));
        } else {
            if (sendEventParent != null) {
                ownedElements = new BasicEList((Collection)sendEventParent.getPackagedElements());
                ownedElements.addAll(sendElementsToAdd);
                ownedElements.remove(sendElementsToRemove);
                command.append(MessageUtil.setValueToElement((Element)sendEventParent, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), ownedElements, domain));
            }
            if (receiveEventParent != null) {
                ownedElements = new BasicEList((Collection)receiveEventParent.getPackagedElements());
                ownedElements.addAll(receiveElementsToAdd);
                ownedElements.remove(receiveElementsToRemove);
                command.append(MessageUtil.setValueToElement((Element)receiveEventParent, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), ownedElements, domain));
            }
        }
        if (fromSort != null && message.getMessageSort() == fromSort) {
            MessageSort messageSort = toSort;
            command.append(MessageUtil.setValueToElement((Element)message, (EStructuralFeature)UMLPackage.eINSTANCE.getMessage_MessageSort(), messageSort, domain));
        }
        domain.getCommandStack().execute((Command)command);
    }

    private static Package refactor(MessageEnd messageEnd, EClass fromClass, EClass toClass, EStructuralFeature toFeature, Element elementToSet, CompoundCommand command, TransactionalEditingDomain domain, List<Element> elementsToAdd, List<Element> elementsToRemove) {
        MessageOccurrenceSpecification messageOccSpec;
        Event event;
        Package messageEventParent = null;
        if (messageEnd != null && messageEnd instanceof MessageOccurrenceSpecification && (event = (messageOccSpec = (MessageOccurrenceSpecification)messageEnd).getEvent()) != null) {
            if (fromClass.isInstance((Object)event)) {
                if (PapyrusEcoreUtils.isOnlyUsage((EObject)event, (EObject)messageOccSpec)) {
                    elementsToRemove.add((Element)event);
                }
                messageEventParent = event.getNearestPackage();
                event = (Event)UMLPackage.eINSTANCE.getEFactoryInstance().create(toClass);
                elementsToAdd.add((Element)event);
                command.append(MessageUtil.setValueToElement((Element)messageOccSpec, (EStructuralFeature)UMLPackage.eINSTANCE.getOccurrenceSpecification_Event(), event, domain));
            }
            if (toClass.isInstance((Object)event)) {
                command.append(MessageUtil.setValueToElement((Element)event, toFeature, elementToSet, domain));
            }
        }
        return messageEventParent;
    }

    private static Command getCommandFromRequest(Element source, IEditCommandRequest request) {
        try {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)source);
            if (provider != null) {
                ICommand createGMFCommand = provider.getEditCommand(request);
                GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
                return emfCommand;
            }
        }
        catch (Exception ex) {
            Activator.logException(ex);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private static Command setValueToElement(Element source, EStructuralFeature feature, Object value, TransactionalEditingDomain domain) {
        SetRequest request = new SetRequest(domain, (EObject)source, feature, value);
        return MessageUtil.getCommandFromRequest(source, (IEditCommandRequest)request);
    }

    public static Operation getMessageOperation(Message message) {
        NamedElement signature = message.getSignature();
        if (signature instanceof Operation) {
            return (Operation)signature;
        }
        return null;
    }

    public static Signal getMessageSignal(Message message) {
        NamedElement signature = message.getSignature();
        if (signature instanceof Signal) {
            return (Signal)signature;
        }
        return null;
    }
}

