/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import org.eclipse.uml2.uml.OpaqueExpression;

public class OpaqueExpressionUtil {
    public static String getBodyForLanguage(OpaqueExpression opaqueExpression, String language) {
        int index;
        String body = "";
        if (opaqueExpression.getLanguages() != null && (index = opaqueExpression.getLanguages().indexOf((Object)language)) != -1 && index < opaqueExpression.getBodies().size()) {
            body = (String)opaqueExpression.getBodies().get(index);
        }
        return body;
    }

    public static void setBodyForLanguage(OpaqueExpression opaqueExpression, String language, String body) {
        OpaqueExpressionUtil.checkAndCorrectLists(opaqueExpression);
        if (!opaqueExpression.getLanguages().contains((Object)language)) {
            opaqueExpression.getLanguages().add((Object)language);
            opaqueExpression.getBodies().add((Object)body);
        } else {
            int index = opaqueExpression.getLanguages().indexOf((Object)language);
            opaqueExpression.getBodies().set(index, (Object)body);
        }
    }

    public static boolean checkAndCorrectLists(OpaqueExpression opaqueExpression) {
        int languageSize;
        int bodySize = opaqueExpression.getBodies().size();
        if (bodySize == (languageSize = opaqueExpression.getLanguages().size())) {
            return true;
        }
        int difference = languageSize - bodySize;
        if (difference > 0) {
            int i = 0;
            while (i < difference) {
                opaqueExpression.getBodies().add((Object)"");
                ++i;
            }
        } else {
            int i = 0;
            while (i < -difference) {
                opaqueExpression.getLanguages().add((Object)"");
                ++i;
            }
        }
        return false;
    }
}

