/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import java.util.Iterator;
import org.eclipse.papyrus.umlutils.MultiplicityElementUtil;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.papyrus.umlutils.ParameterUtil;
import org.eclipse.papyrus.umlutils.TypedElementUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.TypedElement;

public class OperationUtil {
    public static String getCustomLabel(Operation operation, int style) {
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)operation));
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(operation.getName());
        }
        buffer.append("(");
        buffer.append(OperationUtil.getParametersAsString(operation, style));
        buffer.append(")");
        if ((style & 0x200) != 0) {
            buffer.append(OperationUtil.getReturnTypeAsString(operation, style));
        }
        if ((style & 0x80) != 0 && !(modifiers = OperationUtil.getModifiersAsString(operation)).equals("")) {
            buffer.append("{");
            buffer.append(modifiers);
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static String getReturnTypeAsString(Operation operation, int style) {
        boolean displayType = (style & 0x200) != 0;
        boolean displayMultiplicity = (style & 0x40000) != 0;
        StringBuffer label = new StringBuffer("");
        Parameter returnParameter = OperationUtil.getReturnParameter(operation);
        if (returnParameter != null && (displayType || displayMultiplicity)) {
            label.append(": ");
            if (displayType) {
                label.append(TypedElementUtil.getTypeAsString((TypedElement)returnParameter));
            }
            if (displayMultiplicity) {
                label.append(MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)returnParameter));
            }
        }
        return label.toString();
    }

    private static String getParametersAsString(Operation operation, int style) {
        StringBuffer paramString = new StringBuffer();
        Iterator paramIterator = operation.getOwnedParameters().iterator();
        boolean firstParameter = true;
        while (paramIterator.hasNext()) {
            String parameterString;
            Parameter parameter = (Parameter)paramIterator.next();
            if (parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL) || (parameterString = ParameterUtil.getCustomLabel(parameter, style)).trim().equals("")) continue;
            if (!firstParameter) {
                paramString.append(", ");
            }
            paramString.append(parameterString);
            firstParameter = false;
        }
        return paramString.toString();
    }

    private static String getModifiersAsString(Operation operation) {
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        Parameter returnParameter = OperationUtil.getReturnParameter(operation);
        if (returnParameter != null) {
            if (!returnParameter.isUnique()) {
                buffer.append("nonunique");
                needsComma = true;
            }
            if (returnParameter.isOrdered()) {
                if (needsComma) {
                    buffer.append(", ");
                }
                buffer.append("ordered");
                needsComma = true;
            }
        }
        if (operation.isQuery()) {
            if (needsComma) {
                buffer.append(", ");
            }
            buffer.append("query");
            needsComma = true;
        }
        for (Operation currentOperation : operation.getRedefinedOperations()) {
            if (needsComma) {
                buffer.append(", ");
            }
            buffer.append("redefines ");
            buffer.append(currentOperation.getName());
            needsComma = true;
        }
        for (Constraint constraint : operation.getOwnedRules()) {
            if (needsComma) {
                buffer.append(", ");
            }
            if (constraint.getSpecification() != null) {
                buffer.append(constraint.getSpecification().stringValue());
            }
            needsComma = true;
        }
        return buffer.toString();
    }

    private static Parameter getReturnParameter(Operation operation) {
        Parameter returnParameter = null;
        Iterator it = operation.getOwnedParameters().iterator();
        while (returnParameter == null && it.hasNext()) {
            Parameter parameter = (Parameter)it.next();
            if (!parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            returnParameter = parameter;
        }
        return returnParameter;
    }
}

