/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import org.eclipse.papyrus.umlutils.MultiplicityElementUtil;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;

public class ParameterUtil {
    public static String getModifiersAsString(Parameter parameter, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? "\n" : " ";
        if (parameter.isOrdered()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "ordered");
        }
        if (parameter.isUnique()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "unique");
        }
        if (parameter.isException()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "exception");
        }
        if (parameter.isStream()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "stream");
        }
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static boolean updateModifiersString(StringBuffer buffer, boolean needsComma, String NL, String message) {
        if (needsComma) {
            buffer.append(",");
            buffer.append(NL);
        }
        buffer.append(message);
        return true;
    }

    public static String getLabel(Parameter parameter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
        buffer.append(" ");
        buffer.append(parameter.getDirection().getLiteral());
        buffer.append(" ");
        if (parameter.getName() != null) {
            buffer.append(parameter.getName());
        }
        if (parameter.getType() != null) {
            buffer.append(": " + parameter.getType().getName());
        } else {
            buffer.append(": <Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if (parameter.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(parameter.getDefault());
        }
        buffer.append(ParameterUtil.getModifiersAsString(parameter, false));
        return buffer.toString();
    }

    public static String getCustomLabel(Parameter parameter, int style) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
        }
        if ((style & 0x800) != 0) {
            buffer.append(" ");
            buffer.append(parameter.getDirection().getLiteral());
        }
        if ((style & 0x1000) != 0) {
            buffer.append(" ");
            buffer.append(parameter.getName());
        }
        if ((style & 0x100) != 0) {
            if (parameter.getType() != null) {
                buffer.append(": " + parameter.getType().getName());
            } else {
                buffer.append(": <Undefined>");
            }
        }
        if ((style & 0x4000) != 0) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
            buffer.append(multiplicity);
        }
        if ((style & 0x8000) != 0 && parameter.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(parameter.getDefault());
        }
        if ((style & 0x80) != 0 && !(modifiers = ParameterUtil.getModifiersAsString(parameter, multiLine = (style & 0x400) != 0)).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    private static String getDefaultAsString(Parameter parameter, boolean equalSign) {
        String defaultString = "";
        if (parameter.getDefault() != null && !parameter.getDefault().equals("")) {
            if (equalSign) {
                defaultString = String.valueOf(defaultString) + "= ";
            }
            defaultString = String.valueOf(defaultString) + parameter.getDefault();
        }
        return "";
    }

    static boolean hasStyle(int style, int mask) {
        return (style & mask) != 0;
    }
}

