/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.umlutils.MultiplicityElementUtil;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    public static List<Property> getSubsettablesProperties(Property property, boolean noCheck) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (NamedElement element : property.getClass_().getMembers()) {
            if (!(element instanceof Property)) continue;
            boolean isValid = true;
            Property subsettableProperty = (Property)element;
            if (subsettableProperty.equals(property)) {
                isValid = false;
            }
            if (!noCheck) {
                if (property.getType() != null && subsettableProperty.getType() != null) {
                    if (!property.getType().conformsTo(subsettableProperty.getType())) {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
                if (subsettableProperty.getUpper() != -1 && property.getUpper() > subsettableProperty.getUpper()) {
                    isValid = false;
                }
            }
            if (!isValid) continue;
            list.add(subsettableProperty);
        }
        return list;
    }

    public static Property findSusbsettedPropertyByName(String propertyName, Property property, boolean noCheck) {
        for (Property tmpProperty : PropertyUtil.getSubsettablesProperties(property, true)) {
            String tmpPropertyName = tmpProperty.getName();
            if (tmpPropertyName == null || !propertyName.equals(tmpPropertyName.trim())) continue;
            return tmpProperty;
        }
        return null;
    }

    public static List<Property> getRedefinableProperties(Property property) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (NamedElement element : property.getClass_().getInheritedMembers()) {
            if (!(element instanceof Property)) continue;
            list.add((Property)element);
        }
        for (Property element : property.getRedefinedProperties()) {
            list.add(element);
        }
        return list;
    }

    public static Property findRedefinedPropertyByName(String propertyName, Property property) {
        for (Property tmpProperty : PropertyUtil.getRedefinableProperties(property)) {
            String tmpPropertyName = tmpProperty.getName();
            if (tmpPropertyName == null || !propertyName.equals(tmpPropertyName.trim())) continue;
            return tmpProperty;
        }
        return null;
    }

    public static String getDerived(Property property) {
        return property.isDerived() ? "/" : "";
    }

    public static String getLabel(Property property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        buffer.append(PropertyUtil.getDerived(property));
        buffer.append(" ");
        buffer.append(PropertyUtil.getName(property));
        if (property.getType() != null) {
            buffer.append(": " + property.getType().getName());
        } else {
            buffer.append(": <Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if (property.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(property.getDefault());
        }
        buffer.append(PropertyUtil.getModifiersAsString(property, false));
        return buffer.toString();
    }

    public static String getName(Property property) {
        if (property.getName() != null) {
            return property.getName();
        }
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)property);
    }

    public static String getCustomLabel(Property property, int style) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        }
        if ((style & 4) != 0 && property.isDerived()) {
            buffer.append("/");
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(property.getName());
        }
        if ((style & 0x10) != 0) {
            if (property.getType() != null) {
                buffer.append(" : " + property.getType().getName());
            } else {
                buffer.append(" : <Undefined>");
            }
        }
        if ((style & 0x20) != 0) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
            buffer.append(multiplicity);
        }
        if ((style & 0x40) != 0 && property.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(property.getDefault());
        }
        if ((style & 0x80) != 0 && !(modifiers = PropertyUtil.getModifiersAsString(property, multiLine = (style & 0x400) != 0)).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    public static String getModifiersAsString(Property property, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? "\n" : " ";
        if (property.isReadOnly()) {
            buffer.append("readOnly");
            needsComma = true;
        }
        if (property.isDerivedUnion()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "union");
        }
        if (property.isOrdered()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "ordered");
        }
        if (property.isUnique()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "unique");
        }
        for (Property current : property.getRedefinedProperties()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "redefines ");
            buffer.append(current.getName());
        }
        for (Property current : property.getSubsettedProperties()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "subsets ");
            buffer.append(current.getName());
        }
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static boolean updateModifiersString(StringBuffer buffer, boolean needsComma, String NL, String message) {
        if (needsComma) {
            buffer.append(",");
            buffer.append(NL);
        }
        buffer.append(message);
        return true;
    }
}

