/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.umlutils.ImageUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeUtil {
    protected static final String SPACE_SEPARATOR = "#";
    protected static final String EQUAL_SEPARATOR = "=";
    protected static final String PROPERTY_VALUE_SEPARATOR = "|";
    protected static final String SETREOTYPE_WITH_VALUE_SEPARATOR = ";";
    protected static final String ST_LEFT = String.valueOf("\u00ab");
    protected static final String ST_RIGHT = String.valueOf("\u00bb");

    public static List<Stereotype> getAllSuperStereotypes(Stereotype stereotype) {
        ArrayList<Stereotype> generalStereotypes = new ArrayList<Stereotype>();
        for (Classifier generalClassifier : stereotype.getGenerals()) {
            if (!(generalClassifier instanceof Stereotype)) continue;
            generalStereotypes.add((Stereotype)generalClassifier);
            generalStereotypes.addAll(StereotypeUtil.getAllSuperStereotypes((Stereotype)generalClassifier));
        }
        return generalStereotypes;
    }

    public static EList<Image> getIcons(Stereotype stereotype) {
        BasicEList icons = new BasicEList();
        for (Image image : stereotype.getIcons()) {
            if (!"icon".equals(ImageUtil.getKind(image))) continue;
            icons.add((Object)image);
        }
        return icons;
    }

    private static List<String> getStereoPropertiesToDisplay(Stereotype stereotype, List<String> stPropList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String currentProp : stPropList) {
            if (!currentProp.substring(0, currentProp.lastIndexOf(".")).equals(stereotype.getQualifiedName())) continue;
            result.add(currentProp.substring(currentProp.lastIndexOf(".") + 1, currentProp.length()));
        }
        return result;
    }

    public static String getPropertiesValues(String stereotypesPropertiesToDisplay, Element umlElement) {
        HashSet<Stereotype> stereoSet = new HashSet<Stereotype>();
        ArrayList<String> stPropList = new ArrayList<String>();
        String propValues = "";
        StringTokenizer propStringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (propStringTokenizer.hasMoreElements()) {
            String propertyQN = propStringTokenizer.nextToken();
            String stereotypeQN = propertyQN.substring(0, propertyQN.indexOf("."));
            Stereotype stereotype = umlElement.getAppliedStereotype(stereotypeQN);
            if (stereotype != null) {
                stereoSet.add(stereotype);
            }
            stPropList.add(propertyQN);
        }
        for (Stereotype stereotype : stereoSet) {
            propValues = String.valueOf(propValues) + ST_LEFT + stereotype.getName() + ST_RIGHT + SPACE_SEPARATOR;
            for (String stProp : StereotypeUtil.getStereoPropertiesToDisplay(stereotype, stPropList)) {
                Property currentProp = StereotypeUtil.getPropertyByName(stereotype, stProp);
                if (currentProp == null) {
                    return "No value";
                }
                propValues = String.valueOf(propValues) + StereotypeUtil.displayPropertyValue(stereotype, currentProp, umlElement, PROPERTY_VALUE_SEPARATOR);
            }
            if (propValues.endsWith(PROPERTY_VALUE_SEPARATOR)) {
                propValues = propValues.substring(0, propValues.lastIndexOf(PROPERTY_VALUE_SEPARATOR));
            }
            propValues = String.valueOf(propValues) + SETREOTYPE_WITH_VALUE_SEPARATOR;
        }
        return propValues;
    }

    public static String displayPropertyValue(Stereotype stereotype, Property property, Element umlElement, String separator) {
        Type propType = property.getType();
        if (propType instanceof Enumeration) {
            return StereotypeUtil.getPropertyValueForEnumerationType(property, stereotype, umlElement, EQUAL_SEPARATOR, separator);
        }
        if (propType instanceof Class && propType.getAppliedStereotypes() != null && propType.getAppliedStereotypes().size() > 0 && ((Stereotype)propType.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            return StereotypeUtil.getPropertyValueForMetaclassType(property, stereotype, umlElement, EQUAL_SEPARATOR, separator);
        }
        if (propType instanceof Stereotype) {
            return StereotypeUtil.getPropertyValueForStereotypeType(property, stereotype, umlElement, EQUAL_SEPARATOR, separator);
        }
        if (propType instanceof Class && !(propType instanceof Stereotype) && property.isComposite()) {
            return String.valueOf(property.getName()) + EQUAL_SEPARATOR + property.getName() + separator;
        }
        return StereotypeUtil.getPropertyValue(property, stereotype, umlElement, EQUAL_SEPARATOR, separator);
    }

    public static Property getPropertyByName(Stereotype stereotype, String propertyName) {
        for (Property tmpProperty : stereotype.getAllAttributes()) {
            String name = "";
            if (tmpProperty != null) {
                String string = name = tmpProperty.getName() != null ? tmpProperty.getName() : "";
            }
            if (!name.equals(propertyName)) continue;
            return tmpProperty;
        }
        return null;
    }

    public static String getPropertiesValuesInBrace(String stereotypesPropertiesToDisplay, Element umlElement) {
        String propertyValues = "";
        HashSet<Stereotype> stereoSet = new HashSet<Stereotype>();
        ArrayList<String> stPropList = new ArrayList<String>();
        StringTokenizer propStringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (propStringTokenizer.hasMoreElements()) {
            String propertyQN = propStringTokenizer.nextToken();
            String stereotypeQN = propertyQN.substring(0, propertyQN.indexOf("."));
            Stereotype stereotype = umlElement.getAppliedStereotype(stereotypeQN);
            if (stereotype != null) {
                stereoSet.add(stereotype);
            }
            stPropList.add(propertyQN);
        }
        for (Stereotype stereotype : stereoSet) {
            if (stereotype == null) continue;
            propertyValues = String.valueOf(propertyValues) + StereotypeUtil.displayPropertyValuesForStereotype(stereotype, stPropList, umlElement);
        }
        return propertyValues;
    }

    public static String displayPropertyValuesForStereotype(Stereotype stereotype, List<String> stPropList, Element umlElement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("");
        for (String stProp : StereotypeUtil.getStereoPropertiesToDisplay(stereotype, stPropList)) {
            Property currentProp = null;
            for (Property tmpProperty : stereotype.getAllAttributes()) {
                if (!stProp.equals(tmpProperty.getName())) continue;
                currentProp = tmpProperty;
            }
            if (currentProp == null) {
                return "No value";
            }
            Type propType = currentProp.getType();
            if (propType instanceof Enumeration) {
                buffer.append(StereotypeUtil.getPropertyValueForEnumerationType(currentProp, stereotype, umlElement, EQUAL_SEPARATOR, ","));
                continue;
            }
            if (propType instanceof Class && propType.getAppliedStereotypes() != null && propType.getAppliedStereotypes().size() > 0 && ((Stereotype)propType.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
                buffer.append(StereotypeUtil.getPropertyValueForMetaclassType(currentProp, stereotype, umlElement, EQUAL_SEPARATOR, ","));
                continue;
            }
            if (propType instanceof Stereotype) {
                buffer.append(StereotypeUtil.getPropertyValueForStereotypeType(currentProp, stereotype, umlElement, EQUAL_SEPARATOR, ","));
                continue;
            }
            if (propType instanceof Class && !(propType instanceof Stereotype) && currentProp.isComposite()) {
                buffer.append(String.valueOf(stProp) + EQUAL_SEPARATOR + currentProp.getName() + ",");
                continue;
            }
            buffer.append(StereotypeUtil.getPropertyValue(currentProp, stereotype, umlElement, EQUAL_SEPARATOR, ","));
        }
        String propValues = buffer.toString();
        if (propValues.endsWith(",")) {
            propValues = propValues.substring(0, propValues.lastIndexOf(","));
        }
        return propValues;
    }

    private static String getPropertyValueForEnumerationType(Property property, Stereotype stereotype, Element umlElement, String EQUAL_SEPARATOR, String PROPERTY_VALUE_SEPARATOR) {
        Object val;
        String out = "";
        out = property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null ? (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null ? (property.isSetDefault() || umlElement.getValue(stereotype, property.getName()) != null ? ((val = umlElement.getValue(stereotype, property.getName())) instanceof EnumerationLiteral ? String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((EnumerationLiteral)val).getLabel() + PROPERTY_VALUE_SEPARATOR : String.valueOf(property.getName()) + EQUAL_SEPARATOR + val + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        return out;
    }

    private static String getPropertyValueForMetaclassType(Property property, Stereotype stereotype, Element umlElement, String EQUAL_SEPARATOR, String PROPERTY_VALUE_SEPARATOR) {
        String out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null && umlElement.getValue(stereotype, property.getName()) instanceof NamedElement) {
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((NamedElement)umlElement.getValue(stereotype, property.getName())).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> elementNames = new ArrayList<String>();
            if (values != null) {
                int count = 0;
                while (count < values.size()) {
                    if (values.get(count) instanceof NamedElement) {
                        elementNames.add(((NamedElement)values.get(count)).getName());
                    }
                    ++count;
                }
            }
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + elementNames + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValueForStereotypeType(Property property, Stereotype stereotype, Element umlElement, String EQUAL_SEPARATOR, String PROPERTY_VALUE_SEPARATOR) {
        String out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null) {
            Object value = umlElement.getValue(stereotype, property.getName());
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((NamedElement)baseElement).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> baseElements = new ArrayList<String>();
            if (values != null) {
                int k = 0;
                while (k < values.size()) {
                    baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getName());
                    ++k;
                }
            }
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + baseElements + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValue(Property property, Stereotype stereotype, Element umlElement, String EQUAL_SEPARATOR, String PROPERTY_VALUE_SEPARATOR) {
        String out = "";
        out = property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null ? (property.isSetDefault() || umlElement.getValue(stereotype, property.getName()) != null ? String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR : String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR;
        return out;
    }

    public static EList<Image> getShapes(Stereotype stereotype) {
        BasicEList shapes = new BasicEList();
        for (Image image : stereotype.getIcons()) {
            if (!"shape".equals(ImageUtil.getKind(image))) continue;
            shapes.add((Object)image);
        }
        return shapes;
    }
}

