/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import java.util.Collection;
import org.eclipse.papyrus.umlutils.OpaqueExpressionUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.ValueSpecification;

public class ValueSpecificationUtil {
    private static final String UNLIMITED_KEYWORD = "*";
    private static final String INTERVAL_FORMAT = "%1s..%2s";

    public static String getSpecificationValue(ValueSpecification specification) {
        String value = "";
        if (specification != null && specification.eClass() != null) {
            switch (specification.eClass().getClassifierID()) {
                case 97: {
                    value = ((LiteralString)specification).getValue();
                    break;
                }
                case 98: {
                    value = Boolean.toString(((LiteralBoolean)specification).booleanValue());
                    break;
                }
                case 96: {
                    value = Integer.toString(((LiteralInteger)specification).getValue());
                    break;
                }
                case 101: {
                    value = Integer.toString(((LiteralUnlimitedNatural)specification).getValue());
                    if (!"-1".equals(value)) break;
                    value = UNLIMITED_KEYWORD;
                    break;
                }
                case 99: {
                    break;
                }
                case 30: {
                    OpaqueExpression exp = (OpaqueExpression)specification;
                    if (exp.getLanguages().isEmpty()) break;
                    value = OpaqueExpressionUtil.getBodyForLanguage(exp, (String)exp.getLanguages().get(0));
                    break;
                }
                case 100: {
                    value = ((InstanceValue)specification).getInstance().getName();
                    break;
                }
                case 86: {
                    Expression expr = (Expression)specification;
                    if (!expr.getOperands().isEmpty()) {
                        StringBuffer operandsBuff = new StringBuffer(expr.getSymbol());
                        operandsBuff.append("(");
                        int initialLength = operandsBuff.length();
                        for (ValueSpecification operand : expr.getOperands()) {
                            if (operandsBuff.length() > initialLength) {
                                operandsBuff.append(",");
                            }
                            operandsBuff.append(ValueSpecificationUtil.getSpecificationValue(operand));
                        }
                        operandsBuff.append(")");
                        value = operandsBuff.toString();
                        break;
                    }
                    value = expr.getSymbol();
                    break;
                }
                case 85: {
                    StringExpression stringExpr = (StringExpression)specification;
                    if (!stringExpr.getOperands().isEmpty()) {
                        StringBuffer operandsBuff = new StringBuffer(stringExpr.getSymbol());
                        operandsBuff.append("(");
                        int initialLength = operandsBuff.length();
                        for (ValueSpecification operand : stringExpr.getOperands()) {
                            if (operandsBuff.length() > initialLength) {
                                operandsBuff.append(",");
                            }
                            operandsBuff.append(ValueSpecificationUtil.getSpecificationValue(operand));
                        }
                        operandsBuff.append(")");
                        value = operandsBuff.toString();
                        break;
                    }
                    value = stringExpr.getSymbol();
                    break;
                }
                case 204: {
                    Duration durationExpr = (Duration)specification;
                    if (durationExpr.getExpr() != null) {
                        value = ValueSpecificationUtil.getSpecificationValue(durationExpr.getExpr());
                        break;
                    }
                    if (durationExpr.getObservations().size() <= 0) break;
                    value = ((Observation)durationExpr.getObservations().get(0)).getName();
                    break;
                }
                case 202: {
                    TimeExpression timeExpr = (TimeExpression)specification;
                    if (timeExpr.getExpr() != null) {
                        value = ValueSpecificationUtil.getSpecificationValue(timeExpr.getExpr());
                        break;
                    }
                    if (timeExpr.getObservations().size() <= 0) break;
                    value = ((Observation)timeExpr.getObservations().get(0)).getName();
                    break;
                }
                case 205: 
                case 206: 
                case 209: {
                    Interval interval = (Interval)specification;
                    String min = ValueSpecificationUtil.getSpecificationValue(interval.getMin());
                    String max = ValueSpecificationUtil.getSpecificationValue(interval.getMax());
                    value = String.format(INTERVAL_FORMAT, min, max);
                    break;
                }
            }
        }
        return value;
    }

    public static String getConstraintnValue(Constraint specification) {
        ValueSpecification spe;
        String value = "";
        if (specification != null && (spe = specification.getSpecification()) != null) {
            value = ValueSpecificationUtil.getSpecificationValue(spe);
        }
        return value;
    }

    public static void restoreSpecificationValue(ValueSpecification specification, String value) {
        if (value == null) {
            return;
        }
        switch (specification.eClass().getClassifierID()) {
            case 97: {
                ValueSpecificationUtil.restoreLiteralString((LiteralString)specification, value);
                break;
            }
            case 98: {
                ValueSpecificationUtil.restoreLiteralBoolean((LiteralBoolean)specification, value);
                break;
            }
            case 96: {
                ValueSpecificationUtil.restoreLiteralInteger((LiteralInteger)specification, value);
                break;
            }
            case 101: {
                ValueSpecificationUtil.restoreLiteralUnlimitedNatural((LiteralUnlimitedNatural)specification, value);
                break;
            }
            case 99: {
                ValueSpecificationUtil.restoreLiteralNull((LiteralNull)specification, value);
                break;
            }
            case 30: {
                OpaqueExpression exp = (OpaqueExpression)specification;
                if (!exp.getLanguages().isEmpty()) {
                    ValueSpecificationUtil.restoreOpaqueExpression((OpaqueExpression)specification, (String)exp.getLanguages().get(0), value);
                    break;
                }
                ValueSpecificationUtil.restoreOpaqueExpression((OpaqueExpression)specification, value);
                break;
            }
        }
    }

    public static void restoreLiteralString(LiteralString specification, String value) {
        specification.setValue(value);
    }

    public static void restoreLiteralInteger(LiteralInteger specification, String value) {
        int intValue = 0;
        try {
            intValue = Integer.decode(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        specification.setValue(intValue);
    }

    public static void restoreLiteralBoolean(LiteralBoolean specification, String value) {
        if ("true".equals(value) || "1".equals(value)) {
            specification.setValue(true);
        } else {
            specification.setValue(false);
        }
    }

    public static void restoreLiteralUnlimitedNatural(LiteralUnlimitedNatural specification, String value) {
        int intValue = 0;
        try {
            intValue = Integer.decode(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (UNLIMITED_KEYWORD.equals(value)) {
            intValue = -1;
        }
        specification.setValue(intValue);
    }

    public static void restoreLiteralNull(LiteralNull specification, String value) {
    }

    public static void restoreOpaqueExpression(OpaqueExpression specification, String value) {
        OpaqueExpressionUtil.setBodyForLanguage(specification, "UML", value);
    }

    public static void restoreOpaqueExpression(OpaqueExpression specification, String language, String value) {
        OpaqueExpressionUtil.setBodyForLanguage(specification, language, value);
    }

    public static void addEnclosedValueSpecificationToCollection(ValueSpecification spec, Collection collection) {
        if (!collection.contains(spec)) {
            collection.add(spec);
            if (spec instanceof Interval) {
                ValueSpecificationUtil.addEnclosedValueSpecificationToCollection(((Interval)spec).getMin(), collection);
                ValueSpecificationUtil.addEnclosedValueSpecificationToCollection(((Interval)spec).getMax(), collection);
            } else if (spec instanceof Duration) {
                ValueSpecificationUtil.addEnclosedValueSpecificationToCollection(((Duration)spec).getExpr(), collection);
            } else if (spec instanceof TimeExpression) {
                ValueSpecificationUtil.addEnclosedValueSpecificationToCollection(((TimeExpression)spec).getExpr(), collection);
            } else if (spec instanceof Expression) {
                for (ValueSpecification vs : ((Expression)spec).getOperands()) {
                    ValueSpecificationUtil.addEnclosedValueSpecificationToCollection(vs, collection);
                }
                if (spec instanceof StringExpression) {
                    for (StringExpression se : ((StringExpression)spec).getSubExpressions()) {
                        ValueSpecificationUtil.addEnclosedValueSpecificationToCollection((ValueSpecification)se, collection);
                    }
                }
            }
        }
    }
}

