/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.validation;

import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.papyrus.validation.ValidationUtils;
import org.eclipse.papyrus.validation.preferences.PreferencePage;

public class ValidationTool {
    private Object element;
    private EObject eObject;
    private EditingDomain domain;

    public ValidationTool(Object element) {
        this.element = element;
        this.setEObject((EObject)Platform.getAdapterManager().getAdapter(element, EObject.class));
    }

    public ValidationTool(EObject eObject) {
        this.setEObject(eObject);
    }

    public void tryChildIfEmpty() {
        List items;
        if (this.getEObject() == null && this.element instanceof LinkItem && (items = ((LinkItem)this.element).getChildrenElements()).size() > 0 && items.get(0) instanceof EObject) {
            this.setEObject((EObject)items.get(0));
        }
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
    }

    public IMarker[] getMarkers() {
        if (this.getEObject() != null && this.getEObject().eResource() != null) {
            IFile file;
            URI uri = this.getEObject().eResource().getURI();
            String platformResourceString = uri.toPlatformString(true);
            IFile iFile = file = platformResourceString != null ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString)) : null;
            if (file != null) {
                try {
                    return file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public EObject eObjectOfMarker(IMarker marker) {
        if (this.getEObject() != null) {
            this.domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getEObject());
            try {
                if (marker.isSubtypeOf("org.eclipse.emf.ecore.diagnostic")) {
                    return ValidationUtils.eObjectFromMarkerOrMap(marker, null, this.domain);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public void deleteSubMarkers() {
        IMarker[] iMarkerArray = this.getMarkers();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            EObject eObjOfMarker = this.eObjectOfMarker(marker);
            if (this.isContainedBy(eObjOfMarker, this.getEObject())) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public int getSeverity() {
        IMarker[] markers = this.getMarkers();
        PreferencePage.MarkChildren markChildren = PreferencePage.getHierarchicalMarkers();
        int severity = 0;
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                EObject eObjectOfMarker = this.eObjectOfMarker(marker);
                boolean first = true;
                while (eObjectOfMarker != null) {
                    if (eObjectOfMarker == this.getEObject()) {
                        try {
                            Integer severityI = (Integer)marker.getAttribute("severity");
                            if (severityI > severity) {
                                severity = severityI;
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    eObjectOfMarker = eObjectOfMarker.eContainer();
                    if (markChildren != PreferencePage.MarkChildren.ALL && (!first || markChildren == PreferencePage.MarkChildren.NO)) break;
                    first = false;
                }
                ++n2;
            }
        }
        return severity;
    }

    public String getMarkerMessages() {
        IMarker[] markers = this.getMarkers();
        PreferencePage.MarkChildren markChildren = PreferencePage.getHierarchicalMarkers();
        if (markers != null) {
            boolean examineChilds = markChildren != PreferencePage.MarkChildren.NO;
            String message = "";
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                EObject eObjectOfMarker = this.eObjectOfMarker(marker);
                if (eObjectOfMarker == this.getEObject()) {
                    if (message.length() > 0) {
                        message = String.valueOf(message) + "\n";
                    }
                    try {
                        message = String.valueOf(message) + "- " + WordUtils.wrap((String)((String)marker.getAttribute("message")), (int)100, (String)"\n  ", (boolean)true);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (examineChilds && eObjectOfMarker != null) {
                    eObjectOfMarker = eObjectOfMarker.eContainer();
                    boolean first = true;
                    while (eObjectOfMarker != null) {
                        if (eObjectOfMarker == this.getEObject()) {
                            if (message.length() > 0) {
                                message = String.valueOf(message) + "\n";
                            }
                            message = String.valueOf(message) + "- Problem marker in (at least) one of the children";
                            examineChilds = false;
                            break;
                        }
                        eObjectOfMarker = eObjectOfMarker.eContainer();
                        if (!first && markChildren == PreferencePage.MarkChildren.DIRECT) break;
                        first = false;
                    }
                }
                ++n2;
            }
            return message.length() > 0 ? message : null;
        }
        return null;
    }

    private boolean isContainedBy(EObject subEObj, EObject eObj) {
        if (eObj == subEObj) {
            return true;
        }
        if (subEObj != null) {
            return this.isContainedBy(subEObj.eContainer(), eObj);
        }
        return false;
    }
}

