/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.papyrus.widgets.editors.ICommitListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractEditor
extends Composite {
    protected Label label;
    protected String labelText;
    protected Set<ICommitListener> commitListeners = new HashSet<ICommitListener>();
    protected Binding binding;
    protected String toolTipText;
    public static TabbedPropertySheetWidgetFactory factory = new TabbedPropertySheetWidgetFactory();

    static {
        factory.setBackground(null);
        factory.setBorderStyle(2048);
    }

    protected AbstractEditor(Composite parent) {
        this(parent, 0, null);
    }

    protected AbstractEditor(Composite parent, int style) {
        this(parent, style, null);
    }

    protected AbstractEditor(Composite parent, String label) {
        this(parent, 0, label);
    }

    protected AbstractEditor(Composite parent, int style, String label) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        if (label != null) {
            this.createLabel(label);
        }
    }

    protected void createLabel(String text) {
        this.label = factory.createLabel((Composite)this, text);
        this.label.setLayoutData((Object)this.getLabelLayoutData());
        if (this.toolTipText != null) {
            this.label.setToolTipText(this.toolTipText);
        }
        ++((GridLayout)this.getLayout()).numColumns;
    }

    protected GridData getLabelLayoutData() {
        GridData data = new GridData();
        data.widthHint = 120;
        data.verticalAlignment = 0x1000000;
        return data;
    }

    protected GridData getDefaultLayoutData() {
        GridData data = new GridData(4, 1, true, false);
        return data;
    }

    public void setLabel(String label) {
        this.labelText = label;
        if (this.label != null) {
            this.label.setText(label);
        } else {
            this.createLabel(label);
            this.label.moveAbove(this.getChildren()[0]);
        }
    }

    public void setDisplayLabel(boolean displayLabel) {
        if (displayLabel) {
            this.setLabel(this.labelText);
        } else if (this.label != null) {
            this.label.dispose();
            --((GridLayout)this.getLayout()).numColumns;
        }
    }

    public void addCommitListener(ICommitListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(ICommitListener listener) {
        this.commitListeners.remove(listener);
    }

    protected void commit() {
        for (ICommitListener listener : this.commitListeners) {
            listener.commit(this);
        }
    }

    protected DataBindingContext getBindingContext() {
        return new DataBindingContext();
    }

    public abstract void setConverters(IConverter var1, IConverter var2);

    protected abstract void doBinding();

    public abstract Object getEditableType();

    public abstract void setReadOnly(boolean var1);

    public abstract boolean isReadOnly();

    protected void setCommitOnFocusLost(Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                AbstractEditor.this.commit();
            }
        });
    }

    public void refreshValue() {
        if (this.binding != null) {
            this.binding.updateModelToTarget();
        }
    }

    protected void setLabelToolTipText(String text) {
        this.toolTipText = text;
        if (this.label != null) {
            this.label.setToolTipText(text);
        }
    }

    protected void setExclusion(Control control, boolean exclude) {
        GridData data;
        if (control.getLayoutData() == null) {
            data = new GridData();
            control.setLayoutData((Object)data);
        }
        data = (GridData)control.getLayoutData();
        if (data.exclude != exclude) {
            data.exclude = exclude;
            GridLayout layout = (GridLayout)control.getParent().getLayout();
            layout.numColumns = exclude ? --layout.numColumns : ++layout.numColumns;
        }
    }

    public abstract void setToolTipText(String var1);
}

