/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.widgets.editors.AbstractEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractValueEditor
extends AbstractEditor {
    protected IObservableValue modelProperty;
    protected IObservableValue widgetObservable;
    protected UpdateValueStrategy targetToModelStrategy;
    protected UpdateValueStrategy modelToTargetStrategy;

    protected AbstractValueEditor(Composite parent) {
        super(parent);
    }

    protected AbstractValueEditor(Composite parent, int style, String label) {
        super(parent, style, label);
    }

    protected AbstractValueEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected AbstractValueEditor(Composite parent, String label) {
        super(parent, label);
    }

    protected void setWidgetObservable(IObservableValue widgetObservable, IConverter targetToModel, IConverter modelToTarget) {
        this.widgetObservable = widgetObservable;
        this.setConverters(targetToModel, modelToTarget);
    }

    protected void setWidgetObservable(IObservableValue widgetObservable, boolean commitOnChange) {
        this.widgetObservable = widgetObservable;
        if (commitOnChange) {
            this.widgetObservable.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    AbstractValueEditor.this.commit();
                }
            });
        }
    }

    protected void setWidgetObservable(IObservableValue widgetObservable) {
        this.setWidgetObservable(widgetObservable, false);
    }

    public void setModelObservable(IObservableValue modelProperty) {
        this.modelProperty = modelProperty;
        this.doBinding();
    }

    public void setConverters(IConverter targetToModel, IConverter modelToTarget) {
        if (this.targetToModelStrategy == null) {
            this.targetToModelStrategy = new UpdateValueStrategy();
        }
        if (this.modelToTargetStrategy == null) {
            this.modelToTargetStrategy = new UpdateValueStrategy();
        }
        this.targetToModelStrategy.setConverter(targetToModel);
        this.modelToTargetStrategy.setConverter(modelToTarget);
    }

    public void setUpdateStrategies(UpdateValueStrategy targetToModelStrategy, UpdateValueStrategy modelToTargetStrategy) {
        this.targetToModelStrategy = targetToModelStrategy;
        this.modelToTargetStrategy = modelToTargetStrategy;
    }

    protected void doBinding() {
        if (this.modelProperty == null || this.widgetObservable == null) {
            return;
        }
        this.binding = this.getBindingContext().bindValue(this.widgetObservable, this.modelProperty, this.targetToModelStrategy, this.modelToTargetStrategy);
    }

    public abstract Object getValue();
}

