/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.papyrus.widgets.databinding.AggregatedObservable;
import org.eclipse.papyrus.widgets.databinding.GrayedCheckboxObservableValue;
import org.eclipse.papyrus.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class BooleanCheckbox
extends AbstractValueEditor {
    private Button checkbox;
    private AggregatedObservable aggregated;

    public BooleanCheckbox(Composite parent, int style) {
        this(parent, style, null);
    }

    public BooleanCheckbox(Composite parent, int style, String label) {
        super(parent);
        this.checkbox = factory.createButton((Composite)this, label, 0x20 | style);
        this.setCommitOnFocusLost((Control)this.checkbox);
    }

    public void setModelObservable(IObservableValue modelProperty) {
        Object widgetObservable;
        if (modelProperty instanceof AggregatedObservable) {
            this.aggregated = (AggregatedObservable)modelProperty;
            widgetObservable = new GrayedCheckboxObservableValue(this.checkbox, this.aggregated);
        } else {
            widgetObservable = WidgetProperties.selection().observe((Widget)this.checkbox);
        }
        this.setWidgetObservable((IObservableValue)widgetObservable, true);
        super.setModelObservable(modelProperty);
    }

    public Object getEditableType() {
        return Boolean.class;
    }

    public Object getValue() {
        return this.checkbox.getSelection();
    }

    public void setReadOnly(boolean readOnly) {
        this.checkbox.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.checkbox.isEnabled();
    }

    public void setToolTipText(String text) {
        this.checkbox.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    public void setLabel(String label) {
        this.checkbox.setText(label);
    }
}

