/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.widgets.messages.Messages;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class EnumRadio
extends AbstractValueEditor {
    protected IStaticContentProvider contentProvider;
    protected Composite buttonsArea;
    protected ILabelProvider labelProvider = new LabelProvider();
    protected Map<Button, Object> values = new HashMap<Button, Object>();
    protected int numColumns = -1;

    public EnumRadio(Composite parent, int style) {
        super(parent, 0);
        this.buttonsArea = factory.createComposite((Composite)this);
        this.buttonsArea.setLayoutData((Object)this.getDefaultLayoutData());
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.buttonsArea.setLayout((Layout)layout);
        factory.createCLabel(this.buttonsArea, Messages.EnumRadio_NoValue);
    }

    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        this.contentProvider = contentProvider;
        if (labelProvider != null) {
            this.labelProvider = labelProvider;
        }
        this.doBinding();
    }

    protected void disposeButtons() {
        Control[] controlArray = this.buttonsArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.binding != null) {
            this.binding.dispose();
        }
        this.values.clear();
    }

    protected void doBinding() {
        this.disposeButtons();
        if (this.modelProperty != null && this.contentProvider != null) {
            SelectObservableValue observable = new SelectObservableValue();
            Object[] objectArray = this.contentProvider.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                Button button = factory.createButton(this.buttonsArea, this.labelProvider.getText(value), 16);
                button.setBackground(this.buttonsArea.getBackground());
                button.setData(value);
                button.setToolTipText(this.toolTipText);
                ISWTObservableValue buttonObservable = WidgetProperties.selection().observe((Widget)button);
                observable.addOption(value, (IObservableValue)buttonObservable);
                this.values.put(button, value);
                ++n2;
            }
            this.setWidgetObservable((IObservableValue)observable);
            super.doBinding();
        }
        this.updateLayout();
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        this.updateLayout();
    }

    private void updateLayout() {
        GridLayout gridLayout = (GridLayout)this.buttonsArea.getLayout();
        gridLayout.numColumns = this.numColumns > 0 ? this.numColumns : this.values.size();
        gridLayout.makeColumnsEqualWidth = this.numColumns > 0;
        this.updateLabelLayout();
    }

    private void updateLabelLayout() {
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        ((GridData)this.label.getLayoutData()).verticalAlignment = this.numColumns == -1 ? 0x1000000 : 1;
    }

    protected void createLabel(String label) {
        super.createLabel(label);
        this.updateLabelLayout();
    }

    public Object getValue() {
        for (Button button : this.values.keySet()) {
            if (!button.getSelection()) continue;
            return this.values.get(button);
        }
        return null;
    }

    public Object getEditableType() {
        return Object.class;
    }

    public void setReadOnly(boolean readOnly) {
        for (Button button : this.values.keySet()) {
            button.setEnabled(!readOnly);
        }
        this.buttonsArea.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.buttonsArea.isEnabled();
    }

    public void setToolTipText(String text) {
        for (Button button : this.values.keySet()) {
            button.setToolTipText(text);
        }
        super.setLabelToolTipText(text);
    }
}

