/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.papyrus.widgets.Activator;
import org.eclipse.papyrus.widgets.editors.MultipleValueEditor;
import org.eclipse.papyrus.widgets.selectors.NullSelector;
import org.eclipse.papyrus.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class MultipleStringFileEditor
extends MultipleValueEditor {
    protected boolean allowBrowseWorkspace = true;
    protected boolean allowBrowseFileSystem = true;
    protected Button browseFileSystem;
    protected Button browseWorkspace;
    protected final List<String> filterNames;
    protected final List<String> filterExtensions;
    public static final String browseWorkspaceIcon = "icons/browse-workspace_12x12.png";
    public static final String browseFileSystemIcon = "icons/browse-filesystem_12x12.png";

    public MultipleStringFileEditor(Composite parent, int style) {
        super(parent, style, NullSelector.instance);
        this.setDirectCreation(true);
        this.filterNames = new LinkedList<String>();
        this.filterExtensions = new LinkedList<String>();
    }

    protected void createListControls() {
        super.createListControls();
        this.add.dispose();
        this.edit.dispose();
        this.browseFileSystem = this.createButton(Activator.getDefault().getImageFromPlugin(browseFileSystemIcon), "Browse file system");
        this.browseWorkspace = this.createButton(Activator.getDefault().getImageFromPlugin(browseWorkspaceIcon), "Browse workspace");
        this.browseWorkspace.moveAbove((Control)this.remove);
        this.browseFileSystem.moveAbove((Control)this.remove);
    }

    public void setDirectCreation(boolean directCreation) {
        super.setDirectCreation(true);
    }

    protected void updateControls() {
        this.remove.setEnabled(!this.readOnly);
        this.up.setEnabled(this.ordered && !this.readOnly);
        this.down.setEnabled(this.ordered && !this.readOnly);
        this.browseWorkspace.setEnabled(this.allowBrowseWorkspace);
        this.browseFileSystem.setEnabled(this.allowBrowseFileSystem);
    }

    public void allowBrowseWorkspace(boolean allowBrowseWorkspace) {
        this.allowBrowseWorkspace = allowBrowseWorkspace;
    }

    public void allowBrowseFileSystem(boolean allowBrowseFileSystem) {
        this.allowBrowseFileSystem = allowBrowseFileSystem;
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget == this.browseFileSystem) {
            this.browseFileSystem();
        } else if (e.widget == this.browseWorkspace) {
            this.browseWorkspace();
        }
    }

    protected void browseFileSystem() {
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(this.filterExtensions.toArray(new String[this.filterExtensions.size()]));
        dialog.setFilterNames(this.filterNames.toArray(new String[this.filterNames.size()]));
        dialog.open();
        ArrayList<String> filePathList = new ArrayList<String>(this.modelProperty.size() + dialog.getFileNames().length);
        filePathList.addAll((Collection<String>)this.modelProperty);
        String[] stringArray = dialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            filePathList.add(String.valueOf(dialog.getFilterPath()) + File.separator + fileName);
            ++n2;
        }
        this.modelProperty.clear();
        this.modelProperty.addAll(filePathList);
        this.commit();
    }

    protected void browseWorkspace() {
        Object[] result;
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)workspace, "");
        int code = dialog.open();
        if (code == 0 && (result = dialog.getResult()).length > 0) {
            ArrayList<String> filePathResult = new ArrayList<String>(result.length + this.modelProperty.size());
            filePathResult.addAll((Collection<String>)this.modelProperty);
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (file instanceof IFile) {
                    filePathResult.add(FileUtil.getPath((IFile)file, false));
                }
                ++n2;
            }
            this.modelProperty.clear();
            this.modelProperty.addAll(filePathResult);
            this.commit();
        }
    }
}

