/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.widgets.Activator;
import org.eclipse.papyrus.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.widgets.editors.IElementSelector;
import org.eclipse.papyrus.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.widgets.messages.Messages;
import org.eclipse.papyrus.widgets.providers.TreeCollectionContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MultipleValueEditor
extends AbstractListEditor
implements SelectionListener,
IChangeListener,
DisposeListener {
    protected TreeViewer treeViewer;
    protected Tree tree;
    protected Composite controlsSection;
    protected Button add;
    protected Button remove;
    protected Button up;
    protected Button down;
    protected Button edit;
    protected MultipleValueSelectorDialog dialog;
    protected IElementSelector selector;
    protected boolean ordered;
    protected boolean unique;
    protected ReferenceValueFactory referenceFactory;
    protected boolean readOnly;
    private boolean directCreation;

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered, boolean unique, String label) {
        super(parent, label);
        Assert.isNotNull((Object)selector, (String)"The Element Selector must be specified for a MultipleValueEditor");
        this.setLayout((Layout)new GridLayout(label == null ? 1 : 2, false));
        this.controlsSection = new Composite((Composite)this, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.tree = new Tree((Composite)this, style | 2 | 0x200 | 0x100 | 0x800);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.horizontalSpan = 2;
        treeData.minimumHeight = 80;
        this.tree.setLayoutData((Object)treeData);
        this.tree.addSelectionListener((SelectionListener)this);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)TreeCollectionContentProvider.instance);
        this.createListControls();
        this.selector = selector;
        this.dialog = new MultipleValueSelectorDialog(parent.getShell(), selector, label, unique, ordered);
        if (label != null) {
            this.dialog.setTitle(label);
        }
        this.setLabelProvider((ILabelProvider)new LabelProvider());
        this.ordered = ordered;
        this.unique = unique;
        this.updateControls();
    }

    protected void updateControls() {
        boolean enableAddAction = true;
        if (this.directCreation && (this.referenceFactory == null || !this.referenceFactory.canCreateObject())) {
            enableAddAction = false;
        }
        this.add.setEnabled(!this.readOnly && enableAddAction);
        this.remove.setEnabled(!this.readOnly);
        this.up.setEnabled(this.ordered && !this.readOnly);
        this.down.setEnabled(this.ordered && !this.readOnly);
        this.edit.setEnabled(this.referenceFactory != null && this.referenceFactory.canEdit() && !this.readOnly);
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered) {
        this(parent, style, selector, ordered, false, null);
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector) {
        this(parent, style, selector, false, false, null);
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, String label) {
        this(parent, style, selector, false, false, label);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.dialog.setLabelProvider(labelProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected void doBinding() {
        this.treeViewer.setInput((Object)this.modelProperty);
        this.modelProperty.addChangeListener((IChangeListener)this);
        this.getParent().addDisposeListener((DisposeListener)this);
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.dialog.setOrdered(ordered);
        this.updateControls();
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        this.dialog.setUnique(unique);
        this.updateControls();
    }

    protected void createListControls() {
        this.up = this.createButton(Activator.getDefault().getImage("/icons/Up_12x12.gif"), Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = this.createButton(Activator.getDefault().getImage("/icons/Down_12x12.gif"), Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.add = this.createButton(Activator.getDefault().getImage("/icons/Add_12x12.gif"), Messages.MultipleValueEditor_AddElements);
        this.remove = this.createButton(Activator.getDefault().getImage("/icons/Delete_12x12.gif"), Messages.MultipleValueEditor_RemoveSelectedElements);
        this.edit = this.createButton(Activator.getDefault().getImage("/icons/Edit_12x12.gif"), Messages.MultipleValueEditor_EditSelectedValue);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    public Object getEditableType() {
        return Collection.class;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == null) {
            return;
        }
        if (e.widget == this.add) {
            this.addAction();
        } else if (e.widget == this.remove) {
            this.removeAction();
        } else if (e.widget == this.up) {
            this.upAction();
        } else if (e.widget == this.down) {
            this.downAction();
        } else if (e.widget == this.edit) {
            this.editAction();
        }
    }

    protected void addAction() {
        if (this.directCreation) {
            Object newElement;
            if (this.referenceFactory != null && this.referenceFactory.canCreateObject() && (newElement = this.referenceFactory.createObject((Control)this)) != null) {
                this.modelProperty.add(newElement);
                this.commit();
            }
            return;
        }
        if (this.modelProperty != null) {
            this.dialog.setInitialSelections(this.modelProperty.toArray());
        } else {
            this.dialog.setInitialSelections(new Object[0]);
        }
        int returnCode = this.dialog.open();
        if (returnCode == 1) {
            return;
        }
        this.modelProperty.clear();
        Object[] result = this.dialog.getResult();
        if (result == null) {
            return;
        }
        this.modelProperty.addAll(Arrays.asList(result));
        this.commit();
    }

    protected void commit() {
        super.commit();
        this.treeViewer.refresh();
    }

    protected void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.modelProperty.remove(value);
            ++n2;
        }
        this.treeViewer.setSelection(null);
        this.commit();
    }

    protected void upAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = this.modelProperty.indexOf(o);
            if (oldIndex > 0) {
                this.modelProperty.move(oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.treeViewer.setSelection((ISelection)selectionCopy);
        this.commit();
    }

    protected void downAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        int maxIndex = this.modelProperty.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = this.modelProperty.indexOf(o);
            if (oldIndex < maxIndex) {
                this.modelProperty.move(oldIndex, oldIndex + 1);
            }
            --i;
        }
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.treeViewer.setSelection((ISelection)selectionCopy);
        this.commit();
    }

    protected void editAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TreeItem selectedItem = this.treeViewer.getTree().getSelection()[0];
        Tree parentTree = selectedItem.getParent();
        int index = parentTree.indexOf(selectedItem);
        Object currentValue = selection.getFirstElement();
        Object newValue = this.referenceFactory.edit((Control)this.edit, selection.getFirstElement());
        if (newValue != currentValue && newValue != null) {
            this.modelProperty.remove(index);
            this.modelProperty.add(index, newValue);
        }
        this.commit();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.referenceFactory = factory;
        this.dialog.setFactory(factory);
        this.updateControls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.tree && this.edit.isEnabled()) {
            this.editAction();
        }
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void handleChange(ChangeEvent event) {
        this.treeViewer.refresh();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
        this.modelProperty.removeChangeListener((IChangeListener)this);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateControls();
    }

    public boolean isReadOnly() {
        return !this.tree.isEnabled();
    }

    public void setLabel(String label) {
        if (this.label == null) {
            this.setLayout((Layout)new GridLayout(2, false));
        }
        super.setLabel(label);
        this.dialog.setTitle(label);
    }

    public void setToolTipText(String text) {
        this.tree.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        this.updateControls();
    }

    public void refreshValue() {
        this.treeViewer.refresh();
    }

    public void setDirectCreation(boolean directCreation) {
        this.directCreation = directCreation;
        this.updateControls();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }
}

