/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.widgets.databinding.AggregatedObservable;
import org.eclipse.papyrus.widgets.databinding.ComboObservableValue;
import org.eclipse.papyrus.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.widgets.providers.UnchangedObject;
import org.eclipse.papyrus.widgets.providers.UnsetObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ReferenceCombo
extends AbstractValueEditor {
    protected ComboViewer viewer;
    protected CCombo combo;
    protected boolean unsettable;
    protected EncapsulatedContentProvider contentProvider;

    public ReferenceCombo(Composite parent, int style) {
        this(parent, style, null);
    }

    public ReferenceCombo(Composite parent, int style, String label) {
        super(parent, label);
        this.combo = factory.createCCombo((Composite)this, style | 0x800);
        this.combo.setBackground(new Color((Device)this.combo.getDisplay(), 255, 255, 255));
        this.combo.setLayoutData((Object)this.getDefaultLayoutData());
        this.combo.setEditable(false);
        this.viewer = new ComboViewer(this.combo);
        ++((GridLayout)this.getLayout()).numColumns;
        this.setCommitOnFocusLost((Control)this.combo);
    }

    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        Assert.isNotNull((Object)contentProvider, (String)"The content provider should not be null");
        this.setContentProvider(contentProvider);
        if (labelProvider != null) {
            this.setLabelProvider(labelProvider);
        }
    }

    public void setContentProvider(IStaticContentProvider provider) {
        this.contentProvider = new EncapsulatedContentProvider(provider);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput((Object)"");
        this.updateControls();
        this.doBinding();
    }

    protected void doBinding() {
        if (this.contentProvider == null || this.modelProperty == null) {
            return;
        }
        this.setWidgetObservable(this.getObservableValue(), true);
        if (this.modelProperty instanceof AggregatedObservable && ((AggregatedObservable)this.modelProperty).hasDifferentValues()) {
            this.contentProvider.addTemporaryElement(UnchangedObject.instance);
            this.viewer.refresh();
        }
        super.doBinding();
    }

    protected IObservableValue getObservableValue() {
        return new ComboObservableValue(this.viewer, this.modelProperty);
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public ComboViewer getViewer() {
        return this.viewer;
    }

    public Object getEditableType() {
        return Object.class;
    }

    public Object getValue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.getFirstElement();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.viewer.setSelection((ISelection)new StructuredSelection());
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection(value), true);
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.combo.setEnabled(!readOnly);
        this.updateControls();
    }

    public boolean isReadOnly() {
        return !this.combo.isEnabled();
    }

    public void setToolTipText(String text) {
        this.combo.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    public void setUnsettable(boolean unsettable) {
        this.unsettable = unsettable;
        this.updateControls();
    }

    protected void updateControls() {
        if (this.contentProvider != null) {
            if (this.unsettable) {
                this.contentProvider.addTemporaryElement(UnsetObject.instance);
            } else {
                this.contentProvider.removeTemporaryElement(UnsetObject.instance);
            }
            this.viewer.refresh();
        }
    }

    public void setViewer(ComboViewer comboViewer) {
        this.viewer = comboViewer;
        this.combo = this.viewer.getCCombo();
    }
}

