/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.papyrus.widgets.databinding.AggregatedObservable;
import org.eclipse.papyrus.widgets.editors.ReferenceCombo;
import org.eclipse.papyrus.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.widgets.providers.UnchangedObject;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class StringCombo
extends ReferenceCombo {
    public StringCombo(Composite parent, int style) {
        super(parent, style);
        this.combo.setEditable(true);
    }

    public StringCombo(Composite parent, int style, String label) {
        super(parent, style, label);
    }

    public Object getEditableType() {
        return String.class;
    }

    public void setContentProvider(IStaticContentProvider provider) {
        if (provider != null) {
            this.contentProvider = new EncapsulatedContentProvider(provider);
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
            this.viewer.setInput((Object)"");
        }
    }

    protected IObservableValue getObservableValue() {
        return new CComboObservableValue();
    }

    public String getValue() {
        return this.combo.getText();
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.combo.setText((String)value);
        } else {
            this.combo.setText("");
        }
    }

    protected void updateControls() {
        String value = this.getValue();
        super.updateControls();
        this.setValue(value);
    }

    class CComboObservableValue
    extends AbstractObservableValue
    implements SelectionListener,
    KeyListener,
    FocusListener {
        private String previousValue;

        public CComboObservableValue() {
            this.previousValue = StringCombo.this.combo.getText();
            StringCombo.this.combo.addSelectionListener((SelectionListener)this);
            StringCombo.this.combo.addKeyListener((KeyListener)this);
            StringCombo.this.combo.addFocusListener((FocusListener)this);
        }

        public Object getValueType() {
            return String.class;
        }

        protected String doGetValue() {
            return StringCombo.this.combo.getText();
        }

        protected void doSetValue(Object value) {
            if (StringCombo.this.modelProperty instanceof AggregatedObservable && ((AggregatedObservable)StringCombo.this.modelProperty).hasDifferentValues()) {
                StringCombo.this.combo.setText(UnchangedObject.instance.toString());
            } else if (value instanceof String) {
                this.previousValue = StringCombo.this.combo.getText();
                StringCombo.this.combo.setText((String)value);
            }
        }

        public void keyReleased(KeyEvent e) {
            if ((e.keyCode == 13 || e.keyCode == 0x1000050) && e.stateMask == 0) {
                this.doFireChange();
                e.doit = false;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.doFireChange();
        }

        public void focusLost(FocusEvent e) {
            this.doFireChange();
        }

        private void doFireChange() {
            final String oldValue = this.previousValue;
            final String currentValue = this.previousValue = this.doGetValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return currentValue;
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }
    }
}

