/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.editors;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.widgets.Activator;
import org.eclipse.papyrus.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class StringLabel
extends AbstractValueEditor
implements IChangeListener {
    private final CLabel valueLabel;
    private ILabelProvider labelProvider;
    private Object value;

    public StringLabel(Composite parent, int style) {
        super(parent, style);
        this.valueLabel = factory.createCLabel((Composite)this, "", style);
        this.valueLabel.setLayoutData((Object)this.getDefaultLayoutData());
        this.labelProvider = new LabelProvider();
    }

    public CLabel getValueLabel() {
        return this.valueLabel;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        if (this.binding != null) {
            this.binding.updateModelToTarget();
        }
    }

    public void doBinding() {
        this.modelProperty.addChangeListener((IChangeListener)this);
        this.valueLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StringLabel.this.dispose();
            }
        });
        this.updateLabel();
    }

    protected void updateLabel() {
        String text;
        if (this.valueLabel.isDisposed()) {
            Activator.log.warn("Widget is disposed");
            return;
        }
        Object value = this.getValue();
        Image image = null;
        if (value instanceof String) {
            text = (String)value;
        } else {
            text = this.labelProvider.getText(this.modelProperty.getValue());
            image = this.labelProvider.getImage(this.modelProperty.getValue());
        }
        this.valueLabel.setText(text);
        this.valueLabel.setImage(image);
    }

    public Object getValue() {
        if (this.modelProperty != null) {
            return this.modelProperty.getValue();
        }
        return this.value;
    }

    public void setValue(Object value) {
        if (this.modelProperty != null) {
            this.modelProperty.setValue(value);
        }
        this.value = value;
        this.updateLabel();
    }

    public Object getEditableType() {
        return String.class;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return !this.valueLabel.isEnabled();
    }

    public void setToolTipText(String text) {
        this.valueLabel.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    public void handleChange(ChangeEvent event) {
        this.updateLabel();
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    public void refreshValue() {
        this.updateLabel();
    }
}

