/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeFilter
extends ViewerFilter {
    protected boolean useCache = true;
    protected boolean showIfHasVisibleParent = false;
    protected final Map<Object, Boolean> visibleElement = new HashMap<Object, Boolean>();
    protected final Map<Object, Boolean> visibleParent = new HashMap<Object, Boolean>();
    protected final Map<Object, Boolean> visibleChild = new HashMap<Object, Boolean>();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IContentProvider baseContentProvider;
        ITreeContentProvider contentProvider = null;
        if (viewer instanceof StructuredViewer && (baseContentProvider = ((StructuredViewer)viewer).getContentProvider()) instanceof ITreeContentProvider) {
            contentProvider = (ITreeContentProvider)baseContentProvider;
        }
        if (contentProvider == null) {
            return this.isVisible(viewer, parentElement, element);
        }
        return this.select(viewer, parentElement, element, contentProvider);
    }

    protected boolean select(Viewer viewer, Object parentElement, Object element, ITreeContentProvider contentProvider) {
        boolean isVisible;
        HashSet<Object> visitedChildren = new HashSet<Object>();
        HashSet<Object> visitedParents = new HashSet<Object>();
        if (this.useCache && this.visibleElement.containsKey(element)) {
            return this.visibleElement.get(element);
        }
        boolean bl = isVisible = this.isVisible(viewer, parentElement, element) || this.hasOneVisibleChild(viewer, element, contentProvider, visitedChildren);
        if (this.showIfHasVisibleParent) {
            boolean bl2 = isVisible = isVisible || this.hasOneVisibleParent(viewer, element, contentProvider, visitedParents);
        }
        if (this.useCache) {
            this.visibleElement.put(element, isVisible);
        }
        return isVisible;
    }

    protected boolean hasOneVisibleChild(Viewer viewer, Object element, ITreeContentProvider contentProvider, Set<Object> visitedElements) {
        if (this.useCache && this.visibleChild.containsKey(element)) {
            return this.visibleChild.get(element);
        }
        boolean result = false;
        if (!visitedElements.contains(element)) {
            visitedElements.add(element);
            Object[] objectArray = contentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object childElement = objectArray[n2];
                if (this.isVisible(viewer, element, childElement) || this.hasOneVisibleChild(viewer, childElement, contentProvider, visitedElements)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        if (this.useCache) {
            this.visibleChild.put(element, result);
        }
        return result;
    }

    protected boolean hasOneVisibleParent(Viewer viewer, Object element, ITreeContentProvider contentProvider, Set<Object> visitedElements) {
        if (this.useCache && this.visibleParent.containsKey(element)) {
            return this.visibleParent.get(element);
        }
        boolean result = false;
        if (!visitedElements.contains(element)) {
            visitedElements.add(element);
            Object parentElement = contentProvider.getParent(element);
            if (parentElement == element || parentElement == null) {
                result = this.isVisible(viewer, parentElement, element);
            } else {
                boolean bl = result = this.isVisible(viewer, null, parentElement) || this.hasOneVisibleParent(viewer, parentElement, contentProvider, visitedElements);
            }
        }
        if (this.useCache) {
            this.visibleParent.put(element, result);
        }
        return result;
    }

    protected void clearCache() {
        this.visibleElement.clear();
        this.visibleParent.clear();
        this.visibleChild.clear();
    }

    public abstract boolean isVisible(Viewer var1, Object var2, Object var3);

    public void setShowIfHasVisibleParent(boolean showIfHasVisibleParent) {
        this.showIfHasVisibleParent = showIfHasVisibleParent;
    }
}

