/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.providers;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.widgets.editors.ICommitListener;
import org.eclipse.papyrus.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.widgets.Composite;

public class EncapsulatedContentProvider
implements IHierarchicContentProvider,
IGraphicalContentProvider,
ICommitListener,
IAdaptableContentProvider {
    protected IStaticContentProvider encapsulated;
    private Set<Object> temporaryElements = new LinkedHashSet<Object>();

    public EncapsulatedContentProvider(IStaticContentProvider encapsulated) {
        this.encapsulated = encapsulated;
    }

    protected EncapsulatedContentProvider() {
    }

    private Object[] getAllElements() {
        Object[] elements = this.encapsulated.getElements();
        if (this.temporaryElements.isEmpty()) {
            return elements;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            result.add(object);
            ++n2;
        }
        result.addAll(this.temporaryElements);
        return result.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.encapsulated.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getElements() {
        return this.getAllElements();
    }

    public void addTemporaryElement(Object newObject) {
        this.temporaryElements.add(newObject);
    }

    public void removeTemporaryElement(Object removeObject) {
        this.temporaryElements.remove(removeObject);
    }

    public void clearTemporaryElements() {
        this.temporaryElements.clear();
    }

    public Object[] getChildren(Object parentElement) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).hasChildren(element);
        }
        return false;
    }

    public boolean isValidValue(Object element) {
        if (this.encapsulated instanceof IHierarchicContentProvider) {
            return ((IHierarchicContentProvider)((Object)this.encapsulated)).isValidValue(element);
        }
        return true;
    }

    public void createBefore(Composite parent) {
        if (this.encapsulated instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)((Object)this.encapsulated)).createBefore(parent);
        }
    }

    public void createAfter(Composite parent) {
        if (this.encapsulated instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)((Object)this.encapsulated)).createAfter(parent);
        }
    }

    public void commit(AbstractEditor editor) {
        if (this.encapsulated instanceof ICommitListener) {
            ((ICommitListener)((Object)this.encapsulated)).commit(editor);
        }
    }

    public Object getAdaptedValue(Object selection) {
        if (this.encapsulated instanceof IAdaptableContentProvider) {
            return ((IAdaptableContentProvider)((Object)this.encapsulated)).getAdaptedValue(selection);
        }
        return selection;
    }

    public Object getContainerValue(Object selection) {
        if (this.encapsulated instanceof IAdaptableContentProvider) {
            return ((IAdaptableContentProvider)((Object)this.encapsulated)).getContainerValue(selection);
        }
        return selection;
    }
}

