/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.providers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.widgets.providers.TreeToFlatContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicToFlatContentProvider
extends TreeToFlatContentProvider {
    private IHierarchicContentProvider contentProvider;

    public HierarchicToFlatContentProvider(IHierarchicContentProvider provider) {
        super(provider);
        if (!(provider instanceof IStaticContentProvider)) {
            throw new IllegalArgumentException();
        }
        this.contentProvider = provider;
    }

    @Override
    public void dispose() {
        this.contentProvider.dispose();
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
    }

    @Override
    public Object[] getElements() {
        return this.getElementsList().toArray();
    }

    @Override
    protected Collection<Object> getElementsList() {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        HashSet<Object> browsedElements = new HashSet<Object>();
        Object[] objectArray = ((IStaticContentProvider)((Object)this.contentProvider)).getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            if (this.exploreBranch(null, root)) {
                if (this.contentProvider.isValidValue(root)) {
                    result.add(this.getValue(root));
                }
                this.getElementsList(root, result, browsedElements);
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void getElementsList(Object parent, Collection<Object> result, Set<Object> browsedElements) {
        if (!browsedElements.add(parent)) {
            return;
        }
        Object[] objectArray = this.contentProvider.getChildren(parent);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            Object childValue = this.getValue(child);
            if (!result.contains(childValue) && this.exploreBranch(parent, child)) {
                if (this.contentProvider.isValidValue(child)) {
                    result.add(childValue);
                }
                this.getElementsList(child, result, browsedElements);
            }
            ++n2;
        }
    }
}

