/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.widgets.selectors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.papyrus.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.widgets.editors.IElementSelector;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class StringSelector
implements IElementSelector {
    protected Text text;
    protected boolean multiline;
    protected Set<IElementSelectionListener> elementSelectionListeners = new HashSet<IElementSelectionListener>();

    public StringSelector() {
        this(false);
    }

    public StringSelector(boolean multiline) {
        this.multiline = multiline;
    }

    public Object[] getSelectedElements() {
        Object[] result = new String[]{this.text.getText()};
        this.text.setText("");
        return result;
    }

    public void setSelectedElements(Object[] elements) {
    }

    public void createControls(Composite parent) {
        this.text = new Text(parent, (this.multiline ? 2 : 0) | 0x800);
        if (!this.multiline) {
            this.text.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    Object[] result;
                    if (!(e.keyCode != 13 && e.keyCode != 0x1000050 || e.stateMask != 0 || StringSelector.this.elementSelectionListeners.isEmpty() || (result = StringSelector.this.getSelectedElements())[0].equals(""))) {
                        for (IElementSelectionListener listener : StringSelector.this.elementSelectionListeners) {
                            listener.addElements(result);
                        }
                    }
                }
            });
        }
    }

    public Object[] getAllElements() {
        return this.getSelectedElements();
    }

    public void newObjectCreated(Object newObject) {
    }

    public void clearTemporaryElements() {
    }

    public void addElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.add(listener);
    }
}

