/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.wizards;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.core.extension.commands.IModelCreationCommand;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.wizards.Activator;
import org.eclipse.papyrus.wizards.Messages;
import org.eclipse.papyrus.wizards.SettingsHelper;
import org.eclipse.papyrus.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.wizards.category.DiagramCategoryRegistry;
import org.eclipse.papyrus.wizards.category.NewPapyrusModelCommand;
import org.eclipse.papyrus.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.wizards.pages.SelectDiagramCategoryPage;
import org.eclipse.papyrus.wizards.pages.SelectDiagramKindPage;
import org.eclipse.papyrus.wizards.template.InitFromTemplateCommand;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateModelWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "org.eclipse.papyrus.wizards.createmodel";
    public static final String NEW_MODEL_SETTINGS = "NewModelWizard";
    private NewModelFilePage newModelFilePage;
    private SelectDiagramKindPage selectDiagramKindPage;
    private SelectDiagramCategoryPage selectDiagramCategoryPage;
    private IWorkbench workbench;

    public CreateModelWizard() {
        this.setWindowTitle(Messages.CreateModelWizard_new_papyrus_model_title);
    }

    public void addPages() {
        this.addPageIfNotNull((IWizardPage)this.newModelFilePage);
        this.addPageIfNotNull((IWizardPage)this.selectDiagramCategoryPage);
        this.addPageIfNotNull((IWizardPage)this.selectDiagramKindPage);
    }

    protected final void addPageIfNotNull(IWizardPage page) {
        if (page != null) {
            this.addPage(page);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(NEW_MODEL_SETTINGS);
        if (section == null) {
            section = workbenchSettings.addNewSection(NEW_MODEL_SETTINGS);
        }
        this.setDialogSettings(section);
        this.newModelFilePage = this.createNewModelFilePage(selection);
        this.selectDiagramCategoryPage = this.createSelectDiagramCategoryPage();
        this.selectDiagramKindPage = this.createSelectDiagramKindPage();
    }

    public boolean performFinish() {
        DiResourceSetExt diResourceSet = new DiResourceSetExt();
        String[] diagramCategoryIds = this.getDiagramCategoryIds();
        if (diagramCategoryIds.length == 0) {
            return false;
        }
        String diagramCategoryId = diagramCategoryIds[0];
        IFile newFile = this.createNewModelFile(diagramCategoryId);
        this.createAndOpenPapyrusModel(diResourceSet, newFile, diagramCategoryId);
        this.saveDiagramCategorySettings();
        this.saveDiagramKindSettings();
        return true;
    }

    protected boolean createAndOpenPapyrusModel(DiResourceSet diResourceSet, IFile newFile, String diagramCategoryId) {
        if (newFile == null) {
            return false;
        }
        this.createPapyrusModels(diResourceSet, newFile);
        this.initDomainModel(diResourceSet, newFile, diagramCategoryId);
        this.initDiagramModel(diResourceSet, diagramCategoryId);
        this.openDiagram(newFile);
        return true;
    }

    protected String[] getDiagramCategoryIds() {
        if (this.selectDiagramCategoryPage != null) {
            return this.selectDiagramCategoryPage.getDiagramCategories();
        }
        return null;
    }

    protected String getDiagramFileExtension(String diagramCategoryId) {
        return this.getDiagramFileExtension(diagramCategoryId, "di");
    }

    protected String getDiagramFileExtension(String categoryId, String defaultExtension) {
        DiagramCategoryDescriptor diagramCategory = this.getDiagramCategoryMap().get(categoryId);
        String extensionPrefix = diagramCategory != null ? diagramCategory.getExtensionPrefix() : null;
        return extensionPrefix != null ? String.valueOf(extensionPrefix) + "." + defaultExtension : defaultExtension;
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        return new NewModelFilePage(selection);
    }

    protected SelectDiagramCategoryPage createSelectDiagramCategoryPage() {
        return new SelectDiagramCategoryPage();
    }

    protected SelectDiagramKindPage createSelectDiagramKindPage() {
        return new SelectDiagramKindPage(new SelectDiagramKindPage.CategoryProvider(){

            public String[] getCurrentCategories() {
                return CreateModelWizard.this.getDiagramCategoryIds();
            }
        });
    }

    protected IFile createNewModelFile(String categoryId) {
        return this.newModelFilePage.createNewFile();
    }

    protected void initDomainModel(DiResourceSet diResourceSet, IFile newFile, String diagramCategoryId) {
        boolean isToInitFromTemplate;
        boolean bl = isToInitFromTemplate = this.selectDiagramKindPage.getTemplatePath() != null;
        if (isToInitFromTemplate) {
            this.initDomainModelFromTemplate(diResourceSet);
        } else {
            this.createEmptyDomainModel(diResourceSet, diagramCategoryId);
        }
    }

    protected void initDomainModelFromTemplate(DiResourceSet diResourceSet) {
        this.getCommandStack(diResourceSet).execute((Command)new InitFromTemplateCommand(diResourceSet.getTransactionalEditingDomain(), diResourceSet, this.selectDiagramKindPage.getTemplatePluginId(), this.selectDiagramKindPage.getTemplatePath(), this.selectDiagramKindPage.getNotationTemplatePath(), this.selectDiagramKindPage.getDiTemplatePath()));
    }

    protected void createEmptyDomainModel(DiResourceSet diResourceSet, String diagramCategoryId) {
        try {
            IModelCreationCommand creationCommand = this.getDiagramCategoryMap().get(diagramCategoryId).getCommand();
            creationCommand.createModel(diResourceSet);
        }
        catch (BackboneException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void createPapyrusModels(DiResourceSet diResourceSet, IFile newFile) {
        NewPapyrusModelCommand command = new NewPapyrusModelCommand((ModelSet)diResourceSet, newFile);
        this.getCommandStack(diResourceSet).execute((Command)command);
    }

    protected void saveDiagramCategorySettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            SettingsHelper settingsHelper = new SettingsHelper(settings);
            settingsHelper.saveDefaultDiagramCategory(this.getDiagramCategoryIds());
        }
    }

    protected void saveDiagramKindSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return;
        }
        SettingsHelper settingsHelper = new SettingsHelper(settings);
        String[] stringArray = this.getDiagramCategoryIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (this.selectDiagramKindPage.isRememberCurrentSelection()) {
                this.saveDefaultDiagramKinds(settingsHelper, category);
                this.saveDefaultTemplates(settingsHelper, category);
            } else {
                settingsHelper.saveDefaultDiagramKinds(category, Collections.<String>emptyList());
                settingsHelper.saveDefaultTemplates(category, Collections.<String>emptyList());
            }
            ++n2;
        }
        settingsHelper.saveRememberCurrentSelection(this.selectDiagramKindPage.isRememberCurrentSelection());
    }

    private void saveDefaultDiagramKinds(SettingsHelper settingsHelper, String category) {
        String[] selected = this.selectDiagramKindPage.getSelectedDiagramKinds(category);
        settingsHelper.saveDefaultDiagramKinds(category, Arrays.asList(selected));
    }

    private void saveDefaultTemplates(SettingsHelper settingsHelper, String category) {
        if (!this.selectDiagramKindPage.templatesEnabled()) {
            return;
        }
        String path = this.selectDiagramKindPage.getTemplatePath();
        settingsHelper.saveDefaultTemplates(category, Collections.singletonList(path));
    }

    protected void openDiagram(IFile newFile) {
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
            catch (PartInitException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected void initDiagramModel(DiResourceSet diResourceSet, String categoryId) {
        this.initDiagrams(diResourceSet, categoryId);
        this.saveDiagram(diResourceSet);
    }

    private void saveDiagram(DiResourceSet diResourceSet) {
        try {
            diResourceSet.save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void initDiagrams(DiResourceSet diResourceSet, String categoryId) {
        this.initDiagrams(diResourceSet, null, categoryId);
    }

    protected void initDiagrams(DiResourceSet resourceSet, EObject root, String categoryId) {
        List<ICreationCommand> creationCommands = this.getDiagramKindsFor(categoryId);
        String diagramName = this.selectDiagramKindPage.getDiagramName();
        if (creationCommands.isEmpty()) {
            this.createEmptyDiagramEditor(resourceSet);
        } else {
            int i = 0;
            while (i < creationCommands.size()) {
                creationCommands.get(i).createDiagram(resourceSet, root, diagramName);
                ++i;
            }
        }
    }

    protected List<ICreationCommand> getDiagramKindsFor(String categoryId) {
        return this.selectDiagramKindPage.getCreationCommands(categoryId);
    }

    private void createEmptyDiagramEditor(DiResourceSet diResourceSet) {
        EditorUtils.getTransactionalIPageMngr((Resource)diResourceSet.getDiResource(), (TransactionalEditingDomain)diResourceSet.getTransactionalEditingDomain());
    }

    protected final CommandStack getCommandStack(DiResourceSet diResourceSet) {
        return diResourceSet.getTransactionalEditingDomain().getCommandStack();
    }

    protected Map<String, DiagramCategoryDescriptor> getDiagramCategoryMap() {
        return DiagramCategoryRegistry.getInstance().getDiagramCategoryMap();
    }

    public IStatus diagramCategoryChanged(String ... newCategories) {
        if (this.newModelFilePage != null) {
            String firstCategory;
            String string = firstCategory = newCategories.length > 0 ? newCategories[0] : null;
            if (newCategories.length > 0) {
                return this.newModelFilePage.diagramExtensionChanged(this.getDiagramFileExtension(firstCategory));
            }
        }
        return Status.OK_STATUS;
    }

    public static class DiResourceSetExt
    extends DiResourceSet {
        public void setFilenameWithoutExtension(IPath filenameWithoutExtension) {
            super.setFilenameWithoutExtension(filenameWithoutExtension);
        }
    }
}

