/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.wizards.Activator;
import org.eclipse.papyrus.wizards.Messages;
import org.eclipse.papyrus.wizards.NewPapyrusProjectWizard;
import org.eclipse.papyrus.wizards.pages.SelectDiagramCategoryPage;

public class NewPapyrusProjectWithMultiModelsWizard
extends NewPapyrusProjectWizard {
    private boolean myDoNotCreateModelForNoDiagrams;
    public static final String WIZARD_ID = "org.eclipse.papyrus.wizards.1createproject.several";

    public NewPapyrusProjectWithMultiModelsWizard() {
        this(false);
    }

    public NewPapyrusProjectWithMultiModelsWizard(boolean doNotCreateModelForNoDiagrams) {
        this.myDoNotCreateModelForNoDiagrams = doNotCreateModelForNoDiagrams;
    }

    protected SelectDiagramCategoryPage createSelectDiagramCategoryPage() {
        return new SelectDiagramCategoryPage(true);
    }

    public boolean performFinish() {
        IProject newProjectHandle;
        try {
            newProjectHandle = this.createNewProject();
        }
        catch (CoreException e) {
            Activator.log.error(Messages.NewPapyrusProjectWithMultiModelsWizard_exception_on_project_opening, (Throwable)e);
            return false;
        }
        if (newProjectHandle == null) {
            return false;
        }
        String[] stringArray = this.getDiagramCategoryIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (!this.myDoNotCreateModelForNoDiagrams || !this.getDiagramKindsFor(category).isEmpty()) {
                IFile newFile = this.createNewModelFile(category);
                DiResourceSet diResourceSet = new DiResourceSet();
                this.createAndOpenPapyrusModel(diResourceSet, newFile, category);
            }
            ++n2;
        }
        this.saveDiagramCategorySettings();
        this.saveDiagramKindSettings();
        return true;
    }
}

