/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.wizards.category;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.papyrus.resource.IModel;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.papyrus.wizards.CreateModelWizard;

public class PapyrusModelFromExistingDomainModelCommand
extends RecordingCommand {
    private final ModelSet myDiResourceSet;
    private final IPath myFileNameWithoutExtension;
    private final EObject myRoot;

    public PapyrusModelFromExistingDomainModelCommand(ModelSet diResourceSet, IFile newFile, EObject root) {
        super(diResourceSet.getTransactionalEditingDomain());
        this.myDiResourceSet = diResourceSet;
        this.myFileNameWithoutExtension = newFile.getFullPath().removeFileExtension();
        ((CreateModelWizard.DiResourceSetExt)diResourceSet).setFilenameWithoutExtension(this.myFileNameWithoutExtension);
        this.myRoot = root;
    }

    protected void doExecute() {
        IModel model = this.myDiResourceSet.getModel("org.eclipse.papyrus.resource.sasheditor.SashModel");
        model.createModel(this.myFileNameWithoutExtension);
        model = this.myDiResourceSet.getModel("org.eclipse.papyrus.resource.notation.NotationModel");
        model.createModel(this.myFileNameWithoutExtension);
        UmlModel umlModel = new UmlModel(){

            public void createModel(IPath fullPath) {
                try {
                    this.resourceURI = PapyrusModelFromExistingDomainModelCommand.this.myRoot.eResource().getURI();
                    this.resource = this.getResourceSet().getResource(this.resourceURI, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.myDiResourceSet.registerModel((IModel)umlModel);
        umlModel.createModel(null);
    }
}

