/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.wizards.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRootElementPage
extends WizardPage {
    protected EObject selectedModelElement;
    private TreeViewer modelViewer;
    private final Resource myDomainModelResource;
    public static final String PAGE_ID = "SelectRootPage";

    public SelectRootElementPage(IFile file) {
        super(PAGE_ID);
        this.setTitle(Messages.SelectRootElementPage_select_root_element_title);
        this.setDescription(Messages.SelectRootElementPage_select_root_element_desc);
        this.myDomainModelResource = this.getResourceForFile(file);
    }

    public EObject getModelElement() {
        return this.selectedModelElement;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        plate.setLayout((Layout)layout);
        this.setControl((Control)plate);
        Label label = new Label(plate, 0);
        label.setLayoutData((Object)new GridData(32));
        this.modelViewer = new TreeViewer(plate, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.modelViewer.getTree().setLayoutData((Object)layoutData);
        ComposedAdapterFactory adapterFactory = this.createAdapterFactory();
        this.modelViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.modelViewer.setInput((Object)this.myDomainModelResource);
        this.selectedModelElement = this.getModelRoot(this.myDomainModelResource);
        this.modelViewer.setSelection((ISelection)(this.selectedModelElement == null ? new StructuredSelection() : new StructuredSelection((Object)this.selectedModelElement)));
        this.modelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectRootElementPage.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.setPageComplete(this.validatePage());
    }

    private EObject getModelRoot(Resource modelResource) {
        if (modelResource == null) {
            return null;
        }
        return (EObject)modelResource.getContents().get(0);
    }

    private Resource getResourceForFile(IFile file) {
        if (file == null) {
            return null;
        }
        return new ModelSet().getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
    }

    protected void updateSelection(IStructuredSelection selection) {
        this.selectedModelElement = null;
        if (selection.size() == 1) {
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof IWrapperItemProvider) {
                selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
            }
            if (selectedElement instanceof FeatureMap.Entry) {
                selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
            }
            if (selectedElement instanceof EObject) {
                this.selectedModelElement = (EObject)selectedElement;
            }
        }
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        return this.selectedModelElement != null;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }
}

