/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.SingleTableMultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class VPDMultitenantPolicy
extends SingleTableMultitenantPolicy {
    protected String vpdIdentifier;
    protected String vpdIdentifierFieldName;

    public VPDMultitenantPolicy(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public void addTenantDiscriminatorField(String property, DatabaseField field) {
        super.addTenantDiscriminatorField(property, field);
        this.vpdIdentifier = property;
        this.vpdIdentifierFieldName = field.getName();
    }

    public void addToTableDefinition(TableDefinition tableDefinition) {
        tableDefinition.setCreateVPDCalls(true, this.vpdIdentifierFieldName);
    }

    public MultitenantPolicy clone(ClassDescriptor descriptor) {
        VPDMultitenantPolicy clonedPolicy = new VPDMultitenantPolicy(descriptor);
        clonedPolicy.includeTenantCriteria = this.includeTenantCriteria;
        clonedPolicy.tenantDiscriminatorFields = this.tenantDiscriminatorFields;
        clonedPolicy.vpdIdentifier = this.vpdIdentifier;
        clonedPolicy.vpdIdentifierFieldName = this.vpdIdentifierFieldName;
        return clonedPolicy;
    }

    public String getVPDIdentifier() {
        return this.vpdIdentifier;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        String vpdIdentifier = session.getProject().getVPDIdentifier();
        if (vpdIdentifier != null) {
            if (!vpdIdentifier.equals(this.getVPDIdentifier())) {
                throw ValidationException.multipleVPDIdentifiersSpecified(vpdIdentifier, session.getProject().getVPDLastIdentifierClassName(), this.getVPDIdentifier(), this.getDescriptor().getJavaClassName());
            }
        } else {
            session.getProject().setVPDIdentifier(this.getVPDIdentifier());
            session.getProject().setVPDLastIdentifierClassName(this.getDescriptor().getJavaClassName());
        }
    }
}

