/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import org.eclipse.photran.internal.core.preprocessor.c.IToken;
import org.eclipse.photran.internal.core.preprocessor.c.TokenUtil;

public class Token
implements IToken,
Cloneable {
    private int fKind;
    private int fOffset;
    private int fEndOffset;
    private IToken fNextToken;
    Object fSource;
    private char[] fPreWhiteSpace;
    private IToken fParent;
    private final int fOrigOffset;

    Token(int kind, Object source, int offset, int endOffset) {
        this.fKind = kind;
        this.fOffset = offset;
        this.fEndOffset = endOffset;
        this.fSource = source;
        this.fPreWhiteSpace = new char[0];
        this.fParent = null;
        this.fOrigOffset = offset;
    }

    Token(int kind, Object source, int offset, int endOffset, char[] preWhiteSpace) {
        this.fKind = kind;
        this.fOffset = offset;
        this.fEndOffset = endOffset;
        this.fSource = source;
        this.fPreWhiteSpace = preWhiteSpace;
        this.fParent = null;
        this.fOrigOffset = offset;
    }

    public final int getType() {
        return this.fKind;
    }

    public final int getOffset() {
        return this.fOffset;
    }

    public final int getEndOffset() {
        return this.fEndOffset;
    }

    public final int getLength() {
        return this.fEndOffset - this.fOffset;
    }

    public final IToken getNext() {
        return this.fNextToken;
    }

    public final void setType(int kind) {
        this.fKind = kind;
    }

    public final void setNext(IToken t) {
        this.fNextToken = t;
    }

    public void setOffset(int offset, int endOffset) {
        this.fOffset = offset;
        this.fEndOffset = endOffset;
    }

    public void shiftOffset(int shift) {
        this.fOffset += shift;
        this.fEndOffset += shift;
    }

    public char[] getCharImage() {
        return TokenUtil.getImage(this.getType());
    }

    public String toString() {
        return this.getImage();
    }

    public final boolean isOperator() {
        return TokenUtil.isOperator(this.fKind);
    }

    public String getImage() {
        return new String(this.getCharImage());
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final char[] getCharPrecedingWhiteSpace() {
        return this.fPreWhiteSpace;
    }

    public final String getPrecedingWhiteSpace() {
        return new String(this.getCharPrecedingWhiteSpace());
    }

    public final void setPrecedingWhiteSpace(char[] whiteSpace) {
        this.fPreWhiteSpace = whiteSpace;
    }

    public final IToken getParent() {
        return this.fParent;
    }

    public final void setParent(IToken parent) {
        this.fParent = parent;
    }

    public final int getOrigOffset() {
        return this.fOrigOffset;
    }

    public String getIncludeFile() {
        return null;
    }
}

