/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.lexer.FixedFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.FixedFormLexerPrepass;
import org.eclipse.photran.internal.core.lexer.FixedFormReplacement;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.ILexer;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.IToken;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.LineAppendingReader;
import org.eclipse.photran.internal.core.lexer.SingleCharReader;
import org.eclipse.photran.internal.core.lexer.Terminal;

public class FixedFormLexerPhase2
implements ILexer {
    private FreeFormLexerPhase2 freeLexer2;
    private IToken nextToken = null;

    public FixedFormLexerPhase2(Reader in, IFile file, String filename) {
        final LineAppendingReader input = new LineAppendingReader(in);
        final FixedFormLexerPrepass prepass = new FixedFormLexerPrepass(input);
        SingleCharReader prepassReader = new SingleCharReader(){

            public int read() throws IOException {
                try {
                    return prepass.read();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
            }

            public void close() throws IOException {
                input.close();
            }
        };
        FixedFormLexerPhase1 fixedLexer1 = new FixedFormLexerPhase1(prepassReader, prepass, file, filename);
        this.freeLexer2 = new FreeFormLexerPhase2(fixedLexer1){

            protected void modifyPreprocessorDirective(IToken t) {
                IPreprocessorReplacement ppr = t.getPreprocessorDirective();
                if (ppr != null && ppr instanceof FixedFormReplacement) {
                    FixedFormReplacement ffr = (FixedFormReplacement)ppr;
                    String replStr = ffr.toString();
                    replStr = replStr.replaceAll("=", "");
                    ffr.setReplacementText(replStr);
                }
            }
        };
    }

    public IToken yylex() throws IOException, LexerException {
        if (this.nextToken == null) {
            this.nextToken = this.freeLexer2.yylex();
        }
        IToken t = this.nextToken;
        this.nextToken = this.freeLexer2.yylex();
        if (t.getTerminal() == Terminal.T_IDENT) {
            while (this.nextToken.getTerminal() == Terminal.T_IDENT || this.nextToken.getTerminal() == Terminal.T_ICON || this.nextToken.getTerminal() == Terminal.T_UNDERSCORE) {
                t.setText(String.valueOf(t.getText()) + this.nextToken.getText());
                this.nextToken = this.freeLexer2.yylex();
            }
        }
        return t;
    }

    public String getFilename() {
        return this.freeLexer2.getFilename();
    }

    public int getLastTokenLine() {
        return this.freeLexer2.getLastTokenLine();
    }

    public int getLastTokenCol() {
        return this.freeLexer2.getLastTokenCol();
    }

    public FileOrIFile getLastTokenFile() {
        return this.freeLexer2.getLastTokenFile();
    }

    public int getLastTokenFileOffset() {
        return this.freeLexer2.getLastTokenFileOffset();
    }

    public int getLastTokenStreamOffset() {
        return this.freeLexer2.getLastTokenStreamOffset();
    }

    public int getLastTokenLength() {
        return this.freeLexer2.getLastTokenLength();
    }

    public void setTokenAsCurrent(IToken token) {
        throw new UnsupportedOperationException();
    }
}

