/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.lexer.ILexer;
import org.eclipse.photran.internal.core.lexer.IToken;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeFormLexerPhase2
implements ILexer {
    private ILexer yylex;
    private Vector<IToken> tokenStream = new Vector();
    private Vector<Integer> lineNumbers = new Vector();
    private Vector<Integer> colNumbers = new Vector();
    private Vector<FileOrIFile> files = new Vector();
    private Vector<Integer> fileOffsets = new Vector();
    private Vector<Integer> streamOffsets = new Vector();
    private Vector<Integer> lengths = new Vector();
    private ListIterator<IToken> tokenIt;
    private ListIterator<Integer> lineIt;
    private ListIterator<Integer> colIt;
    private ListIterator<FileOrIFile> fileIt;
    private ListIterator<Integer> fileOffsetIt;
    private ListIterator<Integer> streamOffsetIt;
    private ListIterator<Integer> lengthIt;
    private IToken lastToken = null;
    private FileOrIFile lastTokenFile = null;
    private int lastTokenLine = 1;
    private int lastTokenCol = 1;
    private int lastTokenFileOffset = 0;
    private int lastTokenStreamOffset = 0;
    private int lastTokenLength = 0;
    private int firstTokenPos = 0;
    private int idPos = -1;
    private VarDeclIdPosPair varDeclIdPosPair = null;
    private boolean openContextComma = false;
    private boolean openContextEquals = false;
    private boolean letterFollowsParenthetical = false;
    private int tokenFollowingParentheticalPos = -1;
    private int[] parenDepth;
    private boolean[] retainAsKeyword;
    HashMap<Terminal, LinkedList<Rule>> rules = new HashMap();
    private LinkedList<Rule> ruleList;
    private final Terminal ANY_TOKEN = new Terminal("any token");
    private final Terminal ANY_DEFINED_OPERATOR = new Terminal("any defined operator");
    private final Terminal ALWAYS_RETURN_TRUE = new Terminal("always return true");
    private final Terminal ALWAYS_RETURN_FALSE = new Terminal("always return false");
    private Pattern idPattern = Pattern.compile("[A-Za-z][A-Za-z0-9_]*([ \t]*=)?");
    private Pattern starredTypePattern = Pattern.compile("[A-Za-z]+\\*[0-9]+");
    private Pattern iconPattern = Pattern.compile("[0-9]+|[0-9]+(E|e)[0-9]+\\.[0-9]+");

    public FreeFormLexerPhase2(ILexer phase1Lexer) {
        this.yylex = phase1Lexer;
        this.buildAdditionalRules();
    }

    @Override
    public IToken yylex() throws IOException, LexerException {
        if (this.tokenIt == null || !this.tokenIt.hasNext()) {
            this.processNextStatement();
        }
        if (this.tokenIt.hasNext()) {
            this.lastToken = this.tokenIt.next();
            this.lastTokenLine = this.lineIt.next();
            this.lastTokenCol = this.colIt.next();
            this.lastTokenFile = this.fileIt.next();
            this.lastTokenFileOffset = this.fileOffsetIt.next();
            this.lastTokenStreamOffset = this.streamOffsetIt.next();
            this.lastTokenLength = this.lengthIt.next();
            this.lastToken.setLine(this.lastTokenLine);
            this.lastToken.setCol(this.lastTokenCol);
            this.lastToken.setPhysicalFile(this.lastTokenFile);
            this.lastToken.setFileOffset(this.lastTokenFileOffset);
            this.lastToken.setStreamOffset(this.lastTokenStreamOffset);
            this.lastToken.setLength(this.lastTokenLength);
            return this.lastToken;
        }
        return null;
    }

    private void processNextStatement() throws IOException, LexerException {
        this.readNextStatement();
        this.retainAsKeyword = new boolean[this.tokenStream.size()];
        int i = 0;
        while (i < this.retainAsKeyword.length) {
            this.retainAsKeyword[i] = false;
            ++i;
        }
        int n = this.firstTokenPos = this.stmtBeginsWithLabel() ? 1 : 0;
        if (this.stmtBeginsWithNameColon()) {
            this.firstTokenPos += 2;
        }
        this.parenDepth = new int[this.tokenStream.size()];
        i = 0;
        while (i < this.parenDepth.length) {
            this.parenDepth[i] = 0;
            ++i;
        }
        this.salesScan();
        this.markSalesChanges();
        this.idPos = this.getSubprogramDeclIdPos();
        this.varDeclIdPosPair = this.getVarDeclIdPos();
        this.markAdditionalChanges();
        this.markSubprogramChanges();
        this.markFortran2003Changes();
        this.applyChanges();
        this.tokenIt = this.tokenStream.listIterator();
        this.lineIt = this.lineNumbers.listIterator();
        this.colIt = this.colNumbers.listIterator();
        this.fileIt = this.files.listIterator();
        this.fileOffsetIt = this.fileOffsets.listIterator();
        this.streamOffsetIt = this.streamOffsets.listIterator();
        this.lengthIt = this.lengths.listIterator();
    }

    private void readNextStatement() throws IOException, LexerException {
        IToken t;
        this.tokenStream.clear();
        this.lineNumbers.clear();
        this.colNumbers.clear();
        this.files.clear();
        this.fileOffsets.clear();
        this.streamOffsets.clear();
        this.lengths.clear();
        do {
            if ((t = this.yylex.yylex()) == null) continue;
            this.tokenStream.add(t);
            this.lineNumbers.add(new Integer(this.yylex.getLastTokenLine()));
            this.colNumbers.add(new Integer(this.yylex.getLastTokenCol()));
            this.files.add(this.yylex.getLastTokenFile());
            this.fileOffsets.add(new Integer(this.yylex.getLastTokenFileOffset()));
            this.streamOffsets.add(new Integer(this.yylex.getLastTokenStreamOffset()));
            this.lengths.add(new Integer(this.yylex.getLastTokenLength()));
        } while (t != null && t.getTerminal() != Terminal.T_EOS && t.getTerminal() != Terminal.END_OF_INPUT);
    }

    private void salesScan() {
        this.openContextComma = false;
        this.openContextEquals = false;
        this.letterFollowsParenthetical = false;
        int currentParenDepth = 0;
        boolean justClosedParen = false;
        boolean firstParenthetical = true;
        boolean inArrayLiteral = false;
        int i = 0;
        while (i < this.tokenStream.size()) {
            IToken t = this.tokenStream.elementAt(i);
            if (currentParenDepth == 0) {
                if (t.getTerminal() == Terminal.T_LPARENSLASH) {
                    inArrayLiteral = true;
                } else if (t.getTerminal() == Terminal.T_SLASHRPAREN) {
                    inArrayLiteral = false;
                }
                if (!inArrayLiteral) {
                    if (t.getTerminal() == Terminal.T_COMMA) {
                        this.openContextComma = true;
                    } else if (t.getTerminal() == Terminal.T_EQUALS || t.getTerminal() == Terminal.T_EQGREATERTHAN) {
                        this.openContextEquals = true;
                    } else if (this.endsWithEquals(t)) {
                        this.openContextEquals = true;
                    }
                    if (justClosedParen && firstParenthetical) {
                        firstParenthetical = false;
                        this.tokenFollowingParentheticalPos = i;
                        this.letterFollowsParenthetical = t.getText().trim().length() > 0 && Character.isLetter(t.getText().trim().charAt(0));
                    }
                }
            }
            justClosedParen = false;
            if (t.getTerminal() != Terminal.T_LPAREN && t.getTerminal() == Terminal.T_RPAREN) {
                --currentParenDepth;
                justClosedParen = true;
            }
            this.parenDepth[i] = ++currentParenDepth;
            ++i;
        }
    }

    private void markSalesChanges() {
        if (!this.openContextComma && !this.openContextEquals) {
            this.retainAsKeyword[this.firstTokenPos] = true;
        }
        if (this.openContextEquals && !this.openContextComma) {
            this.retainAsKeyword[this.firstTokenPos] = false;
        }
        if (this.openContextComma) {
            this.retainAsKeyword[this.firstTokenPos] = true;
        }
        if (this.letterFollowsParenthetical) {
            this.retainAsKeyword[this.firstTokenPos] = true;
            this.retainAsKeyword[this.tokenFollowingParentheticalPos] = this.tokenStream.elementAt(this.firstTokenPos).getTerminal() == Terminal.T_IF && !this.openContextEquals;
        }
    }

    private void buildAdditionalRules() {
        this.shouldAlwaysBeKeyword(Terminal.T_TRUE);
        this.shouldAlwaysBeKeyword(Terminal.T_FALSE);
        this.addRule(Terminal.T_NULL, new MustBeFollowedBy(Terminal.T_LPAREN, Terminal.T_RPAREN));
        this.addRule(Terminal.T_PRECISION, new MustBePrecededBy(Terminal.T_DOUBLE));
        this.addRules(Terminal.T_POINTER, new MustBePartOfTypeDecl(), new MustBePrecededBy(Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_PARAMETER);
        this.applySameRulesTo(Terminal.T_PUBLIC);
        this.applySameRulesTo(Terminal.T_PRIVATE);
        this.applySameRulesTo(Terminal.T_ALLOCATABLE);
        this.applySameRulesTo(Terminal.T_DIMENSION);
        this.applySameRulesTo(Terminal.T_EXTERNAL);
        this.applySameRulesTo(Terminal.T_INTENT);
        this.applySameRulesTo(Terminal.T_OPTIONAL);
        this.applySameRulesTo(Terminal.T_SAVE);
        this.applySameRulesTo(Terminal.T_TARGET);
        this.applySameRulesTo(Terminal.T_CODIMENSION);
        this.applySameRulesTo(Terminal.T_CONTIGUOUS);
        this.applySameRulesTo(Terminal.T_ASYNCHRONOUS);
        this.applySameRulesTo(Terminal.T_PROTECTED);
        this.applySameRulesTo(Terminal.T_VALUE);
        this.applySameRulesTo(Terminal.T_VOLATILE);
        this.applySameRulesTo(Terminal.T_BIND);
        this.addRules(Terminal.T_INTRINSIC, new MustBePartOfTypeDeclOrStmtMustStartWith(Terminal.T_USE), new MustBePrecededBy(Terminal.T_COMMA));
        this.addRule(Terminal.T_IS, new MustBePrecededByOneOf(Terminal.T_TYPE, Terminal.T_CLASS));
        this.addRule(Terminal.T_ASSOCIATE, new MustBePrecededBy(Terminal.T_END));
        this.addRules(Terminal.T_TYPE, new StmtMustStartWithOneOf(Terminal.T_END, Terminal.T_IMPLICIT, Terminal.T_SELECT), new MustBePrecededByOneOf(Terminal.T_END, Terminal.T_IMPLICIT, Terminal.T_COMMA, Terminal.T_SELECT));
        this.addRule(Terminal.T_ABSTRACT, new MustBeFollowedBy(Terminal.T_INTERFACE));
        this.addRules(Terminal.T_INTERFACE, new StmtMustStartWithOneOf(Terminal.T_END, Terminal.T_ABSTRACT), new MustBePrecededByOneOf(Terminal.T_END, Terminal.T_ABSTRACT));
        this.addRules(Terminal.T_KINDEQ, new MustBePartOfTypeDeclOrStmtMustStartWith(Terminal.T_IMPLICIT), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_LENEQ);
        this.addRules(Terminal.T_IN, new MustBePartOfTypeDeclOrStmtMustStartWith(Terminal.T_INTENT), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_IN, Terminal.T_OUT));
        this.applySameRulesTo(Terminal.T_OUT);
        this.applySameRulesTo(Terminal.T_INOUT);
        this.addRules(Terminal.T_NONE, new MustBePrecededBy(Terminal.T_IMPLICIT), new MustBeFollowedBy(Terminal.T_EOS));
        this.addRules(Terminal.T_INTEGER, new StmtMustStartWith(Terminal.T_IMPLICIT), new MustBePrecededByOneOf(Terminal.T_IMPLICIT, Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_REAL);
        this.applySameRulesTo(Terminal.T_DOUBLECOMPLEX);
        this.applySameRulesTo(Terminal.T_DOUBLEPRECISION);
        this.applySameRulesTo(Terminal.T_LOGICAL);
        this.applySameRulesTo(Terminal.T_CHARACTER);
        this.applySameRulesTo(Terminal.T_DOUBLE);
        this.addRules(Terminal.T_COMPLEX, new StmtMustStartWithOneOf(Terminal.T_IMPLICIT, Terminal.T_DOUBLE), new MustBePrecededByOneOf(Terminal.T_IMPLICIT, Terminal.T_COMMA, Terminal.T_DOUBLE));
        this.addRules(Terminal.T_STATEQ, new StmtMustStartWithOneOf(Terminal.T_ALLOCATE, Terminal.T_DEALLOCATE), new MustBePrecededBy(Terminal.T_COMMA), new ParenDepthMustBe(1));
        this.addRules(Terminal.T_WHERE, new StmtMustStartWith(Terminal.T_END), new MustBePrecededByOneOf(Terminal.T_END, Terminal.T_ELSE));
        this.addRules(Terminal.T_FORALL, new StmtMustStartWith(Terminal.T_END), new MustBePrecededBy(Terminal.T_END));
        this.addRule(Terminal.T_THEN, new StmtMustStartWithOneOf(Terminal.T_IF, Terminal.T_ELSE, Terminal.T_ELSEIF));
        this.addRules(Terminal.T_IF, new StmtMustStartWithOneOf(Terminal.T_ELSE, Terminal.T_END), new MustBePrecededByOneOf(Terminal.T_ELSE, Terminal.T_END));
        this.addRules(Terminal.T_CASE, new StmtMustStartWith(Terminal.T_SELECT), new MustBePrecededBy(Terminal.T_SELECT));
        this.addRules(Terminal.T_SELECT, new StmtMustStartWith(Terminal.T_END), new MustBePrecededBy(Terminal.T_END));
        this.addRule(Terminal.T_DEFAULT, new MustBePrecededByOneOf(Terminal.T_CASE, Terminal.T_CLASS));
        this.addRule(Terminal.T_WHILE, new MustBePrecededByOneOf(Terminal.T_DO, Terminal.T_COMMA, Terminal.T_ICON));
        this.addRules(Terminal.T_DO, new StmtMustStartWith(Terminal.T_END), new MustBePrecededBy(Terminal.T_END));
        this.addRules(Terminal.T_TO, new StmtMustStartWithOneOf(Terminal.T_GO, Terminal.T_ASSIGN), new MustBePrecededByOneOf(Terminal.T_GO, Terminal.T_ICON));
        this.addRules(Terminal.T_FILEEQ, new StmtMustStartWithOneOf(Terminal.T_OPEN, Terminal.T_INQUIRE), new MustBeInSpecList(), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_ACCESSEQ);
        this.applySameRulesTo(Terminal.T_FORMEQ);
        this.applySameRulesTo(Terminal.T_RECLEQ);
        this.applySameRulesTo(Terminal.T_BLANKEQ);
        this.applySameRulesTo(Terminal.T_POSITIONEQ);
        this.applySameRulesTo(Terminal.T_ACTIONEQ);
        this.applySameRulesTo(Terminal.T_DELIMEQ);
        this.applySameRulesTo(Terminal.T_PADEQ);
        this.addRules(Terminal.T_STATUSEQ, new StmtMustStartWithOneOf(Terminal.T_OPEN, Terminal.T_CLOSE), new MustBeInSpecList(), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_COMMA));
        this.addRules(Terminal.T_UNITEQ, new MustBeInSpecList(), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_ERREQ);
        this.applySameRulesTo(Terminal.T_IOSTATEQ);
        this.applySameRulesTo(Terminal.T_STREAMEQ);
        this.applySameRulesTo(Terminal.T_PENDINGEQ);
        this.applySameRulesTo(Terminal.T_POSEQ);
        this.applySameRulesTo(Terminal.T_IDEQ);
        this.applySameRulesTo(Terminal.T_SIGNEQ);
        this.applySameRulesTo(Terminal.T_ROUNDEQ);
        this.applySameRulesTo(Terminal.T_IOMSGEQ);
        this.applySameRulesTo(Terminal.T_ENCODINGEQ);
        this.applySameRulesTo(Terminal.T_DECIMALEQ);
        this.applySameRulesTo(Terminal.T_ASYNCHRONOUSEQ);
        this.applySameRulesTo(Terminal.T_CONVERTEQ);
        this.addRules(Terminal.T_FMTEQ, new StmtMustStartWithOneOf(Terminal.T_READ, Terminal.T_WRITE), new MustBeInSpecList(), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_RECEQ);
        this.applySameRulesTo(Terminal.T_ENDEQ);
        this.applySameRulesTo(Terminal.T_EOREQ);
        this.applySameRulesTo(Terminal.T_NMLEQ);
        this.applySameRulesTo(Terminal.T_ADVANCEEQ);
        this.applySameRulesTo(Terminal.T_SIZEEQ);
        this.applySameRulesTo(Terminal.T_OR);
        this.addRules(Terminal.T_IOLENGTHEQ, new StmtMustStartWith(Terminal.T_INQUIRE), new MustBeInSpecList(), new MustBePrecededByOneOf(Terminal.T_LPAREN, Terminal.T_COMMA));
        this.applySameRulesTo(Terminal.T_EXISTEQ);
        this.applySameRulesTo(Terminal.T_OPENEDEQ);
        this.applySameRulesTo(Terminal.T_NUMBEREQ);
        this.applySameRulesTo(Terminal.T_NAMEDEQ);
        this.applySameRulesTo(Terminal.T_NAMEEQ);
        this.applySameRulesTo(Terminal.T_SEQUENTIALEQ);
        this.applySameRulesTo(Terminal.T_DIRECTEQ);
        this.applySameRulesTo(Terminal.T_FORMATTEDEQ);
        this.applySameRulesTo(Terminal.T_UNFORMATTEDEQ);
        this.applySameRulesTo(Terminal.T_NEXTRECEQ);
        this.applySameRulesTo(Terminal.T_READEQ);
        this.applySameRulesTo(Terminal.T_WRITEEQ);
        this.applySameRulesTo(Terminal.T_READWRITEEQ);
        this.addRules(Terminal.T_PROGRAM, new StmtMustStartWith(Terminal.T_END), new MustBePrecededBy(Terminal.T_END));
        this.applySameRulesTo(Terminal.T_MODULE);
        this.applySameRulesTo(Terminal.T_BLOCK);
        this.applySameRulesTo(Terminal.T_BLOCKDATA);
        this.applySameRulesTo(Terminal.T_FUNCTION);
        this.applySameRulesTo(Terminal.T_SUBROUTINE);
        this.applySameRulesTo(Terminal.T_SUBMODULE);
        this.addRules(Terminal.T_DATA, new StmtMustStartWithOneOf(Terminal.T_BLOCK, Terminal.T_END), new MustBePrecededBy(Terminal.T_BLOCK));
        this.addRules(Terminal.T_ONLY, new StmtMustStartWith(Terminal.T_USE), new MustBePrecededBy(Terminal.T_COMMA), new MustBeFollowedBy(Terminal.T_COLON));
        this.addRules(Terminal.T_PROCEDURE, new StmtMustStartWithOneOf(Terminal.T_MODULE, Terminal.T_END), new MustBePrecededByOneOf(Terminal.T_MODULE, Terminal.T_END));
        this.addRule(Terminal.T_OPERATOR, new MustBeFollowedBy(Terminal.T_LPAREN, this.ANY_DEFINED_OPERATOR, Terminal.T_RPAREN));
        this.addRule(Terminal.T_ASSIGNMENT, new MustBeFollowedBy(Terminal.T_LPAREN, Terminal.T_EQUALS, Terminal.T_RPAREN));
        this.addRules(Terminal.T_CRITICAL, new StmtMustStartWith(Terminal.T_END), new MustBePrecededBy(Terminal.T_END));
        this.addRule(Terminal.T_ALL, new Or(new And(new StmtMustStartWith(Terminal.T_SYNC), new MustBePrecededBy(Terminal.T_SYNC)), new And(new StmtMustStartWith(Terminal.T_ALL), new MustBeFollowedBy(Terminal.T_STOP))));
        this.addRules(Terminal.T_IMAGES, new StmtMustStartWith(Terminal.T_SYNC), new MustBePrecededBy(Terminal.T_SYNC));
        this.applySameRulesTo(Terminal.T_MEMORY);
        this.addRules(Terminal.T_STOP, new StmtMustStartWith(Terminal.T_ALL), new MustBePrecededBy(Terminal.T_ALL));
    }

    private void markAdditionalChanges() {
        if (this.varDeclIdPosPair != null) {
            this.retainAsKeyword[this.firstTokenPos] = true;
        }
        int tokenPos = this.firstTokenPos;
        while (tokenPos < this.tokenStream.size()) {
            LinkedList<Rule> ruleList;
            Terminal thistokenTerminal = this.tokenStream.elementAt(tokenPos).getTerminal();
            if (this.rules.containsKey(thistokenTerminal) && this.allRulesApplyToTokenAtPosition(ruleList = this.rules.get(thistokenTerminal), tokenPos)) {
                this.retainAsKeyword[tokenPos] = true;
            }
            ++tokenPos;
        }
    }

    private boolean allRulesApplyToTokenAtPosition(LinkedList<Rule> ruleList, int tokenPos) {
        ListIterator it = ruleList.listIterator();
        while (it.hasNext()) {
            Rule r = (Rule)it.next();
            if (r.appliesToTokenAt(tokenPos)) continue;
            return false;
        }
        return true;
    }

    private void markSubprogramChanges() {
        if (this.idPos == -1) {
            return;
        }
        int i = 0;
        while (i < this.tokenStream.size()) {
            if (this.parenDepth[i] == 0) {
                this.retainAsKeyword[i] = i != this.idPos;
            }
            ++i;
        }
    }

    private void markFortran2003Changes() {
        block18: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_END || this.tokenStream.size() <= 1 || this.tokenStream.elementAt(this.firstTokenPos + 1).getTerminal() != Terminal.T_SELECT) break block19;
                                        this.tokenStream.elementAt(this.firstTokenPos).setTerminal(Terminal.T_ENDBEFORESELECT);
                                        break block18;
                                    }
                                    if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_TYPE) break block20;
                                    if (this.firstTokenPos + 1 < this.tokenStream.size() && this.tokenStream.elementAt(this.firstTokenPos + 1).getTerminal() == Terminal.T_EQUALS) {
                                        this.retainAsKeyword[this.firstTokenPos] = false;
                                    } else {
                                        int i = this.firstTokenPos + 1;
                                        while (i < this.tokenStream.size()) {
                                            Terminal t = this.tokenStream.elementAt(i).getTerminal();
                                            if (t == Terminal.T_EXTENDS || t == Terminal.T_ABSTRACT || t == Terminal.T_BIND || t == Terminal.T_KIND || t == Terminal.T_LEN || t == Terminal.T_IS) {
                                                this.retainAsKeyword[i] = this.parenDepth[i] == 0 && i != this.idPos;
                                            } else if (t == Terminal.T_COLON) break block18;
                                            ++i;
                                        }
                                    }
                                    break block18;
                                }
                                if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_INTEGER) break block21;
                                int i = this.firstTokenPos + 1;
                                while (i < this.tokenStream.size() - 2) {
                                    Terminal t = this.tokenStream.elementAt(i).getTerminal();
                                    Terminal la1 = this.tokenStream.elementAt(i + 1).getTerminal();
                                    Terminal la2 = this.tokenStream.elementAt(i + 2).getTerminal();
                                    if ((t == Terminal.T_KIND || t == Terminal.T_LEN) && la1 == Terminal.T_COLON && la2 == Terminal.T_COLON) {
                                        this.retainAsKeyword[i] = this.parenDepth[i] == 0 && i != this.idPos;
                                    } else if (t == Terminal.T_COLON) break block18;
                                    ++i;
                                }
                                break block18;
                            }
                            if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_PROCEDURE) break block22;
                            this.retainAsKeyword[this.firstTokenPos] = true;
                            int i = this.firstTokenPos + 1;
                            while (i < this.tokenStream.size()) {
                                Terminal t = this.tokenStream.elementAt(i).getTerminal();
                                if (t == Terminal.T_PASS || t == Terminal.T_NOPASS || t == Terminal.T_NON_OVERRIDABLE || t == Terminal.T_DEFERRED) {
                                    this.retainAsKeyword[i] = this.parenDepth[i] == 0 && i != this.idPos;
                                }
                                ++i;
                            }
                            break block18;
                        }
                        if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_ENUM) break block23;
                        this.retainAsKeyword[this.firstTokenPos] = true;
                        int i = this.firstTokenPos + 1;
                        while (i < this.tokenStream.size()) {
                            Terminal t = this.tokenStream.elementAt(i).getTerminal();
                            if (t == Terminal.T_BIND) {
                                this.retainAsKeyword[i] = this.parenDepth[i] == 0 && i != this.idPos;
                            }
                            ++i;
                        }
                        break block18;
                    }
                    if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_END) break block24;
                    int i = this.firstTokenPos + 1;
                    while (i < this.tokenStream.size()) {
                        Terminal t = this.tokenStream.elementAt(i).getTerminal();
                        if (t == Terminal.T_ENUM) {
                            this.retainAsKeyword[i] = this.parenDepth[i] == 0 && i != this.idPos;
                        }
                        ++i;
                    }
                    break block18;
                }
                if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_IMPORT) break block25;
                this.retainAsKeyword[this.firstTokenPos] = true;
                break block18;
            }
            if (this.tokenStream.elementAt(this.firstTokenPos).getTerminal() != Terminal.T_GENERIC || this.tokenStream.size() <= 1 || this.tokenStream.elementAt(this.firstTokenPos + 1).getTerminal() != Terminal.T_COLON) break block18;
            this.retainAsKeyword[this.firstTokenPos] = true;
            int i = this.firstTokenPos + 1;
            while (i < this.tokenStream.size()) {
                Terminal t = this.tokenStream.elementAt(i).getTerminal();
                if ((t == Terminal.T_READ || t == Terminal.T_WRITE) && i + 1 < this.tokenStream.size() && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_LPAREN) {
                    this.retainAsKeyword[i] = true;
                }
                ++i;
            }
        }
    }

    private int getSubprogramDeclIdPos() {
        int idPos = -1;
        int i = 0;
        while (i < this.tokenStream.size()) {
            if (this.parenDepth[i] == 0) {
                IToken pret = this.tokenStream.elementAt(i > 0 ? i - 1 : 0);
                IToken t = this.tokenStream.elementAt(i);
                if (!(this.isType(t) || t.getTerminal() == Terminal.T_PRECISION && pret.getTerminal() == Terminal.T_DOUBLE || t.getTerminal() == Terminal.T_COMPLEX && pret.getTerminal() == Terminal.T_DOUBLE || t.getTerminal() == Terminal.T_RECURSIVE || t.getTerminal() == Terminal.T_PURE || t.getTerminal() == Terminal.T_IMPURE || t.getTerminal() == Terminal.T_MODULE || t.getTerminal() == Terminal.T_ELEMENTAL || t.getTerminal() == Terminal.T_FUNCTION || t.getTerminal() == Terminal.T_SUBROUTINE || t.getTerminal() == Terminal.T_RPAREN)) {
                    return -1;
                }
                if (t.getTerminal() == Terminal.T_FUNCTION || t.getTerminal() == Terminal.T_SUBROUTINE) {
                    idPos = i;
                    break;
                }
            }
            ++i;
        }
        if (idPos != i) {
            return -1;
        }
        ++i;
        if (++idPos >= this.tokenStream.size()) {
            return -1;
        }
        ++i;
        while (i < this.tokenStream.size()) {
            IToken t;
            if (this.parenDepth[i] == 0 && (t = this.tokenStream.elementAt(i)).getTerminal() != Terminal.T_RPAREN && t.getTerminal() != Terminal.T_RESULT && t.getTerminal() != Terminal.T_UNDERSCORE && t.getTerminal() != Terminal.T_IDENT && t.getTerminal() != Terminal.T_EOS && t.getTerminal() != Terminal.T_BIND) {
                return -1;
            }
            ++i;
        }
        return idPos;
    }

    private VarDeclIdPosPair getVarDeclIdPos() {
        if (this.idPos != -1) {
            return null;
        }
        int i = this.firstTokenPos;
        if (!this.isType(this.tokenStream.elementAt(i))) {
            return null;
        }
        i = i + 3 < this.tokenStream.size() && this.tokenStream.elementAt(i).getTerminal() == Terminal.T_TYPE && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_LPAREN && this.tokenStream.elementAt(i + 3).getTerminal() == Terminal.T_RPAREN ? (i += 4) : (i + 3 < this.tokenStream.size() && this.tokenStream.elementAt(i).getTerminal() == Terminal.T_DOUBLE && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_PRECISION && this.tokenStream.elementAt(i + 2).getTerminal() == Terminal.T_ASTERISK && this.tokenStream.elementAt(i + 3).getTerminal() == Terminal.T_ICON ? (i += 4) : (i + 3 < this.tokenStream.size() && this.tokenStream.elementAt(i).getTerminal() == Terminal.T_DOUBLE && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_COMPLEX && this.tokenStream.elementAt(i + 2).getTerminal() == Terminal.T_ASTERISK && this.tokenStream.elementAt(i + 3).getTerminal() == Terminal.T_ICON ? (i += 4) : (i + 2 < this.tokenStream.size() && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_ASTERISK && this.tokenStream.elementAt(i + 2).getTerminal() == Terminal.T_ICON ? (i += 3) : (i + 2 < this.tokenStream.size() && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_ASTERISK && this.tokenStream.elementAt(i + 2).getTerminal() == Terminal.T_LPAREN ? (i += 3) : (i + 1 < this.tokenStream.size() && this.tokenStream.elementAt(i).getTerminal() == Terminal.T_DOUBLE && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_PRECISION ? (i += 2) : (i + 1 < this.tokenStream.size() && this.tokenStream.elementAt(i).getTerminal() == Terminal.T_DOUBLE && this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_COMPLEX ? (i += 2) : ++i))))));
        int declKeywordsStartAt = i;
        int declIdentifierPos = -1;
        boolean lastWasComma = false;
        while (i < this.tokenStream.size() && declIdentifierPos == -1) {
            IToken t = this.tokenStream.elementAt(i);
            if (this.parenDepth[i] <= 0 && t.getTerminal() != Terminal.T_RPAREN) {
                if (t.getTerminal() == Terminal.T_COMMA) {
                    lastWasComma = true;
                } else if (lastWasComma) {
                    lastWasComma = false;
                } else {
                    if (t.getTerminal() == Terminal.T_COLON) {
                        if (i + 2 >= this.tokenStream.size()) {
                            return null;
                        }
                        if (this.tokenStream.elementAt(i + 1).getTerminal() == Terminal.T_COLON) {
                            declIdentifierPos = i + 2;
                            break;
                        }
                        return null;
                    }
                    declIdentifierPos = i;
                    break;
                }
            }
            ++i;
        }
        VarDeclIdPosPair ret = new VarDeclIdPosPair();
        ret.declKeywordsStartAt = declKeywordsStartAt;
        ret.declIdentifierPos = declIdentifierPos;
        return ret;
    }

    private void shouldAlwaysBeKeyword(Terminal tokenTerminal) {
        this.ruleList = new LinkedList();
        this.applyRulesTo(tokenTerminal);
    }

    private void addRule(Terminal tokenTerminal, Rule rule) {
        this.ruleList = new LinkedList();
        this.ruleList.add(rule);
        this.applyRulesTo(tokenTerminal);
    }

    private void addRules(Terminal tokenTerminal, Rule rule1, Rule rule2) {
        this.ruleList = new LinkedList();
        this.ruleList.add(rule1);
        this.ruleList.add(rule2);
        this.applyRulesTo(tokenTerminal);
    }

    private void addRules(Terminal tokenTerminal, Rule rule1, Rule rule2, Rule rule3) {
        this.ruleList = new LinkedList();
        this.ruleList.add(rule1);
        this.ruleList.add(rule2);
        this.ruleList.add(rule3);
        this.applyRulesTo(tokenTerminal);
    }

    private void applySameRulesTo(Terminal tokenTerminal) {
        this.applyRulesTo(tokenTerminal);
    }

    private void applyRulesTo(Terminal tokenTerminal) {
        if (this.rules.containsKey(tokenTerminal)) {
            throw new Error("Multiple rule lists specified for token " + tokenTerminal);
        }
        this.rules.put(tokenTerminal, this.ruleList);
    }

    protected void modifyPreprocessorDirective(IToken t) {
    }

    private boolean matchToken(int tokenPos, Terminal targetTerminal) {
        IToken actualToken;
        if (targetTerminal == this.ALWAYS_RETURN_TRUE) {
            return true;
        }
        if (targetTerminal == this.ALWAYS_RETURN_FALSE) {
            return false;
        }
        if (tokenPos < 0 || tokenPos >= this.tokenStream.size()) {
            return false;
        }
        IToken iToken = actualToken = tokenPos >= 0 && tokenPos <= this.tokenStream.size() ? this.tokenStream.elementAt(tokenPos) : null;
        if (targetTerminal == this.ANY_TOKEN) {
            return actualToken != null;
        }
        if (targetTerminal == this.ANY_DEFINED_OPERATOR) {
            return actualToken != null && (actualToken.getText().startsWith(".") && actualToken.getText().endsWith(".") || actualToken.getTerminal() == Terminal.T_SLASHSLASH || actualToken.getTerminal() == Terminal.T_ASTERISK || actualToken.getTerminal() == Terminal.T_POW || actualToken.getTerminal() == Terminal.T_SLASH || actualToken.getTerminal() == Terminal.T_PLUS || actualToken.getTerminal() == Terminal.T_MINUS || actualToken.getTerminal() == Terminal.T_EQ || actualToken.getTerminal() == Terminal.T_LE || actualToken.getTerminal() == Terminal.T_LT || actualToken.getTerminal() == Terminal.T_NE || actualToken.getTerminal() == Terminal.T_GE || actualToken.getTerminal() == Terminal.T_GT || actualToken.getTerminal() == Terminal.T_EQEQ || actualToken.getTerminal() == Terminal.T_SLASHEQ || actualToken.getTerminal() == Terminal.T_LESSTHAN || actualToken.getTerminal() == Terminal.T_LESSTHANEQ || actualToken.getTerminal() == Terminal.T_GREATERTHAN || actualToken.getTerminal() == Terminal.T_GREATERTHANEQ || actualToken.getTerminal() == Terminal.T_NOT || actualToken.getTerminal() == Terminal.T_AND || actualToken.getTerminal() == Terminal.T_OR || actualToken.getTerminal() == Terminal.T_EQV || actualToken.getTerminal() == Terminal.T_NEQV);
        }
        return actualToken.getTerminal() == targetTerminal;
    }

    private void applyChanges() {
        IToken t;
        Vector<Integer> identifiersContainingEqualSigns = new Vector<Integer>();
        Vector<Integer> identifiersStarred = new Vector<Integer>();
        int i = 0;
        while (i < this.tokenStream.size()) {
            IToken t2 = this.tokenStream.elementAt(i);
            if (this.canBeIdentifier(t2) && !this.retainAsKeyword[i]) {
                t2.setTerminal(Terminal.T_IDENT);
                if (this.endsWithEquals(t2)) {
                    identifiersContainingEqualSigns.add(new Integer(i));
                }
            } else if (this.isStarredType(t2) && !this.retainAsKeyword[i]) {
                t2.setTerminal(Terminal.T_IDENT);
                identifiersStarred.add(new Integer(i));
            }
            ++i;
        }
        int j = 0;
        while (j < identifiersContainingEqualSigns.size()) {
            int i2 = (Integer)identifiersContainingEqualSigns.elementAt(j);
            t = this.tokenStream.elementAt(i2 + j);
            IToken afterT = i2 < this.tokenStream.size() - 1 ? this.tokenStream.elementAt(i2 + j + 1) : null;
            String textWithoutEquals = t.getText().substring(0, t.getText().length() - 1);
            String tokenText = textWithoutEquals.trim();
            String whiteAfter = textWithoutEquals.substring(tokenText.length());
            if (afterT != null && afterT.getTerminal() == Terminal.T_EQUALS && t.getWhiteAfter().equals("") && afterT.getWhiteBefore().equals("")) {
                afterT.setTerminal(Terminal.T_EQEQ);
                afterT.setText("==");
                t.setText(tokenText);
                t.setWhiteAfter(whiteAfter);
            } else {
                Token eq = new Token(Terminal.T_EQUALS, "=");
                t.setText(tokenText);
                t.setWhiteAfter(whiteAfter);
                this.lengths.setElementAt(new Integer(tokenText.length()), i2 + j);
                this.tokenStream.insertElementAt(eq, i2 + j + 1);
                this.lineNumbers.insertElementAt(this.lineNumbers.get(i2 + j), i2 + j + 1);
                this.colNumbers.insertElementAt(new Integer(this.colNumbers.get(i2 + j) + textWithoutEquals.length()), i2 + j + 1);
                this.files.insertElementAt(this.files.get(i2 + j), i2 + j + 1);
                this.fileOffsets.insertElementAt(new Integer(this.fileOffsets.get(i2 + j) + textWithoutEquals.length()), i2 + j + 1);
                this.streamOffsets.insertElementAt(new Integer(this.streamOffsets.get(i2 + j) + textWithoutEquals.length()), i2 + j + 1);
                this.lengths.insertElementAt(new Integer(1), i2 + j + 1);
            }
            this.modifyPreprocessorDirective(t);
            ++j;
        }
        j = 0;
        while (j < identifiersStarred.size()) {
            int i3 = (Integer)identifiersStarred.elementAt(j);
            t = this.tokenStream.elementAt(i3);
            int starPos = t.getText().indexOf("*");
            String textBeforeStar = t.getText().substring(0, starPos);
            String textAfterStar = t.getText().substring(starPos + 1, t.getText().length());
            Token star = new Token(Terminal.T_ASTERISK, "*");
            Token num = new Token(Terminal.T_ICON, textAfterStar);
            t.setText(textBeforeStar);
            this.lengths.setElementAt(new Integer(textBeforeStar.length()), i3 + 2 * j);
            this.tokenStream.insertElementAt(star, i3 + 2 * j + 1);
            this.lineNumbers.insertElementAt(this.lineNumbers.get(i3 + 2 * j), i3 + 2 * j + 1);
            this.colNumbers.insertElementAt(new Integer(this.colNumbers.get(i3 + 2 * j) + textBeforeStar.length()), i3 + 2 * j + 1);
            this.files.insertElementAt(this.files.get(i3 + 2 * j), i3 + 2 * j + 1);
            this.fileOffsets.insertElementAt(new Integer(this.fileOffsets.get(i3 + 2 * j) + textBeforeStar.length()), i3 + 2 * j + 1);
            this.streamOffsets.insertElementAt(new Integer(this.streamOffsets.get(i3 + 2 * j) + textBeforeStar.length()), i3 + 2 * j + 1);
            this.lengths.insertElementAt(new Integer(1), i3 + 2 * j + 1);
            this.tokenStream.insertElementAt(num, i3 + 2 * j + 2);
            this.lineNumbers.insertElementAt(this.lineNumbers.get(i3 + 2 * j + 1), i3 + 2 * j + 2);
            this.colNumbers.insertElementAt(new Integer(this.colNumbers.get(i3 + 2 * j + 1) + textBeforeStar.length() + 1), i3 + 2 * j + 2);
            this.files.insertElementAt(this.files.get(i3 + 2 * j), i3 + 2 * j + 1);
            this.fileOffsets.insertElementAt(new Integer(this.fileOffsets.get(i3 + 2 * j + 1) + textBeforeStar.length() + 1), i3 + 2 * j + 2);
            this.streamOffsets.insertElementAt(new Integer(this.streamOffsets.get(i3 + 2 * j + 1) + textBeforeStar.length() + 1), i3 + 2 * j + 2);
            this.lengths.insertElementAt(new Integer(1), i3 + 2 * j + 2);
            ++j;
        }
    }

    private boolean canBeIdentifier(IToken t) {
        return this.idPattern.matcher(t.getText()).matches();
    }

    private boolean isStarredType(IToken t) {
        return this.starredTypePattern.matcher(t.getText()).matches();
    }

    private boolean endsWithEquals(IToken t) {
        if (t.getText().length() < 2) {
            return false;
        }
        if (!this.canBeIdentifier(t)) {
            return false;
        }
        char lastChar = t.getText().charAt(t.getText().length() - 1);
        if (lastChar != '=') {
            return false;
        }
        char nextToLastChar = t.getText().charAt(t.getText().length() - 2);
        return Character.isLetter(nextToLastChar) || Character.isWhitespace(nextToLastChar);
    }

    private boolean isType(IToken type) {
        return type.getTerminal() == Terminal.T_CHARACTER || type.getTerminal() == Terminal.T_COMPLEX || type.getTerminal() == Terminal.T_DOUBLE || type.getTerminal() == Terminal.T_DOUBLECOMPLEX || type.getTerminal() == Terminal.T_DOUBLEPRECISION || type.getTerminal() == Terminal.T_INTEGER || type.getTerminal() == Terminal.T_LOGICAL || type.getTerminal() == Terminal.T_REAL || type.getTerminal() == Terminal.T_TYPE;
    }

    private boolean stmtBeginsWithLabel() {
        return this.iconPattern.matcher(this.tokenStream.elementAt(0).getText()).matches();
    }

    private boolean stmtBeginsWithNameColon() {
        if (this.firstTokenPos + 1 >= this.tokenStream.size()) {
            return false;
        }
        return this.tokenStream.elementAt(this.firstTokenPos).getTerminal() == Terminal.T_IDENT && this.tokenStream.elementAt(this.firstTokenPos + 1).getTerminal() == Terminal.T_COLON;
    }

    public void printCurrentStatementOn(PrintStream s) {
        int i = 0;
        while (i < this.tokenStream.size()) {
            IToken t = this.tokenStream.elementAt(i);
            s.print(t.getText().replaceAll("\\n", "<end of line>"));
            s.print(" ");
            ++i;
        }
        s.println();
    }

    public void printCurrentStatementTokensOn(PrintStream s) {
        int i = 0;
        while (i < this.tokenStream.size()) {
            IToken t = this.tokenStream.elementAt(i);
            s.print(t.getTerminal());
            s.print("(" + t.getText().replaceAll("\\n", "\\\\n") + ")");
            s.print("   ");
            ++i;
        }
        s.println();
    }

    @Override
    public String getFilename() {
        return this.yylex.getFilename();
    }

    @Override
    public int getLastTokenLine() {
        return this.lastTokenLine;
    }

    @Override
    public int getLastTokenCol() {
        return this.lastTokenCol;
    }

    @Override
    public FileOrIFile getLastTokenFile() {
        return this.lastTokenFile;
    }

    @Override
    public int getLastTokenFileOffset() {
        return this.lastTokenFileOffset;
    }

    @Override
    public int getLastTokenStreamOffset() {
        return this.lastTokenStreamOffset;
    }

    @Override
    public int getLastTokenLength() {
        return this.lastTokenLength;
    }

    @Override
    public void setTokenAsCurrent(IToken token) {
        throw new UnsupportedOperationException();
    }

    private final class And
    extends Rule {
        private Rule[] rules;

        public And(Rule rule1, Rule rule2) {
            this.rules = new Rule[]{rule1, rule2};
        }

        public boolean appliesToTokenAt(int tokenPos) {
            int i = 0;
            while (i < this.rules.length) {
                if (!this.rules[i].appliesToTokenAt(tokenPos)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private final class MustBeFollowedBy
    extends Rule {
        Terminal firstTokenAfterId;
        Terminal secondTokenAfterId;
        Terminal thirdTokenAfterId;

        public MustBeFollowedBy(Terminal tokenTerminal) {
            this.firstTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.secondTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.thirdTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.firstTokenAfterId = tokenTerminal;
        }

        public MustBeFollowedBy(Terminal tokenTerminal1, Terminal tokenTerminal2) {
            this.firstTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.secondTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.thirdTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.firstTokenAfterId = tokenTerminal1;
            this.secondTokenAfterId = tokenTerminal2;
        }

        public MustBeFollowedBy(Terminal tokenTerminal1, Terminal tokenTerminal2, Terminal tokenTerminal3) {
            this.firstTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.secondTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.thirdTokenAfterId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.firstTokenAfterId = tokenTerminal1;
            this.secondTokenAfterId = tokenTerminal2;
            this.thirdTokenAfterId = tokenTerminal3;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            return FreeFormLexerPhase2.this.matchToken(tokenPos + 1, this.firstTokenAfterId) && FreeFormLexerPhase2.this.matchToken(tokenPos + 2, this.secondTokenAfterId) && FreeFormLexerPhase2.this.matchToken(tokenPos + 3, this.thirdTokenAfterId);
        }
    }

    private final class MustBeInSpecList
    extends Rule {
        private MustBeInSpecList() {
        }

        public boolean appliesToTokenAt(int tokenPos) {
            IToken t = (IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(FreeFormLexerPhase2.this.firstTokenPos);
            int specListStartsAt = FreeFormLexerPhase2.this.firstTokenPos + 1;
            if (t.getTerminal() != Terminal.T_OPEN && t.getTerminal() != Terminal.T_CLOSE && t.getTerminal() != Terminal.T_READ && t.getTerminal() != Terminal.T_WRITE && t.getTerminal() != Terminal.T_BACKSPACE && t.getTerminal() != Terminal.T_ENDFILE && t.getTerminal() != Terminal.T_END && t.getTerminal() != Terminal.T_REWIND && t.getTerminal() != Terminal.T_INQUIRE) {
                if (t.getTerminal() != Terminal.T_IF || FreeFormLexerPhase2.this.tokenFollowingParentheticalPos < 0 || FreeFormLexerPhase2.this.tokenFollowingParentheticalPos >= FreeFormLexerPhase2.this.tokenStream.size()) {
                    return false;
                }
                t = (IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(FreeFormLexerPhase2.this.tokenFollowingParentheticalPos);
                if (t.getTerminal() != Terminal.T_OPEN && t.getTerminal() != Terminal.T_CLOSE && t.getTerminal() != Terminal.T_READ && t.getTerminal() != Terminal.T_WRITE && t.getTerminal() != Terminal.T_BACKSPACE && t.getTerminal() != Terminal.T_ENDFILE && t.getTerminal() != Terminal.T_END && t.getTerminal() != Terminal.T_REWIND && t.getTerminal() != Terminal.T_INQUIRE) {
                    return false;
                }
                specListStartsAt = FreeFormLexerPhase2.this.tokenFollowingParentheticalPos + 1;
            }
            if (t.getTerminal() == Terminal.T_END) {
                IToken iToken = t = FreeFormLexerPhase2.this.firstTokenPos + 1 >= FreeFormLexerPhase2.this.tokenStream.size() ? null : (IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(FreeFormLexerPhase2.this.firstTokenPos + 1);
                if (t == null) {
                    return false;
                }
                if (t.getTerminal() != Terminal.T_FILE) {
                    return false;
                }
                ++specListStartsAt;
            }
            IToken iToken = t = specListStartsAt >= FreeFormLexerPhase2.this.tokenStream.size() ? null : (IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(specListStartsAt);
            if (t == null || t.getTerminal() != Terminal.T_LPAREN) {
                return false;
            }
            int specListEndsAt = specListStartsAt;
            ++specListEndsAt;
            while (specListEndsAt < FreeFormLexerPhase2.this.tokenStream.size() && FreeFormLexerPhase2.this.parenDepth[specListEndsAt] > 0) {
                ++specListEndsAt;
            }
            IToken iToken2 = t = specListEndsAt >= FreeFormLexerPhase2.this.tokenStream.size() ? null : (IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(specListEndsAt);
            if (t == null || t.getTerminal() != Terminal.T_RPAREN) {
                return false;
            }
            return tokenPos >= specListStartsAt && tokenPos <= specListEndsAt && FreeFormLexerPhase2.this.parenDepth[tokenPos] == 1;
        }
    }

    private final class MustBePartOfTypeDecl
    extends Rule {
        private MustBePartOfTypeDecl() {
        }

        public boolean appliesToTokenAt(int tokenPos) {
            int declKeywordsStartAt = -1;
            int declIdentifierPos = -1;
            if (FreeFormLexerPhase2.this.varDeclIdPosPair != null) {
                declKeywordsStartAt = ((FreeFormLexerPhase2)FreeFormLexerPhase2.this).varDeclIdPosPair.declKeywordsStartAt;
                declIdentifierPos = ((FreeFormLexerPhase2)FreeFormLexerPhase2.this).varDeclIdPosPair.declIdentifierPos;
            } else if (FreeFormLexerPhase2.this.idPos > 0) {
                declKeywordsStartAt = 1;
                declIdentifierPos = FreeFormLexerPhase2.this.idPos;
            } else if (((IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(FreeFormLexerPhase2.this.firstTokenPos)).getTerminal() == Terminal.T_PROCEDURE || ((IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(FreeFormLexerPhase2.this.firstTokenPos)).getTerminal() == Terminal.T_GENERIC || ((IToken)FreeFormLexerPhase2.this.tokenStream.elementAt(FreeFormLexerPhase2.this.firstTokenPos)).getTerminal() == Terminal.T_CLASS) {
                declKeywordsStartAt = 1;
                declIdentifierPos = FreeFormLexerPhase2.this.tokenStream.size() - 1;
            } else {
                return false;
            }
            return tokenPos >= declKeywordsStartAt && tokenPos < declIdentifierPos && FreeFormLexerPhase2.this.parenDepth[tokenPos] <= 1;
        }
    }

    private final class MustBePartOfTypeDeclOrStmtMustStartWith
    extends Rule {
        private Terminal tokenTerminal;

        public MustBePartOfTypeDeclOrStmtMustStartWith(Terminal tokenTerminal) {
            this.tokenTerminal = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.tokenTerminal = tokenTerminal;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            return new MustBePartOfTypeDecl().appliesToTokenAt(tokenPos) || new StmtMustStartWith(this.tokenTerminal).appliesToTokenAt(tokenPos);
        }
    }

    private final class MustBePrecededBy
    extends Rule {
        Terminal secondTokenPriorId;
        Terminal firstTokenPriorId;

        public MustBePrecededBy(Terminal tokenTerminal) {
            this.secondTokenPriorId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.firstTokenPriorId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.firstTokenPriorId = tokenTerminal;
        }

        public MustBePrecededBy(Terminal tokenTerminal1, Terminal tokenTerminal2) {
            this.secondTokenPriorId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.firstTokenPriorId = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.secondTokenPriorId = tokenTerminal1;
            this.firstTokenPriorId = tokenTerminal2;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            return FreeFormLexerPhase2.this.matchToken(tokenPos - 2, this.secondTokenPriorId) && FreeFormLexerPhase2.this.matchToken(tokenPos - 1, this.firstTokenPriorId);
        }
    }

    private final class MustBePrecededByOneOf
    extends Rule {
        Terminal possibility1;
        Terminal possibility2;
        Terminal possibility3;
        Terminal possibility4;

        public MustBePrecededByOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2) {
            this.possibility1 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility2 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility3 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility4 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility1 = tokenTerminal1;
            this.possibility2 = tokenTerminal2;
        }

        public MustBePrecededByOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2, Terminal tokenTerminal3) {
            this.possibility1 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility2 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility3 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility4 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility1 = tokenTerminal1;
            this.possibility2 = tokenTerminal2;
            this.possibility3 = tokenTerminal3;
        }

        public MustBePrecededByOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2, Terminal tokenTerminal3, Terminal tokenTerminal4) {
            this.possibility1 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility2 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility3 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility4 = FreeFormLexerPhase2.this.ALWAYS_RETURN_FALSE;
            this.possibility1 = tokenTerminal1;
            this.possibility2 = tokenTerminal2;
            this.possibility3 = tokenTerminal3;
            this.possibility4 = tokenTerminal4;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            return FreeFormLexerPhase2.this.matchToken(tokenPos - 1, this.possibility1) || FreeFormLexerPhase2.this.matchToken(tokenPos - 1, this.possibility2) || FreeFormLexerPhase2.this.matchToken(tokenPos - 1, this.possibility3) || FreeFormLexerPhase2.this.matchToken(tokenPos - 1, this.possibility4);
        }
    }

    private final class Or
    extends Rule {
        private Rule[] rules;

        public Or(Rule rule1, Rule rule2) {
            this.rules = new Rule[]{rule1, rule2};
        }

        public boolean appliesToTokenAt(int tokenPos) {
            int i = 0;
            while (i < this.rules.length) {
                if (this.rules[i].appliesToTokenAt(tokenPos)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private final class ParenDepthMustBe
    extends Rule {
        private int depth;

        public ParenDepthMustBe(int depth) {
            this.depth = -1;
            this.depth = depth;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            return FreeFormLexerPhase2.this.parenDepth[tokenPos] == this.depth;
        }
    }

    private abstract class Rule {
        private Rule() {
        }

        public abstract boolean appliesToTokenAt(int var1);
    }

    private final class StmtMustStartWith
    extends Rule {
        private Terminal tokenTerminal;

        public StmtMustStartWith(Terminal tokenTerminal) {
            this.tokenTerminal = FreeFormLexerPhase2.this.ALWAYS_RETURN_TRUE;
            this.tokenTerminal = tokenTerminal;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            return (FreeFormLexerPhase2.this.matchToken(FreeFormLexerPhase2.this.firstTokenPos, this.tokenTerminal) || FreeFormLexerPhase2.this.matchToken(FreeFormLexerPhase2.this.tokenFollowingParentheticalPos, this.tokenTerminal)) && FreeFormLexerPhase2.this.retainAsKeyword[FreeFormLexerPhase2.this.firstTokenPos];
        }
    }

    private final class StmtMustStartWithOneOf
    extends Rule {
        private Terminal[] possibilities;

        public StmtMustStartWithOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2) {
            this.possibilities = new Terminal[2];
            this.possibilities[0] = tokenTerminal1;
            this.possibilities[1] = tokenTerminal2;
        }

        public StmtMustStartWithOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2, Terminal tokenTerminal3) {
            this.possibilities = new Terminal[3];
            this.possibilities[0] = tokenTerminal1;
            this.possibilities[1] = tokenTerminal2;
            this.possibilities[2] = tokenTerminal3;
        }

        public StmtMustStartWithOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2, Terminal tokenTerminal3, Terminal tokenTerminal4) {
            this.possibilities = new Terminal[4];
            this.possibilities[0] = tokenTerminal1;
            this.possibilities[1] = tokenTerminal2;
            this.possibilities[2] = tokenTerminal3;
            this.possibilities[3] = tokenTerminal4;
        }

        public StmtMustStartWithOneOf(Terminal tokenTerminal1, Terminal tokenTerminal2, Terminal tokenTerminal3, Terminal tokenTerminal4, Terminal tokenTerminal5, Terminal tokenTerminal6, Terminal tokenTerminal7, Terminal tokenTerminal8) {
            this.possibilities = new Terminal[8];
            this.possibilities[0] = tokenTerminal1;
            this.possibilities[1] = tokenTerminal2;
            this.possibilities[2] = tokenTerminal3;
            this.possibilities[3] = tokenTerminal4;
            this.possibilities[4] = tokenTerminal5;
            this.possibilities[5] = tokenTerminal6;
            this.possibilities[6] = tokenTerminal7;
            this.possibilities[7] = tokenTerminal8;
        }

        public boolean appliesToTokenAt(int tokenPos) {
            if (!FreeFormLexerPhase2.this.retainAsKeyword[FreeFormLexerPhase2.this.firstTokenPos]) {
                return false;
            }
            boolean match = false;
            int i = 0;
            while (i < this.possibilities.length && !match) {
                match = match || FreeFormLexerPhase2.this.matchToken(FreeFormLexerPhase2.this.firstTokenPos, this.possibilities[i]) && FreeFormLexerPhase2.this.retainAsKeyword[FreeFormLexerPhase2.this.firstTokenPos] || FreeFormLexerPhase2.this.matchToken(FreeFormLexerPhase2.this.tokenFollowingParentheticalPos, this.possibilities[i]) && FreeFormLexerPhase2.this.retainAsKeyword[FreeFormLexerPhase2.this.tokenFollowingParentheticalPos];
                ++i;
            }
            return match;
        }
    }

    private class VarDeclIdPosPair {
        public int declKeywordsStartAt = -1;
        public int declIdentifierPos = -1;

        private VarDeclIdPosPair() {
        }
    }
}

