/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTNodeUtil {
    private ASTNodeUtil() {
    }

    public static void removeFromTree(IASTNode node) {
        IASTNode parent = node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Cannot remove root node");
        }
        parent.replaceChild(node, null);
    }

    public static void replaceWith(IASTNode node, IASTNode newNode) {
        IASTNode parent = node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Cannot remove root node");
        }
        parent.replaceChild(node, newNode);
    }

    public static <T extends IASTNode> Set<T> findAll(IASTNode node, Class<T> clazz) {
        class V
        extends GenericASTVisitor {
            Set<T> result = new HashSet();
            private final /* synthetic */ Class val$clazz;

            V(Class clazz) {
                this.val$clazz = clazz;
            }

            public void visitASTNode(IASTNode node) {
                if (this.val$clazz.isAssignableFrom(node.getClass())) {
                    this.result.add(node);
                }
                this.traverseChildren(node);
            }

            public void visitToken(Token node) {
                if (this.val$clazz.isAssignableFrom(node.getClass())) {
                    this.result.add(node);
                }
            }
        }
        V v = new V(clazz);
        node.accept(v);
        return v.result;
    }

    public static <T extends IASTNode> T findNearestAncestor(IASTNode node, Class<T> targetClass) {
        IASTNode parent = node.getParent();
        while (parent != null) {
            if (targetClass.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static <T extends IASTNode> T findFirst(IASTNode node, final Class<T> clazz) {
        try {
            node.accept(new GenericASTVisitor(){

                public void visitASTNode(IASTNode node) {
                    if (clazz.isAssignableFrom(node.getClass())) {
                        throw new Notification(node);
                    }
                    this.traverseChildren(node);
                }

                public void visitToken(Token node) {
                    if (clazz.isAssignableFrom(node.getClass())) {
                        throw new Notification(node);
                    }
                }
            });
        }
        catch (Notification n) {
            return (T)((IASTNode)n.getResult());
        }
        return null;
    }

    public static <T extends IASTNode> T findLast(IASTNode node, Class<T> clazz) {
        class V
        extends GenericASTVisitor {
            T result = null;
            private final /* synthetic */ Class val$clazz;

            V(Class clazz) {
                this.val$clazz = clazz;
            }

            public void visitASTNode(IASTNode node) {
                if (this.val$clazz.isAssignableFrom(node.getClass())) {
                    this.result = node;
                }
                this.traverseChildren(node);
            }

            public void visitToken(Token node) {
                if (this.val$clazz.isAssignableFrom(node.getClass())) {
                    this.result = node;
                }
            }
        }
        V v = new V(clazz);
        node.accept(v);
        return v.result;
    }

    public static Token findFirstToken(IASTNode node) {
        return ASTNodeUtil.findFirst(node, Token.class);
    }

    public static Token findLastToken(IASTNode node) {
        return ASTNodeUtil.findLast(node, Token.class);
    }

    public static boolean isFirstChildInList(IASTNode node) {
        return node.getParent() != null && node.getParent() instanceof IASTListNode && ((IASTListNode)node.getParent()).size() > 0 && ((IASTListNode)node.getParent()).get(0) == node;
    }

    public static String toString(IASTNode node) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        node.printOn(new PrintStream(bs), null);
        return bs.toString();
    }

    public static void replaceWith(IASTNode node, final String literalString) {
        IASTNode copy = (IASTNode)node.clone();
        final Token firstToken = copy.findFirstToken();
        final Token lastToken = copy.findLastToken();
        if (firstToken == null) {
            throw new IllegalArgumentException("A node can only be replaced with a string if it contains at least one token");
        }
        copy.accept(new GenericASTVisitor(){

            public void visitToken(Token token) {
                if (token != firstToken) {
                    token.setWhiteBefore("");
                }
                token.setText(token == firstToken ? literalString : "");
                if (token != lastToken) {
                    token.setWhiteAfter("");
                }
            }
        });
        node.replaceWith(copy);
    }

    public static IPreprocessorReplacement print(IASTNode node, IPreprocessorReplacement currentPreprocessorDirective, PrintStream out) {
        for (IASTNode iASTNode : node.getChildren()) {
            currentPreprocessorDirective = iASTNode.printOn(out, currentPreprocessorDirective);
        }
        return currentPreprocessorDirective;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonNullIterator<T>
    implements Iterator<T> {
        private Iterator<T> wrappedIterator;
        private T next;

        public NonNullIterator(Iterator<T> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
            this.findNext();
        }

        private void findNext() {
            do {
                if (!this.wrappedIterator.hasNext()) {
                    this.next = null;
                    return;
                }
                this.next = this.wrappedIterator.next();
            } while (this.next == null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T result = this.next;
            this.findNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class Notification
    extends Error {
        private Object result;

        public Notification(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

