/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTImplicitStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroImplicitNoneRefactoring
extends FortranResourceRefactoring {
    public String getName() {
        return Messages.IntroImplicitNoneRefactoring_Name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.logVPGErrors(status, this.selectedFiles);
        try {
            for (IFile f : this.selectedFiles) {
                IFortranAST tempAST = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(f);
                if (tempAST == null) {
                    status.addError(Messages.bind((String)Messages.IntroImplicitNoneRefactoring_SelectedFileCannotBeParsed, (Object)f.getName()));
                    continue;
                }
                this.introduceImplicitNoneInFile(pm, tempAST.getRoot(), tempAST, f);
                ((PhotranVPG)this.vpg).releaseAST(f);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void introduceImplicitNoneInFile(IProgressMonitor progressMonitor, ScopingNode scopeNode, IFortranAST ast, IFile file) {
        assert (scopeNode != null);
        List<ScopingNode> nodeList = scopeNode.getAllContainedScopes();
        for (ScopingNode scope : nodeList) {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode || scope.isImplicitNone()) continue;
            ASTImplicitStmtNode implicitStmt = this.findExistingImplicitStatement(scope);
            if (implicitStmt != null) {
                implicitStmt.removeFromTree();
            }
            IASTListNode<IBodyConstruct> newDeclarations = this.constructDeclarations(scope);
            IASTListNode<? extends IASTNode> body = scope.getOrCreateBody();
            body.addAll(this.findIndexOfLastUseStmtIn(body) + 1, newDeclarations);
            Reindenter.reindent(newDeclarations, ast);
        }
        this.addChangeFromModifiedAST(file, progressMonitor);
    }

    private IASTListNode<IBodyConstruct> constructDeclarations(ScopingNode scope) {
        ArrayList<Definition> definitions = new ArrayList<Definition>(16);
        for (Definition def : scope.getAllDefinitions()) {
            if (def == null || !def.isImplicit()) continue;
            definitions.add(def);
        }
        StringBuilder newStmts = new StringBuilder();
        newStmts.append("implicit none" + EOL);
        for (Definition def : this.sort(definitions)) {
            newStmts.append(this.constructDeclaration(def));
        }
        return IntroImplicitNoneRefactoring.parseLiteralStatementSequence(newStmts.toString());
    }

    private ArrayList<Definition> sort(ArrayList<Definition> array) {
        int indexOfElementToInsert = 1;
        while (indexOfElementToInsert < array.size()) {
            Definition def = array.get(indexOfElementToInsert);
            int targetIndex = this.findInsertionIndexForSorting(array, indexOfElementToInsert);
            int i = indexOfElementToInsert - 1;
            while (i >= targetIndex) {
                array.set(i + 1, array.get(i));
                --i;
            }
            array.set(targetIndex, def);
            ++indexOfElementToInsert;
        }
        return array;
    }

    private int findInsertionIndexForSorting(ArrayList<Definition> array, int indexOfElementToInsert) {
        int beforeIndex = 0;
        while (beforeIndex < indexOfElementToInsert) {
            if (array.get(indexOfElementToInsert).getCanonicalizedName().compareTo(array.get(beforeIndex).getCanonicalizedName()) < 0) {
                return beforeIndex;
            }
            ++beforeIndex;
        }
        return indexOfElementToInsert;
    }

    private String constructDeclaration(Definition def) {
        Type type = def.getType();
        String typeString = type == null ? "type(unknown)" : type.toString();
        return String.valueOf(typeString) + " :: " + def.getCanonicalizedName() + EOL;
    }

    protected void doCreateChange(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
    }
}

