/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDoConstructNode;
import org.eclipse.photran.internal.core.parser.ASTIfConstructNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class RemoveRealAndDoublePrecisionLoopCountersRefactoring
extends FortranEditorRefactoring {
    private ASTProperLoopConstructNode selectedDoLoopNode = null;
    private boolean shouldReplaceWithDoWhileLoop = false;

    public String getName() {
        return Messages.RemoveRealAndDoublePrecisionLoopCountersRefactoring_Name;
    }

    public void setShouldReplaceWithDoWhileLoop(boolean value) {
        this.shouldReplaceWithDoWhileLoop = value;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        Type type;
        List<Definition> bindings;
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.selectedDoLoopNode = RemoveRealAndDoublePrecisionLoopCountersRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTProperLoopConstructNode.class);
        if (this.selectedDoLoopNode == null) {
            this.fail(Messages.RemoveRealAndDoublePrecisionLoopCountersRefactoring_PleaseSelectADoLoop);
        }
        if (this.selectedDoLoopNode.getLoopHeader().getLoopControl() == null) {
            this.fail(Messages.RemoveRealAndDoublePrecisionLoopCountersRefactoring_PleaseSelectACountedDoLoop);
        }
        if ((bindings = this.selectedDoLoopNode.getLoopHeader().getLoopControl().getVariableName().resolveBinding()).size() != 1) {
            this.fail(Messages.RemoveRealAndDoublePrecisionLoopCountersRefactoring_NoUniqueDeclaration);
        }
        if (!(type = bindings.get(0).getType()).equals(Type.REAL) && !type.equals(Type.DOUBLEPRECISION)) {
            this.fail(Messages.bind((String)Messages.RemoveRealAndDoublePrecisionLoopCountersRefactoring_NotRealOrDoublePrecision, (Object)type.toString()));
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        double dUb;
        String ifCheckLb = this.selectedDoLoopNode.getLoopHeader().getLoopControl().getLb().toString();
        String ifCheckUb = this.selectedDoLoopNode.getLoopHeader().getLoopControl().getUb().toString();
        String ifCheckVar = this.selectedDoLoopNode.getLoopHeader().getLoopControl().getVariableName().getText().toString();
        String ifCheckStep = null;
        ifCheckStep = this.selectedDoLoopNode.getLoopHeader().getLoopControl().getStep() != null ? this.selectedDoLoopNode.getLoopHeader().getLoopControl().getStep().toString() : " 1";
        String ifCheckIncrDecr = "";
        String ifCheckStr = "";
        double dLb = Double.valueOf(ifCheckLb.trim());
        if (dLb < (dUb = Double.valueOf(ifCheckUb.trim()).doubleValue())) {
            ifCheckStr = this.shouldReplaceWithDoWhileLoop ? String.valueOf(ifCheckVar) + " <=" + ifCheckUb : String.valueOf(ifCheckVar) + " >" + ifCheckUb;
            ifCheckIncrDecr = " +";
        } else {
            ifCheckStr = this.shouldReplaceWithDoWhileLoop ? String.valueOf(ifCheckVar) + " >=" + ifCheckUb : String.valueOf(ifCheckVar) + " <" + ifCheckUb;
            ifCheckIncrDecr = " -";
        }
        if (this.shouldReplaceWithDoWhileLoop) {
            this.insertNewDoWhileLoop(ifCheckLb, ifCheckVar, ifCheckStep, ifCheckIncrDecr, ifCheckStr);
        } else {
            this.insertNewDoLoop(ifCheckLb, ifCheckVar, ifCheckStep, ifCheckIncrDecr, ifCheckStr);
        }
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
    }

    private void insertNewDoLoop(String ifCheckLb, String ifCheckVar, String ifCheckStep, String ifCheckIncrDecr, String ifCheckStr) {
        this.insertInitialCounterAssignment(ifCheckVar, ifCheckLb);
        int sizeOfLoopControlString = this.selectedDoLoopNode.getLoopHeader().getLoopControl().toString().length();
        String replaceLoopControlStringWith = "";
        int i = 0;
        while (i < sizeOfLoopControlString) {
            replaceLoopControlStringWith = String.valueOf(replaceLoopControlStringWith) + " ";
            ++i;
        }
        this.selectedDoLoopNode.getLoopHeader().setLoopControl(null);
        this.selectedDoLoopNode.getLoopHeader().findLastToken().setWhiteBefore(String.valueOf(replaceLoopControlStringWith) + this.selectedDoLoopNode.getLoopHeader().findLastToken().getWhiteBefore());
        ASTAssignmentStmtNode incrDecrNode = this.insertCounterAssignment(ifCheckVar, ifCheckIncrDecr, ifCheckStep);
        IExecutionPartConstruct lastNodeInDoLoopBody = (IExecutionPartConstruct)this.selectedDoLoopNode.getBody().get(this.selectedDoLoopNode.getBody().size() - 1);
        String initialIndent = ScopingNode.getLocalScope(this.selectedDoLoopNode).getBody().findFirstToken().getWhiteBefore();
        initialIndent = initialIndent.substring(initialIndent.lastIndexOf(10) + 1);
        String programString = "";
        programString = "program p\n" + lastNodeInDoLoopBody.findFirstToken().getWhiteBefore() + "IF(" + ifCheckStr + ") THEN\n" + lastNodeInDoLoopBody.findFirstToken().getWhiteBefore() + initialIndent + "EXIT\n" + lastNodeInDoLoopBody.findFirstToken().getWhiteBefore() + "END IF" + EOL + "end program";
        ASTMainProgramNode programNode = (ASTMainProgramNode)RemoveRealAndDoublePrecisionLoopCountersRefactoring.parseLiteralProgramUnit(programString);
        ASTIfConstructNode ifNode = (ASTIfConstructNode)programNode.getBody().get(0);
        ifNode.setParent(this.selectedDoLoopNode.getParent());
        this.selectedDoLoopNode.getBody().insertAfter(incrDecrNode, ifNode);
    }

    private void insertNewDoWhileLoop(String ifCheckLb, String ifCheckVar, String ifCheckStep, String ifCheckIncrDecr, String ifCheckStr) {
        this.insertInitialCounterAssignment(ifCheckVar, ifCheckLb);
        this.insertCounterAssignment(ifCheckVar, ifCheckIncrDecr, ifCheckStep);
        String programString = "";
        programString = "program p\n" + this.selectedDoLoopNode.getLoopHeader().findFirstToken().getWhiteBefore() + "DO WHILE (" + ifCheckStr + ")" + this.selectedDoLoopNode.getLoopHeader().findLastToken().getWhiteBefore() + EOL + "EXIT\nENDDO" + EOL + "end program";
        ASTMainProgramNode programNode = (ASTMainProgramNode)RemoveRealAndDoublePrecisionLoopCountersRefactoring.parseLiteralProgramUnit(programString);
        ASTDoConstructNode doConstructNode = (ASTDoConstructNode)programNode.getBody().get(0);
        this.selectedDoLoopNode.setLoopHeader(doConstructNode.getLabelDoStmt());
        this.selectedDoLoopNode.getLoopHeader().findLastToken().setWhiteBefore(this.selectedDoLoopNode.getLoopHeader().findLastToken().getWhiteBefore());
    }

    private void insertInitialCounterAssignment(String ifCheckVar, String ifCheckLb) {
        String programString = "program p\n" + this.selectedDoLoopNode.findFirstToken().getWhiteBefore() + ifCheckVar + " =" + ifCheckLb + EOL + "end program";
        ASTMainProgramNode programNode = (ASTMainProgramNode)RemoveRealAndDoublePrecisionLoopCountersRefactoring.parseLiteralProgramUnit(programString);
        ASTAssignmentStmtNode initValNode = (ASTAssignmentStmtNode)programNode.getBody().get(0);
        initValNode.setParent(this.selectedDoLoopNode.getParent());
        ASTListNode doNode = (ASTListNode)this.selectedDoLoopNode.getParent();
        doNode.insertBefore(this.selectedDoLoopNode, initValNode);
    }

    private ASTAssignmentStmtNode insertCounterAssignment(String ifCheckVar, String ifCheckIncrDecr, String ifCheckStep) {
        IExecutionPartConstruct lastNodeInDoLoopBody = (IExecutionPartConstruct)this.selectedDoLoopNode.getBody().get(this.selectedDoLoopNode.getBody().size() - 1);
        String programString = "";
        programString = "program p\n" + lastNodeInDoLoopBody.findFirstToken().getWhiteBefore() + ifCheckVar + " = " + ifCheckVar + ifCheckIncrDecr + ifCheckStep + EOL + "end program";
        ASTMainProgramNode programNode = (ASTMainProgramNode)RemoveRealAndDoublePrecisionLoopCountersRefactoring.parseLiteralProgramUnit(programString);
        ASTAssignmentStmtNode incrDecrNode = (ASTAssignmentStmtNode)programNode.getBody().get(0);
        incrDecrNode.setParent(this.selectedDoLoopNode.getParent());
        this.selectedDoLoopNode.getBody().insertAfter(lastNodeInDoLoopBody, incrDecrNode);
        return incrDecrNode;
    }
}

