/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTArraySpecNode;
import org.eclipse.photran.internal.core.parser.ASTCharSelectorNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTInitializationNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceCharacterStarRefactoring
extends FortranEditorRefactoring {
    public String getName() {
        return Messages.ReplaceCharacterToCharacterLenRefactoring_Name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
        CharacterNodesVisitor characterVisitor = new CharacterNodesVisitor();
        this.astOfFileInEditor.accept(characterVisitor);
        if (characterVisitor.getList().size() < 1) {
            this.fail(Messages.ReplaceCharacterToCharacterLenRefactoring_CharacterStarDeclNotSelected);
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFile file = this.fileInEditor;
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        for (ScopingNode scope : scopes) {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            this.removeOldCharacterDecl(scope.getBody(), ast);
        }
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void removeOldCharacterDecl(IASTListNode<IASTNode> body, IFortranAST ast) {
        List<ASTTypeDeclarationStmtNode> typeCharDeclStmts = this.createCharTypeDeclStmtList(body, ast);
        this.insertNewStmts(typeCharDeclStmts, body, ast);
        this.removeOldStmts(typeCharDeclStmts, body);
    }

    private List<ASTTypeDeclarationStmtNode> createCharTypeDeclStmtList(IASTListNode<IASTNode> body, IFortranAST ast) {
        LinkedList<ASTTypeDeclarationStmtNode> statements = new LinkedList<ASTTypeDeclarationStmtNode>();
        CharacterNodesVisitor charVitor = new CharacterNodesVisitor();
        ast.accept(charVitor);
        for (IASTNode node : body) {
            if (!(node instanceof ASTTypeDeclarationStmtNode) || !charVitor.getList().contains(node)) continue;
            this.changeOldCharStyleDecl((ASTTypeDeclarationStmtNode)node, statements);
        }
        return statements;
    }

    private void changeOldCharStyleDecl(ASTTypeDeclarationStmtNode typeDeclStmt, List<ASTTypeDeclarationStmtNode> statements) {
        IASTListNode<ASTEntityDeclNode> variables = typeDeclStmt.getEntityDeclList();
        int i = 0;
        while (i < variables.size()) {
            ASTTypeDeclarationStmtNode newStmt = this.createNewVariableDeclaration(typeDeclStmt, i);
            statements.add(typeDeclStmt);
            statements.add(newStmt);
            ++i;
        }
    }

    private ASTTypeDeclarationStmtNode createNewVariableDeclaration(ASTTypeDeclarationStmtNode typeDeclStmt, int i) {
        IASTListNode<ASTEntityDeclNode> variables = typeDeclStmt.getEntityDeclList();
        ASTTypeDeclarationStmtNode newStmt = (ASTTypeDeclarationStmtNode)typeDeclStmt.clone();
        if (i > 0) {
            newStmt.setTypeSpec(this.createTypeSpecNodeFrom(typeDeclStmt));
        }
        IASTListNode newVariable = (IASTListNode)variables.clone();
        LinkedList<ASTEntityDeclNode> listOfVariablesToRemove = new LinkedList<ASTEntityDeclNode>();
        int j = 0;
        while (j < variables.size()) {
            if (j != i) {
                listOfVariablesToRemove.add((ASTEntityDeclNode)newVariable.get(j));
            }
            ++j;
        }
        newVariable.removeAll(listOfVariablesToRemove);
        newStmt.setEntityDeclList(newVariable);
        String source = this.addTwoColons(newStmt);
        newStmt = (ASTTypeDeclarationStmtNode)ReplaceCharacterStarRefactoring.parseLiteralStatement(source);
        newStmt = this.characterToCharacterLen(newStmt);
        return newStmt;
    }

    private ASTTypeDeclarationStmtNode characterToCharacterLen(ASTTypeDeclarationStmtNode Stmt) {
        String length = "";
        String literalIniDec = "";
        ASTTypeSpecNode type = Stmt.getTypeSpec();
        ASTEntityDeclNode declNode = (ASTEntityDeclNode)Stmt.getEntityDeclList().get(0);
        if (Stmt.getTypeSpec().getCharSelector() != null) {
            if (declNode.getCharLength() == null) {
                length = type.getCharSelector().getConstIntLength().getText();
            } else {
                length = declNode.getCharLength().getConstIntLength().getText();
                declNode.getCharLength().removeFromTree();
                type.getCharSelector().removeFromTree();
            }
        } else if (declNode.getCharLength() != null) {
            length = declNode.getCharLength().getConstIntLength().getText();
            declNode.getCharLength().removeFromTree();
        } else {
            String strType = type.getCharacterToken().getText();
            length = strType.contains("*") ? strType.substring(strType.indexOf("*") + 1) : "1";
        }
        String source1 = "character(len=" + length + ")" + "::";
        literalIniDec = this.getLiteralDeclaration(((ASTEntityDeclNode)Stmt.getEntityDeclList().get(0)).getInitialization());
        String source2 = this.getIdentifier((ASTEntityDeclNode)Stmt.getEntityDeclList().get(0));
        String commentsBefore = Stmt.findFirstToken().getWhiteBefore();
        String commentsAfter = Stmt.findLastToken().getWhiteBefore();
        String literalStmt = String.valueOf(commentsBefore) + source1 + source2 + literalIniDec + commentsAfter;
        Stmt = (ASTTypeDeclarationStmtNode)ReplaceCharacterStarRefactoring.parseLiteralStatement(literalStmt);
        return Stmt;
    }

    private String getIdentifier(ASTEntityDeclNode declNode) {
        String varName = declNode.getObjectName().getObjectName().getText();
        ASTArraySpecNode arraySpec = declNode.getArraySpec();
        if (arraySpec != null) {
            varName = String.valueOf(varName) + "(" + arraySpec.toString() + ")";
        }
        return varName;
    }

    private String getLiteralDeclaration(ASTInitializationNode initializationNode) {
        if (initializationNode != null) {
            String iniStr = initializationNode.getAssignedExpr().toString();
            return "=" + iniStr;
        }
        return "";
    }

    private ASTTypeSpecNode createTypeSpecNodeFrom(ASTTypeDeclarationStmtNode typeDeclStmt) {
        ASTTypeSpecNode typeNode = new ASTTypeSpecNode();
        String type = typeDeclStmt.getTypeSpec().toString().trim();
        String[] typeWithoutComments = type.split("\n");
        type = typeWithoutComments[typeWithoutComments.length - 1].trim();
        typeNode.setIsInteger(new Token(Terminal.T_INTEGER, type));
        return typeNode;
    }

    private String addTwoColons(ASTTypeDeclarationStmtNode newStmt) {
        String source = SourcePrinter.getSourceCodeFromASTNode(newStmt);
        int position_type = newStmt.getTypeSpec().toString().length();
        String twoPoints = "";
        String source_1 = source.substring(0, position_type);
        String source_2 = source.substring(position_type, source.length());
        if (!this.containsColonColon(source_2)) {
            twoPoints = " :: ";
        }
        source = String.valueOf(source_1) + twoPoints + source_2.trim();
        return source;
    }

    private boolean containsColonColon(String s) {
        int i = 0;
        while (i < s.length() - 1) {
            char p1 = s.charAt(i);
            char p2 = s.charAt(i + 1);
            if (p1 == '!' || p2 == '!') {
                return false;
            }
            if (p1 == ':' && p2 == ':') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void insertNewStmts(List<ASTTypeDeclarationStmtNode> typeDeclStmts, IASTListNode<IASTNode> body, IFortranAST ast) {
        int i = 0;
        while (i < typeDeclStmts.size()) {
            body.insertBefore(typeDeclStmts.get(i), typeDeclStmts.get(i + 1));
            Reindenter.reindent(typeDeclStmts.get(i + 1), ast);
            i += 2;
        }
    }

    private void removeOldStmts(List<ASTTypeDeclarationStmtNode> typeDeclStmts, IASTListNode<IASTNode> body) {
        int i = 0;
        while (i < typeDeclStmts.size()) {
            ASTTypeDeclarationStmtNode delete = typeDeclStmts.get(i);
            if (body.contains(delete)) {
                delete.removeFromTree();
            }
            i += 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharacterNodesVisitor
    extends ASTVisitor {
        private List<ASTTypeDeclarationStmtNode> oldCcharDeclaStmtList = new LinkedList<ASTTypeDeclarationStmtNode>();

        private CharacterNodesVisitor() {
        }

        @Override
        public void visitASTTypeDeclarationStmtNode(ASTTypeDeclarationStmtNode node) {
            ASTTypeSpecNode specTypeNode = node.getTypeSpec();
            if (specTypeNode != null && specTypeNode.isCharacter()) {
                ASTCharSelectorNode charSelectorNode = specTypeNode.getCharSelector();
                if (charSelectorNode != null) {
                    if (this.isAnOldCharacterDecl(charSelectorNode)) {
                        this.oldCcharDeclaStmtList.add(node);
                    }
                } else {
                    this.oldCcharDeclaStmtList.add(node);
                }
            }
        }

        public List<ASTTypeDeclarationStmtNode> getList() {
            return this.oldCcharDeclaStmtList;
        }

        private boolean isAnOldCharacterDecl(ASTCharSelectorNode node) {
            return !node.isAssumedLength() && !node.isColon() && node.getConstIntLength() != null && node.getLengthExpr() == null && node.getKindExpr() == null && node.getKindExpr2() == null;
        }
    }
}

