/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.FixedFormReplacement;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.FortranIncludeDirective;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.ISpecificationPartConstruct;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

public class _AST_VPG_HOWTO {
    void iterateThroughAllTokensIn(IASTNode node) {
        node.accept(new ASTVisitor(){

            public void visitToken(Token token) {
            }
        });
    }

    void iterateThroughAllSubroutinesIn(IASTNode node) {
        node.accept(new ASTVisitor(){

            public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
            }
        });
    }

    void iterateThroughAllDoLoopsIn(IFortranAST ast) {
        LoopReplacer.replaceAllLoopsIn(ast.getRoot());
        ast.accept(new ASTVisitorWithLoops(){

            public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
            }
        });
    }

    void findFirstTokenIn(IASTNode node) {
        node.findFirstToken();
    }

    void findRootOfTheAST(IASTNode node) {
        node.findNearestAncestor(ASTExecutableProgramNode.class);
    }

    void findLastSpecificationStmtIn(ASTSubroutineSubprogramNode subroutine) {
        subroutine.getBody().findLast(ISpecificationPartConstruct.class);
    }

    void findFirstExecutableStmtIn(ASTSubroutineSubprogramNode subroutine) {
        subroutine.getBody().findFirst(IExecutableConstruct.class);
    }

    void printTheSourceCodeFromAnASTNode(IASTNode node) {
        System.out.println(node);
    }

    void getCommentsAndWhitespacePreceding(IASTNode node) {
        node.findFirstToken().getWhiteBefore();
    }

    void getCommentsAndWhitespaceAtEndOfFile(IFortranAST ast) {
        Token lastTokenInFile = ast.getRoot().findLastToken();
        if (lastTokenInFile != null) {
            lastTokenInFile.getWhiteAfter();
        }
    }

    void dealWithPreprocessing(Token token) {
        if (token.getPreprocessorDirective() != null && !(token.getPreprocessorDirective() instanceof FixedFormReplacement)) {
            boolean cfr_ignored_0 = token.getPreprocessorDirective() instanceof FortranIncludeDirective;
        }
    }

    void findScopeOf(IASTNode node) {
        node.findNearestAncestor(ScopingNode.class);
    }

    void findSubroutineContaining(IASTNode node) {
        node.findNearestAncestor(ASTSubroutineSubprogramNode.class);
    }

    void findAllSymbolsDefinedInTheScopeOf(ScopingNode scope) {
        for (Definition symbol : scope.getAllDefinitions()) {
            if (symbol == null) continue;
            System.out.println(symbol.getCanonicalizedName());
        }
    }

    void findAllPublicallyAccessibleSymbolsDefinedIn(ScopingNode scope) {
        for (Definition symbol : scope.getAllPublicDefinitions()) {
            System.out.println(symbol.getCanonicalizedName());
        }
    }

    void determineWhatSymbolIsDefinedBy(Token identifier) {
        List<Definition> definitions;
        if (identifier.isIdentifier() && !(definitions = identifier.resolveBinding()).isEmpty() && definitions.size() <= 1) {
            definitions.get(0);
        }
    }

    void findAllPlacesWhereSymbolIsUsed(Definition symbol) {
        for (PhotranTokenRef location : symbol.findAllReferences(true)) {
            location.findToken();
        }
    }

    void determineIfASymbolHasThePARAMETERAttribute(Definition symbol) {
        if (symbol.isParameter()) {
            System.out.println(true);
        }
    }

    void makeCopyOf(IASTNode node) {
        IASTNode cfr_ignored_0 = (IASTNode)node.clone();
    }

    void changeTheTextOfAToken(Token token) {
        token.setText("whatever");
    }

    void replacePartOfAnAST() {
        IASTNode node1 = this.whatever();
        IASTNode node2 = this.whatever();
        node1.replaceWith(node2);
        node1.replaceWith("You can also replace a node with a string, like this.");
    }

    void deletePartOfAnAST(IASTNode node) {
        node.removeFromTree();
    }

    private IASTNode whatever() {
        throw new Error();
    }
}

