/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.reindenter;

import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Token;

final class LineColComputer
extends ASTVisitorWithLoops {
    private int fileOffset = 0;
    private int col = 1;
    private int line = 1;
    private IPreprocessorReplacement lastPreprocRepl = null;

    LineColComputer() {
    }

    public void visitToken(Token token) {
        IPreprocessorReplacement thisPreprocRepl = token.getPreprocessorDirective();
        if (thisPreprocRepl != this.lastPreprocRepl) {
            if (thisPreprocRepl != null) {
                this.updateLineColAndOffset(token.getWhiteBefore());
                token.setFileOffset(this.fileOffset);
                token.setLine(this.line);
                token.setCol(this.col);
                this.updateLineColAndOffset(thisPreprocRepl.toString());
            }
            this.lastPreprocRepl = thisPreprocRepl;
        }
        if (thisPreprocRepl == null) {
            this.updateLineColAndOffset(token.getWhiteBefore());
            token.setFileOffset(this.fileOffset);
            token.setLine(this.line);
            token.setCol(this.col);
            this.updateLineColAndOffset(token.getText());
            this.updateLineColAndOffset(token.getWhiteAfter());
        }
    }

    private void updateLineColAndOffset(String s) {
        int i = 0;
        int len = s.length();
        while (i < len) {
            ++this.fileOffset;
            if (s.charAt(i) == '\n') {
                ++this.line;
                this.col = 1;
            } else {
                ++this.col;
            }
            ++i;
        }
    }
}

