/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.reindenter;

import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.reindenter.ReindentingVisitor;
import org.eclipse.photran.internal.core.reindenter.StartOfLine;

final class ShiftBlockVisitor
extends ReindentingVisitor {
    private String oldIndentation = this.getFirstLineToReindent().getIndentation();
    private String newIndentation;

    protected ShiftBlockVisitor(IFortranAST ast, Token firstTokenInRegion, Token lastTokenInRegion) {
        super(ast, firstTokenInRegion, lastTokenInRegion);
        if (!this.setNewIndentationFromFollowingLine() && !this.setNewIndentationFromPreviousLine(this.getFirstLineToReindent())) {
            this.setNewIndentationToDefault();
        }
    }

    private boolean setNewIndentationFromFollowingLine() {
        StartOfLine lineAfterReindentedRegion = StartOfLine.createForFirstNonemptyLineBelow(this.lastTokenInRegion.getLine(), this.ast);
        if (lineAfterReindentedRegion == null) {
            return false;
        }
        if (lineAfterReindentedRegion.endsIndentedRegion()) {
            return false;
        }
        this.newIndentation = lineAfterReindentedRegion.getIndentation();
        return true;
    }

    private boolean setNewIndentationFromPreviousLine(StartOfLine firstLineToReindent) {
        StartOfLine lineAboveReindentedRegion = StartOfLine.createForLastNonemptyLineAbove(firstLineToReindent, this.ast);
        if (lineAboveReindentedRegion == null) {
            return false;
        }
        this.newIndentation = lineAboveReindentedRegion.startsIndentedRegion() ? lineAboveReindentedRegion.getIncreasedIndentation() : lineAboveReindentedRegion.getIndentation();
        return true;
    }

    private void setNewIndentationToDefault() {
        this.newIndentation = "";
    }

    protected void updateIndentation(StartOfLine line) {
        line.reindent(this.oldIndentation, this.newIndentation);
    }
}

