/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.rephraserengine.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;

public class HighlightVariableAccesses
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            File temp = File.createTempFile("photran-tmp", ".htm");
            temp.deleteOnExit();
            PrintStream ps = UIUtil.createPrintStream((File)temp);
            ps.println("<html><head><title></title></head><body>");
            this.printLegend(ps);
            ps.println("<pre>");
            this.printProgram(ps);
            ps.println("</pre></body></html>");
            ps.close();
            UIUtil.openHtmlViewerOn((String)"Variable Accesses", (File)temp);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
        }
    }

    private void printLegend(PrintStream ps) {
        ps.println("<table border=\"0\" cellpadding=\"5\" cellspacing=\"0\" align=\"center\"><tr>");
        ps.println("<th>LEGEND:</th>");
        VariableAccess[] variableAccessArray = VariableAccess.values();
        int n = variableAccessArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableAccess access = variableAccessArray[n2];
            ps.println("<td>");
            ps.print(this.highlightingStartTag(access));
            ps.println(access);
            ps.print(this.highlightingEndTag(access));
            ps.println("</td>");
            ++n2;
        }
        ps.println("</tr></table>");
        ps.println("<hr>");
    }

    private void printProgram(PrintStream out) throws Exception {
        IPreprocessorReplacement currentPreprocessorDirective = null;
        for (Token token : this.getAST()) {
            if (token.getPreprocessorDirective() != currentPreprocessorDirective) {
                if (token.getPreprocessorDirective() != null) {
                    out.print(token.getWhiteBefore());
                    out.print(token.getPreprocessorDirective());
                }
                currentPreprocessorDirective = token.getPreprocessorDirective();
            }
            if (currentPreprocessorDirective != null || token.getPreprocessorDirective() != null) continue;
            out.print(token.getWhiteBefore());
            out.print(this.highlightingStartTag(token.getVariableAccessType()));
            out.print(token.getText());
            out.print(this.highlightingEndTag(token.getVariableAccessType()));
            out.print(token.getWhiteAfter());
        }
    }

    private String highlightingStartTag(VariableAccess access) {
        switch (access) {
            case NONE: {
                return "";
            }
            case READ: {
                return "<b><font style=\"background-color: #66FF66;\">";
            }
            case WRITE: {
                return "<b><font style=\"background-color: #FF3333;\">";
            }
            case RW: {
                return "<b><font style=\"background-color: #FFFF66;\">";
            }
            case IMPLIED_DO: {
                return "<b><font style=\"background-color: #CCCCCC;\">";
            }
            case FORALL: {
                return "<b><font style=\"background-color: #CCCCCC;\">";
            }
            case STMT_FUNCTION_ARG: {
                return "<b><font style=\"background-color: #CCCCCC;\">";
            }
        }
        throw new IllegalStateException();
    }

    private String highlightingEndTag(VariableAccess access) {
        if (access.equals((Object)VariableAccess.NONE)) {
            return "";
        }
        return "</font></b>";
    }
}

