/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.intrinsics.IntrinsicProcDescription;
import org.eclipse.photran.internal.core.intrinsics.Intrinsics;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.FortranTemplateManager;
import org.eclipse.photran.internal.ui.editor.CompletionComputer;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FortranCompletionProposalComputer
extends CompletionComputer {
    private HashMap<String, TreeSet<Definition>> defs;
    private String scope;
    private HashMap<Definition.Classification, Image> imageCache = new HashMap();

    FortranCompletionProposalComputer(HashMap<String, TreeSet<Definition>> defs, String scope, IDocument document, int offset) throws BadLocationException {
        super(document, offset);
        this.defs = defs;
        this.scope = scope;
    }

    public List<ICompletionProposal> proposalsFromDefs() throws BadLocationException {
        TreeSet<FortranCompletionProposal> proposals = new TreeSet<FortranCompletionProposal>();
        while (true) {
            this.addProposals((Iterable<Definition>)this.defs.get(this.scope), proposals);
            int colon = this.scope.indexOf(58);
            if (colon < 0) break;
            this.scope = this.scope.substring(colon + 1);
        }
        return this.toProposalArray(proposals);
    }

    private List<ICompletionProposal> toProposalArray(TreeSet<FortranCompletionProposal> proposals) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>(proposals.size());
        for (FortranCompletionProposal p : proposals) {
            result.add(p.wrappedProposal);
        }
        return result;
    }

    private void addProposals(Iterable<Definition> proposalsToConsider, TreeSet<FortranCompletionProposal> proposals) throws BadLocationException {
        if (proposalsToConsider != null) {
            for (Definition def : proposalsToConsider) {
                if (def.getClassification().equals((Object)Definition.Classification.MAIN_PROGRAM)) continue;
                String identifier = def.getDeclaredName();
                String canonicalizedId = def.getCanonicalizedName();
                if (!canonicalizedId.startsWith(this.prefix) || !canonicalizedId.endsWith(this.suffix)) continue;
                proposals.add(this.createProposal(identifier, def.describeClassification(), this.getImage(def.getClassification())));
            }
        }
    }

    public List<ICompletionProposal> proposalsFromIntrinsics() throws BadLocationException {
        TreeSet<FortranCompletionProposal> proposals = new TreeSet<FortranCompletionProposal>();
        for (IntrinsicProcDescription proc : Intrinsics.getAllIntrinsicProcedures()) {
            String canonicalizedId = PhotranVPG.canonicalizeIdentifier((String)proc.genericName);
            if (!canonicalizedId.startsWith(this.prefix) || !canonicalizedId.endsWith(this.suffix)) continue;
            for (String proposal : proc.getAllForms()) {
                proposals.add(this.createProposal(proposal.toLowerCase(), proc.description, proc.moduleName));
            }
        }
        return this.toProposalArray(proposals);
    }

    private Image getImage(Definition.Classification classification) {
        if (!this.imageCache.containsKey(classification)) {
            this.imageCache.put(classification, this.getImageDescriptor(classification).createImage());
        }
        return this.imageCache.get(classification);
    }

    private ImageDescriptor getImageDescriptor(Definition.Classification classification) {
        switch (classification) {
            case DERIVED_TYPE_COMPONENT: 
            case IMPLICIT_LOCAL_VARIABLE: 
            case VARIABLE_DECLARATION: {
                return FortranElement.Variable.imageDescriptor();
            }
            case BLOCK_DATA: {
                return FortranElement.BlockData.imageDescriptor();
            }
            case DERIVED_TYPE: {
                return FortranElement.DerivedType.imageDescriptor();
            }
            case FUNCTION: {
                return FortranElement.Function.imageDescriptor();
            }
            case INTERFACE: {
                return FortranElement.Interface.imageDescriptor();
            }
            case MAIN_PROGRAM: {
                return FortranElement.MainProgram.imageDescriptor();
            }
            case MODULE: {
                return FortranElement.Module.imageDescriptor();
            }
            case SUBROUTINE: {
                return FortranElement.Subroutine.imageDescriptor();
            }
        }
        return FortranElement.unknownImageDescriptor();
    }

    private FortranCompletionProposal createProposal(String identifier, String description, String moduleName) {
        return this.createProposal(identifier, description, moduleName, null);
    }

    private FortranCompletionProposal createProposal(String identifier, String description, Image image) {
        return this.createProposal(identifier, description, null, image);
    }

    private FortranCompletionProposal createProposal(String identifier, String description, String moduleName, Image image) {
        if (description == null) {
            description = "";
        }
        if (moduleName != null) {
            description = String.valueOf(description) + " - " + moduleName;
        }
        return new FortranCompletionProposal(identifier, (ICompletionProposal)new TemplateProposal(new Template(identifier, description, "org.eclipse.photran.ui.template.context", this.replaceArgumentsWithTemplateVariables(identifier), true), (TemplateContext)new DocumentTemplateContext(FortranTemplateManager.getInstance().getContextTypeRegistry().getContextType("org.eclipse.photran.ui.template.context"), this.document, this.replOffset, this.replLen), (IRegion)new Region(this.replOffset, this.replLen), image, 100));
    }

    private String replaceArgumentsWithTemplateVariables(String string) {
        if (string.contains("(") && string.contains(")") && string.endsWith(")")) {
            int lparen = string.indexOf(40);
            int rparen = string.lastIndexOf(41);
            String name = string.substring(0, lparen);
            String[] args = string.substring(lparen + 1, rparen).split(",");
            StringBuilder sb = new StringBuilder(string.length() + 16);
            sb.append(name);
            sb.append('(');
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("${");
                sb.append(args[i].trim().replace(' ', '_'));
                sb.append('}');
                ++i;
            }
            sb.append(')');
            return sb.toString();
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FortranCompletionProposal
    implements Comparable<FortranCompletionProposal> {
        public final String canonicalizedId;
        public final ICompletionProposal wrappedProposal;

        public FortranCompletionProposal(String identifier, ICompletionProposal proposal) {
            this.canonicalizedId = PhotranVPG.canonicalizeIdentifier((String)identifier);
            this.wrappedProposal = proposal;
        }

        @Override
        public int compareTo(FortranCompletionProposal o) {
            return this.canonicalizedId.compareTo(o.canonicalizedId);
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(this.getClass()) && ((FortranCompletionProposal)obj).canonicalizedId.equals(this.canonicalizedId);
        }

        public int hashCode() {
            return this.canonicalizedId.hashCode();
        }
    }
}

