/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.declaration;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.editor.FortranKeywordRuleBasedScanner;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorVPGTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationView
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener,
IFortranEditorVPGTask,
IFortranEditorASTTask {
    private FortranEditor activeEditor = null;
    private HashMap<String, ASTExecutableProgramNode> activeAST = new HashMap();
    private HashMap<String, TokenList> activeTokenList = new HashMap();
    private HashMap<String, DefinitionMap<String>> activeDefinitions = new HashMap();
    private SourceViewer viewer = null;
    private Document document = new Document();
    private Color LIGHT_YELLOW = new Color(null, new RGB(255, 255, 191));
    private static Pattern blankLine = Pattern.compile("(([ \\t]*[\\r\\n]+)+)[^\\00]*");

    public void createPartControl(Composite parent) {
        this.viewer = this.createFortranSourceViewer(parent);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        try {
            IWorkbenchPage activePage = this.getSite().getWorkbenchWindow().getActivePage();
            if (activePage != null) {
                this.selectionChanged(activePage.getActivePart(), activePage.getSelection());
            }
        }
        catch (Throwable throwable) {}
    }

    private SourceViewer createFortranSourceViewer(Composite parent) {
        final SourceViewer viewer = new SourceViewer(parent, null, 512);
        viewer.configure((SourceViewerConfiguration)new FortranEditor.FortranSourceViewerConfiguration(null){

            protected ITokenScanner getTokenScanner() {
                return new FortranKeywordRuleBasedScanner(false, (ISourceViewer)viewer);
            }
        });
        viewer.setDocument((IDocument)this.document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RuleBasedPartitionScanner(), FortranEditor.PARTITION_TYPES);
        partitioner.connect((IDocument)this.document);
        this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        viewer.getControl().setBackground(this.LIGHT_YELLOW);
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getTextFont());
        return viewer;
    }

    public void update(String str) {
        if (str.length() > 0) {
            str = this.trimBlankLines(str);
        }
        this.document.set(str);
        this.viewer.refresh();
    }

    private String trimBlankLines(String str) {
        Matcher m = blankLine.matcher(str);
        while (str.length() > 0 && m.matches()) {
            str = str.substring(m.end(1));
            m = blankLine.matcher(str);
        }
        return str;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public synchronized void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof FortranEditor) {
            if (this.activeEditor != part) {
                this.stopObserving(this.activeEditor);
                this.activeEditor = this.startObserving((FortranEditor)part);
            }
        } else {
            this.stopObserving(this.activeEditor);
            this.activeEditor = null;
        }
    }

    private FortranEditor startObserving(final FortranEditor editor) {
        String declViewEnabledProperty;
        if (editor != null && (declViewEnabledProperty = new SearchPathProperties().getProperty(editor.getIFile(), "EnableDeclView")) != null && declViewEnabledProperty.equals("true")) {
            this.addCaretMovementListenerTo(editor);
            FortranEditorTasks tasks = FortranEditorTasks.instance(editor);
            tasks.addASTTask(this);
            tasks.addVPGTask(this);
            ((IPartService)this.getSite().getService(IPartService.class)).addPartListener(new IPartListener2(){

                public void partActivated(IWorkbenchPartReference partRef) {
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                    if (partRef.getPart(false) == editor) {
                        FortranEditorTasks tasks = FortranEditorTasks.instance(editor);
                        tasks.removeASTTask(DeclarationView.this);
                        tasks.removeVPGTask(DeclarationView.this);
                        IFile ifile = editor.getIFile();
                        if (ifile != null) {
                            String path = ifile.getFullPath().toPortableString();
                            DeclarationView.this.activeAST.remove(path);
                            DeclarationView.this.activeDefinitions.remove(path);
                            DeclarationView.this.activeTokenList.remove(path);
                        }
                    }
                    ((IPartService)DeclarationView.this.getSite().getService(IPartService.class)).removePartListener((IPartListener2)this);
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }
            });
            tasks.getRunner().runTasks(true);
            return editor;
        }
        return null;
    }

    private void addCaretMovementListenerTo(FortranEditor editor) {
        TextViewer sourceViewer = (TextViewer)editor.getSourceViewerx();
        if (sourceViewer != null) {
            sourceViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private void stopObserving(FortranEditor editor) {
        this.update("");
        if (editor != null) {
            this.removeCaretMovementListenerFrom(editor);
        }
    }

    private void removeCaretMovementListenerFrom(FortranEditor editor) {
        TextViewer sourceViewer = (TextViewer)editor.getSourceViewerx();
        if (sourceViewer != null) {
            sourceViewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(IFile file, IFortranAST ast, DefinitionMap<Definition> defMap) {
        if (defMap == null) {
            return;
        }
        long start = System.currentTimeMillis();
        DefinitionMap<String> newDefMap = new DefinitionMap<String>(defMap){

            @Override
            protected String map(String qualifiedName, Definition def) {
                return def.describe();
            }
        };
        DeclarationView declarationView = this;
        synchronized (declarationView) {
            this.activeDefinitions.put(file.getFullPath().toPortableString(), newDefMap);
        }
        PhotranVPG.getInstance().debug("        Decl view IEditorVPGTask handler:\t" + (System.currentTimeMillis() - start) + " ms", PhotranVPG.getFilenameForIFile((IFile)file));
    }

    @Override
    public synchronized boolean handle(ASTExecutableProgramNode ast, TokenList tokenList, DefinitionMap<Definition> defMap) {
        if (this.activeEditor != null) {
            long start = System.currentTimeMillis();
            String path = this.activeEditor.getIFile().getFullPath().toPortableString();
            this.activeAST.put(path, ast);
            this.activeTokenList.put(path, tokenList);
            PhotranVPG.getInstance().debug("        Decl view IEditorASTTask handler:\t" + (System.currentTimeMillis() - start) + " ms", null);
        }
        return true;
    }

    public synchronized void selectionChanged(SelectionChangedEvent event) {
        if (this.activeEditor == null) {
            return;
        }
        String path = this.activeEditor.getIFile().getFullPath().toPortableString();
        TokenList tokenList = this.activeTokenList.get(path);
        DefinitionMap<String> defMap = this.activeDefinitions.get(path);
        if (event.getSelection() instanceof TextSelection && tokenList != null && defMap != null) {
            String description = defMap.lookup((TextSelection)event.getSelection(), tokenList);
            this.update(description == null ? "" : description);
        } else {
            this.update("");
        }
    }
}

