/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DereferenceNode
extends ASTNode {
    private Expression name;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(DereferenceNode.class, "name", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(1);
        propertyList.add(NAME_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public DereferenceNode(int start, int end, AST ast, Expression indexName) {
        super(start, end, ast);
        if (indexName == null) {
            throw new IllegalArgumentException();
        }
        this.setName(indexName);
    }

    public DereferenceNode(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.name.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.name.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.name.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<DereferenceNode");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.name.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</DereferenceNode>");
    }

    @Override
    public int getType() {
        return 0;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.name;
        this.preReplaceChild(oldChild, expression, NAME_PROPERTY);
        this.name = expression;
        this.postReplaceChild(oldChild, expression, NAME_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression expr = ASTNode.copySubtree(target, this.getName());
        DereferenceNode result = new DereferenceNode(this.getStart(), this.getEnd(), target, expr);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

