/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitAlias
extends Expression {
    private Expression traitMethod;
    private int modifier;
    private String functionName;
    public static final ChildPropertyDescriptor TRAIT_METHOD = new ChildPropertyDescriptor(TraitAlias.class, "traitMethod", Expression.class, true, true);
    public static final SimplePropertyDescriptor MODIFIER = new SimplePropertyDescriptor(TraitAlias.class, "modifier", Integer.class, false);
    public static final SimplePropertyDescriptor FUNCTION_NAME = new SimplePropertyDescriptor(TraitAlias.class, "functionName", String.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(1);
        propertyList.add(TRAIT_METHOD);
        propertyList.add(MODIFIER);
        propertyList.add(FUNCTION_NAME);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public TraitAlias(int start, int end, AST ast, Expression traitMethod, int modifier, String functionName) {
        super(start, end, ast);
        this.traitMethod = traitMethod;
        this.modifier = modifier;
        this.functionName = functionName;
    }

    public TraitAlias(AST ast) {
        super(ast);
    }

    public Expression getTraitMethod() {
        return this.traitMethod;
    }

    public void setTraitMethod(Expression traitMethod) {
        if (traitMethod == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.traitMethod;
        this.preReplaceChild(oldChild, traitMethod, TRAIT_METHOD);
        this.traitMethod = traitMethod;
        this.postReplaceChild(oldChild, traitMethod, TRAIT_METHOD);
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        this.preValueChange(MODIFIER);
        this.modifier = modifier;
        this.postValueChange(MODIFIER);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.preValueChange(FUNCTION_NAME);
        this.functionName = functionName;
        this.postValueChange(FUNCTION_NAME);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.traitMethod.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.traitMethod.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.traitMethod.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitAlias");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.traitMethod.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</TraitAlias>");
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression traitMethod = ASTNode.copySubtree(target, this.getTraitMethod());
        TraitAlias result = new TraitAlias(this.getStart(), this.getEnd(), target, traitMethod, this.modifier, this.functionName);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

