/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.TraitStatement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitUseStatement
extends Statement {
    private ASTNode.NodeList<NamespaceName> traitList = new ASTNode.NodeList(TRAIT);
    private ASTNode.NodeList<TraitStatement> tsList = new ASTNode.NodeList(TRAIT_STATEMENT);
    public static final ChildListPropertyDescriptor TRAIT = new ChildListPropertyDescriptor(TraitUseStatement.class, "traitList", NamespaceName.class, true);
    public static final ChildListPropertyDescriptor TRAIT_STATEMENT = new ChildListPropertyDescriptor(TraitUseStatement.class, "tsList", TraitStatement.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> propertyList = new ArrayList<ChildListPropertyDescriptor>(1);
        propertyList.add(TRAIT);
        propertyList.add(TRAIT_STATEMENT);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public TraitUseStatement(int start, int end, AST ast, List<NamespaceName> traitList, List<TraitStatement> tsList) {
        super(start, end, ast);
        if (traitList != null) {
            this.traitList.addAll(traitList);
        }
        if (tsList != null) {
            this.tsList.addAll(tsList);
        }
    }

    public TraitUseStatement(AST ast) {
        super(ast);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.traitList) {
            aSTNode.accept(visitor);
        }
        for (ASTNode aSTNode : this.tsList) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        for (ASTNode aSTNode : this.traitList) {
            aSTNode.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.tsList) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.traitList) {
            aSTNode.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.tsList) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitUseStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        if (this.traitList != null && !this.traitList.isEmpty()) {
            buffer.append("\t").append(tab).append("<TraitNameList>\n");
            for (NamespaceName namespaceName : this.traitList) {
                namespaceName.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append("\t").append(tab).append("</TraitNameList>\n");
        }
        if (this.tsList != null && !this.tsList.isEmpty()) {
            buffer.append("\t").append(tab).append("<TraitStatementList>\n");
            for (TraitStatement traitStatement : this.tsList) {
                traitStatement.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append("\t").append(tab).append("</TraitStatementList>\n");
        }
        buffer.append(tab).append("</TraitUseStatement>");
    }

    @Override
    void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    ASTNode clone0(AST target) {
        List traitList = ASTNode.copySubtrees(target, this.getTraitList());
        List tsList = ASTNode.copySubtrees(target, this.getTsList());
        TraitUseStatement result = new TraitUseStatement(this.getStart(), this.getEnd(), target, traitList, tsList);
        return result;
    }

    public ASTNode.NodeList<NamespaceName> getTraitList() {
        return this.traitList;
    }

    public void setTraitList(List<NamespaceName> traitList) {
        this.traitList.clear();
        if (traitList != null) {
            this.traitList.addAll(traitList);
        }
    }

    public ASTNode.NodeList<TraitStatement> getTsList() {
        return this.tsList;
    }

    public void setTsList(List<TraitStatement> tsList) {
        this.tsList.clear();
        if (tsList != null) {
            this.tsList.addAll(tsList);
        }
    }
}

