/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class CompletionCompanion {
    private Map<Integer, IType[]> rhTypesCache = new HashMap<Integer, IType[]>();
    private Map<IType, ITypeHierarchy> superHierarchyCache = new HashMap<IType, ITypeHierarchy>();

    public IType[] getLeftHandType(ICompletionContext context) {
        AbstractCompletionContext aContext = (AbstractCompletionContext)context;
        int offset = aContext.getOffset();
        if (!this.rhTypesCache.containsKey(offset)) {
            TextSequence statementText = aContext.getStatementText();
            int triggerEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementText.length());
            triggerEnd = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, triggerEnd, true);
            triggerEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, triggerEnd);
            this.rhTypesCache.put(offset, CodeAssistUtils.getTypesFor(aContext.getSourceModule(), statementText, triggerEnd, offset));
        }
        return this.rhTypesCache.get(offset);
    }

    public ITypeHierarchy getSuperTypeHierarchy(IType type, IProgressMonitor monitor) throws ModelException {
        if (!this.superHierarchyCache.containsKey(type)) {
            this.superHierarchyCache.put(type, type.newSupertypeHierarchy(monitor));
        }
        return this.superHierarchyCache.get(type);
    }
}

