/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterContext;

public class FunctionParameterTypeContext
extends FunctionParameterContext {
    private IMethod enclosingMethod;
    private IType enclosingType;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        char triggerChar = this.getTriggerChar();
        if (triggerChar == '(' || triggerChar == ',') {
            IModelElement enclosingElement;
            block7: {
                enclosingElement = sourceModule.getElementAt(offset);
                while (enclosingElement instanceof IField) {
                    enclosingElement = enclosingElement.getParent();
                }
                if (enclosingElement instanceof IMethod) break block7;
                return false;
            }
            try {
                this.enclosingMethod = (IMethod)enclosingElement;
                enclosingElement = this.enclosingMethod;
                while (enclosingElement != null && !(enclosingElement instanceof IType)) {
                    enclosingElement = enclosingElement.getParent();
                }
                this.enclosingType = (IType)enclosingElement;
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            return true;
        }
        return false;
    }

    public IMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public IType getEnclosingType() {
        return this.enclosingType;
    }
}

