/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionStrategy;
import org.eclipse.php.core.codeassist.ICompletionStrategyFactory;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.ArrayKeyContext;
import org.eclipse.php.internal.core.codeassist.contexts.CatchTypeContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassDeclarationKeywordContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassExtendsContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassImplementsContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassInstantiationContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassObjMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStaticMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.ExceptionClassInstantiationContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterTypeContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterValueContext;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalMethodStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.GotoStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.IncludeStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.InstanceOfContext;
import org.eclipse.php.internal.core.codeassist.contexts.InterfaceDeclarationKeywordContext;
import org.eclipse.php.internal.core.codeassist.contexts.InterfaceExtendsContext;
import org.eclipse.php.internal.core.codeassist.contexts.MethodNameContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceDeclContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceNameContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespacePHPDocVarStartContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceUseNameContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocParamTagContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocReturnTagContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagStartContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocThrowsStartContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocVarStartContext;
import org.eclipse.php.internal.core.codeassist.contexts.TypeCastingContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseNameContext;
import org.eclipse.php.internal.core.codeassist.strategies.BuiltinArrayKeysStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.CatchTypeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ClassDeclarationKeywordsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ClassFieldsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ClassInstantiationStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ClassKeywordsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMethodsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ExceptionClassInstantiationStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ExceptionClassStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.FunctionParameterKeywordTypeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.FunctionParameterTypeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalClassesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalConstantsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementsCompositeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalInterfacesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalVariablesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GotoStatementStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.IncludeStatementStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.InstanceOfStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.InterfaceDeclarationKeywordsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.LocalMethodElementsCompositeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.MethodNameStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.MethodParameterKeywordStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceDocTypesCompositeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceElementsCompositeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceNonFinalClassesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespaceUseNameStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NamespacesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.NonFinalClassesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.PHPDocParamVariableStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.PHPDocReturnTypeStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.PHPDocTagStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.TypeCastingStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.UseNameStrategy;
import org.eclipse.php.internal.core.codeassist.templates.contexts.GlobalMethodStatementContextForTemplate;
import org.eclipse.php.internal.core.codeassist.templates.contexts.GlobalStatementContextForTemplate;
import org.eclipse.php.internal.core.codeassist.templates.strategies.LocalMethodVariablesStrategyForTemplate;

public class CompletionStrategyFactory
implements ICompletionStrategyFactory {
    private static ICompletionStrategyFactory[] instances;

    public static ICompletionStrategyFactory[] getActive() {
        if (instances == null) {
            IConfigurationElement[] elements;
            LinkedList<ICompletionStrategyFactory> factories = new LinkedList<ICompletionStrategyFactory>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.completionStrategyFactories");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("factory")) {
                    try {
                        factories.add((ICompletionStrategyFactory)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            factories.add(new CompletionStrategyFactory());
            instances = factories.toArray(new ICompletionStrategyFactory[factories.size()]);
        }
        return instances;
    }

    public ICompletionStrategy[] create(ICompletionContext[] contexts) {
        HashSet processed = new HashSet();
        LinkedList<ICompletionStrategy> result = new LinkedList<ICompletionStrategy>();
        ICompletionContext[] iCompletionContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionStrategy[] strategies;
            ICompletionContext context = iCompletionContextArray[n2];
            ICompletionStrategy[] iCompletionStrategyArray = strategies = this.createStrategies(context, contexts);
            int n3 = strategies.length;
            int n4 = 0;
            while (n4 < n3) {
                ICompletionStrategy strategy = iCompletionStrategyArray[n4];
                if (!processed.contains(strategy.getClass())) {
                    result.add(strategy);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new ICompletionStrategy[result.size()]);
    }

    protected ICompletionStrategy[] createStrategies(ICompletionContext context, ICompletionContext[] allContexts) {
        Class<?> contextClass = context.getClass();
        if (contextClass == PHPDocTagStartContext.class) {
            return new ICompletionStrategy[]{new PHPDocTagStrategy(context)};
        }
        if (contextClass == PHPDocVarStartContext.class) {
            return new ICompletionStrategy[]{new GlobalClassesStrategy(context){

                protected Object getExtraInfo() {
                    return "TYPE_ONLY";
                }
            }};
        }
        if (contextClass == PHPDocThrowsStartContext.class) {
            return new ICompletionStrategy[]{new ExceptionClassStrategy(context)};
        }
        if (contextClass == PHPDocParamTagContext.class) {
            return new ICompletionStrategy[]{new PHPDocParamVariableStrategy(context)};
        }
        if (contextClass == PHPDocReturnTagContext.class) {
            return new ICompletionStrategy[]{new PHPDocReturnTypeStrategy(context)};
        }
        if (contextClass == ArrayKeyContext.class) {
            if (((ArrayKeyContext)context).hasQuotes()) {
                return new ICompletionStrategy[]{new BuiltinArrayKeysStrategy(context)};
            }
            return new ICompletionStrategy[]{new BuiltinArrayKeysStrategy(context), new GlobalElementsCompositeStrategy(context, false)};
        }
        if (contextClass == FunctionParameterTypeContext.class) {
            return new ICompletionStrategy[]{new FunctionParameterTypeStrategy(context), new FunctionParameterKeywordTypeStrategy(context)};
        }
        if (contextClass == FunctionParameterValueContext.class) {
            return new ICompletionStrategy[]{new GlobalConstantsStrategy(context), new MethodParameterKeywordStrategy(context)};
        }
        if (contextClass == MethodNameContext.class) {
            return new ICompletionStrategy[]{new MethodNameStrategy(context)};
        }
        if (contextClass == ClassStatementContext.class) {
            return new ICompletionStrategy[]{new ClassKeywordsStrategy(context), new GlobalConstantsStrategy(context)};
        }
        if (contextClass == GlobalStatementContext.class) {
            return new ICompletionStrategy[]{new GlobalElementsCompositeStrategy(context, true)};
        }
        if (contextClass == GlobalMethodStatementContext.class) {
            return new ICompletionStrategy[]{new LocalMethodElementsCompositeStrategy(context)};
        }
        if (contextClass == CatchTypeContext.class) {
            return new ICompletionStrategy[]{new CatchTypeStrategy(context)};
        }
        if (contextClass == ClassInstantiationContext.class) {
            return new ICompletionStrategy[]{new ClassInstantiationStrategy(context), new GlobalVariablesStrategy(context, false)};
        }
        if (contextClass == InstanceOfContext.class) {
            return new ICompletionStrategy[]{new InstanceOfStrategy(context)};
        }
        if (contextClass == ExceptionClassInstantiationContext.class) {
            return new ICompletionStrategy[]{new ExceptionClassInstantiationStrategy(context)};
        }
        if (contextClass == ClassStaticMemberContext.class || contextClass == ClassObjMemberContext.class) {
            return new ICompletionStrategy[]{new ClassFieldsStrategy(context), new ClassMethodsStrategy(context)};
        }
        if (contextClass == ClassDeclarationKeywordContext.class) {
            return new ICompletionStrategy[]{new ClassDeclarationKeywordsStrategy(context)};
        }
        if (contextClass == InterfaceDeclarationKeywordContext.class) {
            return new ICompletionStrategy[]{new InterfaceDeclarationKeywordsStrategy(context)};
        }
        if (contextClass == ClassExtendsContext.class) {
            return new ICompletionStrategy[]{new NonFinalClassesStrategy(context), new NamespaceNonFinalClassesStrategy(context)};
        }
        if (contextClass == ClassImplementsContext.class || contextClass == InterfaceExtendsContext.class) {
            return new ICompletionStrategy[]{new GlobalInterfacesStrategy(context)};
        }
        if (contextClass == NamespaceMemberContext.class) {
            return new ICompletionStrategy[]{new NamespaceElementsCompositeStrategy(context, allContexts, ((NamespaceMemberContext)context).isGlobal())};
        }
        if (contextClass == NamespaceNameContext.class || contextClass == NamespaceDeclContext.class) {
            return new ICompletionStrategy[]{new NamespacesStrategy(context)};
        }
        if (contextClass == GotoStatementContext.class) {
            return new ICompletionStrategy[]{new GotoStatementStrategy(context)};
        }
        if (contextClass == TypeCastingContext.class) {
            return new ICompletionStrategy[]{new TypeCastingStrategy(context)};
        }
        if (contextClass == UseNameContext.class) {
            return new ICompletionStrategy[]{new UseNameStrategy(context)};
        }
        if (contextClass == NamespaceUseNameContext.class) {
            return new ICompletionStrategy[]{new NamespaceUseNameStrategy(context)};
        }
        if (contextClass == IncludeStatementContext.class) {
            return new ICompletionStrategy[]{new IncludeStatementStrategy(context)};
        }
        if (contextClass == GlobalStatementContextForTemplate.class) {
            return new ICompletionStrategy[]{new GlobalVariablesStrategy(context, true)};
        }
        if (contextClass == GlobalMethodStatementContextForTemplate.class) {
            return new ICompletionStrategy[]{new LocalMethodVariablesStrategyForTemplate(context)};
        }
        if (contextClass == NamespacePHPDocVarStartContext.class) {
            return new ICompletionStrategy[]{new NamespaceDocTypesCompositeStrategy(context)};
        }
        return new ICompletionStrategy[0];
    }
}

