/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPDocTag
extends ASTNode
implements PHPDocTagKinds {
    public static final String ERROR = "ERROR!!!";
    public static final String THROWS_NAME = "throws";
    public static final String VERSION_NAME = "version";
    public static final String USES_NAME = "uses";
    public static final String TUTORIAL_NAME = "tutorial";
    public static final String SUBPACKAGE_NAME = "subpackage";
    public static final String SINCE_NAME = "since";
    public static final String LINK_NAME = "link";
    public static final String LICENSE_NAME = "license";
    public static final String INTERNAL_NAME = "internal";
    public static final String IGNORE_NAME = "ignore";
    public static final String FILESOURCE_NAME = "filesource";
    public static final String EXAMPLE_NAME = "example";
    public static final String DESC_NAME = "desc";
    public static final String COPYRIGHT_NAME = "copyright";
    public static final String CATEGORY_NAME = "category";
    public static final String ACCESS_NAME = "access";
    public static final String PACKAGE_NAME = "package";
    public static final String VAR_NAME = "var";
    public static final String TODO_NAME = "todo";
    public static final String STATICVAR_NAME = "staticvar";
    public static final String STATIC_NAME = "static";
    public static final String SEE_NAME = "see";
    public static final String PARAM_NAME = "param";
    public static final String RETURN_NAME = "return";
    public static final String NAME_NAME = "name";
    public static final String GLOBAL_NAME = "global";
    public static final String FINAL_NAME = "final";
    public static final String DEPRECATED_NAME = "deprecated";
    public static final String AUTHOR_NAME = "author";
    public static final String ABSTRACT_NAME = "abstract";
    public static final String PROPERTY_NAME = "property";
    public static final String PROPERTY_READ_NAME = "property-read";
    public static final String PROPERTY_WRITE_NAME = "property-write";
    public static final String METHOD_NAME = "method";
    private static final SimpleReference[] EMPTY = new SimpleReference[0];
    private final int tagKind;
    private String value;
    private SimpleReference[] references;
    private SimpleReference[] referencesWithOrigOrder;
    private List<Scalar> texts;

    public PHPDocTag(int start, int end, int tagKind, String value, List<Scalar> texts) {
        super(start, end);
        this.tagKind = tagKind;
        this.value = value;
        this.updateReferences(start, end);
        this.texts = texts;
    }

    public List<Scalar> getTexts() {
        return this.texts;
    }

    public String[] getDescTexts() {
        int wordSize = this.referencesWithOrigOrder.length;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.texts.size()) {
            String text = this.texts.get(i).getValue();
            if (wordSize <= 0) {
                result.add(text);
            } else if (text.trim().length() != 0) {
                List<String> commentWords = Arrays.asList(text.trim().split("[ \r\n]"));
                if ((commentWords = PHPDocTag.removeEmptyString(commentWords)).size() <= wordSize) {
                    wordSize -= commentWords.size();
                } else {
                    text = this.removeFirstWords(text, commentWords, wordSize);
                    result.add(text);
                    wordSize = 0;
                }
            }
            ++i;
        }
        String[] texts = new String[result.size()];
        result.toArray(texts);
        return texts;
    }

    public static List<String> removeEmptyString(List<String> commentWords) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < commentWords.size()) {
            String word = commentWords.get(i);
            if (word.trim().length() != 0) {
                result.add(word);
            }
            ++i;
        }
        return result;
    }

    private String removeFirstWords(String text, List<String> commentWords, int wordSize) {
        int i = 0;
        while (i < wordSize) {
            int index = text.indexOf(commentWords.get(i));
            text = text.substring(commentWords.get(i).length() + index);
            ++i;
        }
        return text.trim();
    }

    private static int getNonWhitespaceIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getWhitespaceIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (Character.isWhitespace(line.charAt(i))) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getClassStartIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) != '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getClassEndIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) == '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void updateReferences(int start, int end) {
        int secondWordEnd;
        int secondWordStart;
        int firstWordEnd;
        int firstWordStart;
        int valueStart = start + PHPDocTag.getTagKind(this.tagKind).length() + 1;
        if (this.tagKind == 6 || this.tagKind == 12 || this.tagKind == 29 || this.tagKind == 8) {
            int wordEnd;
            int wordStart = PHPDocTag.getNonWhitespaceIndex(this.value, 0);
            if (wordStart < (wordEnd = PHPDocTag.getWhitespaceIndex(this.value, wordStart))) {
                String word = this.value.substring(wordStart, wordEnd);
                int classStart = PHPDocTag.getClassStartIndex(word, 0);
                int classEnd = PHPDocTag.getClassEndIndex(word, classStart);
                LinkedList<TypeReference> types = new LinkedList<TypeReference>();
                while (classStart < classEnd) {
                    String className = word.substring(classStart, classEnd);
                    types.add(new TypeReference(valueStart + wordStart + classStart, valueStart + wordStart + classEnd, className));
                    classStart = PHPDocTag.getClassStartIndex(word, classEnd);
                    classEnd = PHPDocTag.getClassEndIndex(word, classStart);
                }
                if (types.size() > 0) {
                    this.references = (SimpleReference[])types.toArray(new TypeReference[types.size()]);
                    this.referencesWithOrigOrder = this.references;
                }
            }
        } else if (this.tagKind == 7 && (firstWordStart = PHPDocTag.getNonWhitespaceIndex(this.value, 0)) < (firstWordEnd = PHPDocTag.getWhitespaceIndex(this.value, firstWordStart)) && (secondWordStart = PHPDocTag.getNonWhitespaceIndex(this.value, firstWordEnd)) < (secondWordEnd = PHPDocTag.getWhitespaceIndex(this.value, secondWordStart))) {
            String firstWord = this.value.substring(firstWordStart, firstWordEnd);
            String secondWord = this.value.substring(secondWordStart, secondWordEnd);
            if (firstWord.charAt(0) == '$') {
                this.references = new SimpleReference[2];
                this.references[0] = new VariableReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.references[1] = new TypeReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.referencesWithOrigOrder = this.references;
            } else if (secondWord.charAt(0) == '$') {
                this.references = new SimpleReference[2];
                this.references[0] = new VariableReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.references[1] = new TypeReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.referencesWithOrigOrder = new SimpleReference[2];
                this.referencesWithOrigOrder[0] = this.references[1];
                this.referencesWithOrigOrder[1] = this.references[0];
            }
        }
        if (this.references == null) {
            this.references = EMPTY;
        }
        if (this.referencesWithOrigOrder == null) {
            this.referencesWithOrigOrder = EMPTY;
        }
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((ASTNode)this);
        if (visit) {
            SimpleReference[] simpleReferenceArray = this.references;
            int n = this.references.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleReference ref = simpleReferenceArray[n2];
                ref.traverse(visitor);
                ++n2;
            }
        }
        visitor.endvisit((ASTNode)this);
    }

    public int getKind() {
        return 68;
    }

    public int getTagKind() {
        return this.tagKind;
    }

    public String getValue() {
        return this.value;
    }

    public SimpleReference[] getReferences() {
        return this.references;
    }

    public SimpleReference[] getReferencesWithOrigOrder() {
        return this.referencesWithOrigOrder;
    }

    public void adjustStart(int start) {
        this.setStart(this.sourceStart() + start);
        this.setEnd(this.sourceEnd() + start);
    }

    public static String getTagKind(int kind) {
        switch (kind) {
            case 0: {
                return ABSTRACT_NAME;
            }
            case 1: {
                return AUTHOR_NAME;
            }
            case 2: {
                return DEPRECATED_NAME;
            }
            case 3: {
                return FINAL_NAME;
            }
            case 4: {
                return GLOBAL_NAME;
            }
            case 5: {
                return NAME_NAME;
            }
            case 6: {
                return RETURN_NAME;
            }
            case 7: {
                return PARAM_NAME;
            }
            case 8: {
                return SEE_NAME;
            }
            case 9: {
                return STATIC_NAME;
            }
            case 10: {
                return STATICVAR_NAME;
            }
            case 11: {
                return TODO_NAME;
            }
            case 12: {
                return VAR_NAME;
            }
            case 13: {
                return PACKAGE_NAME;
            }
            case 14: {
                return ACCESS_NAME;
            }
            case 15: {
                return CATEGORY_NAME;
            }
            case 16: {
                return COPYRIGHT_NAME;
            }
            case 17: {
                return DESC_NAME;
            }
            case 18: {
                return EXAMPLE_NAME;
            }
            case 19: {
                return FILESOURCE_NAME;
            }
            case 20: {
                return IGNORE_NAME;
            }
            case 21: {
                return INTERNAL_NAME;
            }
            case 22: {
                return LICENSE_NAME;
            }
            case 23: {
                return LINK_NAME;
            }
            case 24: {
                return SINCE_NAME;
            }
            case 25: {
                return SUBPACKAGE_NAME;
            }
            case 26: {
                return TUTORIAL_NAME;
            }
            case 27: {
                return USES_NAME;
            }
            case 28: {
                return VERSION_NAME;
            }
            case 29: {
                return THROWS_NAME;
            }
            case 30: {
                return PROPERTY_NAME;
            }
            case 31: {
                return PROPERTY_READ_NAME;
            }
            case 32: {
                return PROPERTY_WRITE_NAME;
            }
            case 33: {
                return METHOD_NAME;
            }
        }
        return ERROR;
    }
}

