/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentorLexer
implements IDocumentorLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int ST_IN_TAGS = 6;
    public static final int YYINITIAL = 0;
    public static final int ST_IN_SHORT_DESC = 2;
    public static final int ST_IN_LONG_DESC = 4;
    private static final int[] ZZ_LEXSTATE;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0002\u0002\u0000\u0001\u0003\u0012\u0000\u0001\u0001\t\u0000\u0001\u0004\u0002\u0000\u0001\u001f\u0001\u0006\u0001\u0005\u0010\u0000\u0001\u0007\u0001\b\u0001\t\u0001\r\u0001\u0016\u0001\u000e\u0001\u001a\u0001\u0012\u0001\u0010\u0001\u0015\u0001\u0000\u0001\u001c\u0001\u0019\u0001\u0018\u0001\u001b\u0001\u0011\u0001\u0014\u0001\u0000\u0001\f\u0001\n\u0001\u000b\u0001\u000f\u0001\u001d\u0001\u001e\u0001\u0017\u0001\u0013\u0007\u0000\u0001\b\u0001\t\u0001\r\u0001\u0016\u0001\u000e\u0001\u001a\u0001\u0012\u0001\u0010\u0001\u0015\u0001\u0000\u0001\u001c\u0001\u0019\u0001\u0018\u0001\u001b\u0001\u0011\u0001\u0014\u0001\u0000\u0001\f\u0001\n\u0001\u000b\u0001\u000f\u0001\u001d\u0001\u001e\u0001\u0017\u0001\u0013\uff86\u0000";
    private static final char[] ZZ_CMAP;
    private static final int[] ZZ_ACTION;
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0003\u0002\u0002\u0003\u0003\u0002\u0002\u0004\u0003\u0002\u0002\u0005\u0001\u0002\u0002\u0001\u0002\u0002\u0002\u0001\u0001\u0002\u0003\u0000\u0001\u0006\u0001\u0007\u0002\u0006\u0002\u0001\u0001\u0000\u0001\u0001\u0001\b\u0012\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\n\u0001\u0000\u0001\u0001\u0010\u0000\u0001\u000b6\u0000\u0002\u000b\u0004\u0000\u0001\f\u0018\u0000\u0001\r\u0005\u0000\u0001\u000e\u0018\u0000\u0001\u000f\t\u0000\u0001\u0010\u0004\u0000\u0001\u0011\u0006\u0000\u0001\u0012\u0003\u0000\u0001\u0013\u0002\u0000\u0001\u0014\t\u0000\u0001\u0015\u0004\u0000\u0001\u0016\u0006\u0000\u0001\u0017\u0003\u0000\u0001\u0018\u0002\u0000\u0001\u0019\u0006\u0000\u0001\u001a\u0007\u0000\u0001\u001b\b\u0000\u0001\u001c\u0006\u0000\u0001\u001d\u0007\u0000\u0001\u001e\b\u0000\u0001\u001f\u0002\u0000\u0001 \u0001!\u0001\"\u0002\u0000\u0001#\u0001$\u0003\u0000\u0001%\u0002\u0000\u0001&\u0002\u0000\u0001'\u0004\u0000\u0001(\u0001)\u0001*\u0002\u0000\u0001+\u0001,\u0003\u0000\u0001-\u0002\u0000\u0001.\u0002\u0000\u0001/\t\u0000\u00010\u00011\u0003\u0000\u00012\u0001\u0000\u00013\u0006\u0000\u00014\u00015\u0003\u0000\u00016\u0001\u0000\u00017\u00018\u0002\u0000\u00019\u0001:\u0001\u0000\u0001;\u0001<\u0002\u0000\u0001=\u0002\u0000\u0001>\u0001?\u0001\u0000\u0001@\u0001A\u0002\u0000\u0001B\u0001\u0000\u0001C\u0003\u0000\u0001D\u0001\u0000\u0001E\u0003\u0000\u0001F\u0002\u0000\u0001G\u0001H\u0001I\u0002\u0000\u0001J\u0001K\b\u0000\u0001L\u0001\u0000\u0001M\u0001\u0000\u0001N\u0001O";
    private static final int[] ZZ_ROWMAP;
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000 \u0000@\u0000`\u0000\u0080\u0000\u00a0\u0000\u00c0\u0000\u00e0\u0000\u0100\u0000\u0120\u0000\u0140\u0000\u0100\u0000\u0160\u0000\u0180\u0000\u01a0\u0000\u01c0\u0000\u0100\u0000\u01e0\u0000\u0200\u0000\u0220\u0000\u0240\u0000\u0100\u0000\u0260\u0000\u0280\u0000\u02a0\u0000\u02c0\u0000\u02e0\u0000\u0300\u0000\u0320\u0000\u0340\u0000\u0360\u0000\u0380\u0000\u0140\u0000\u0180\u0000\u0100\u0000\u0100\u0000\u03a0\u0000\u03c0\u0000\u01c0\u0000\u0200\u0000\u0220\u0000\u03e0\u0000\u0100\u0000\u0400\u0000\u0420\u0000\u0440\u0000\u0460\u0000\u0480\u0000\u04a0\u0000\u04c0\u0000\u04e0\u0000\u0500\u0000\u0520\u0000\u0540\u0000\u0560\u0000\u0580\u0000\u05a0\u0000\u05c0\u0000\u05e0\u0000\u0240\u0000\u0280\u0000\u0100\u0000\u0600\u0000\u02e0\u0000\u0300\u0000\u0100\u0000\u0360\u0000\u0620\u0000\u0640\u0000\u0660\u0000\u0680\u0000\u06a0\u0000\u06c0\u0000\u06e0\u0000\u0700\u0000\u0720\u0000\u0740\u0000\u0760\u0000\u0780\u0000\u07a0\u0000\u07c0\u0000\u07e0\u0000\u0800\u0000\u0820\u0000\u0840\u0000\u0860\u0000\u0880\u0000\u08a0\u0000\u08c0\u0000\u08e0\u0000\u0900\u0000\u0920\u0000\u0940\u0000\u0960\u0000\u0980\u0000\u09a0\u0000\u09c0\u0000\u09e0\u0000\u0a00\u0000\u0a20\u0000\u0a40\u0000\u0a60\u0000\u0a80\u0000\u0aa0\u0000\u0ac0\u0000\u0ae0\u0000\u0b00\u0000\u0b20\u0000\u0b40\u0000\u0b60\u0000\u0b80\u0000\u0ba0\u0000\u0bc0\u0000\u0be0\u0000\u0c00\u0000\u0c20\u0000\u0c40\u0000\u0c60\u0000\u0c80\u0000\u0ca0\u0000\u0cc0\u0000\u0ce0\u0000\u0d00\u0000\u0d20\u0000\u0d40\u0000\u0d60\u0000\u0d80\u0000\u0da0\u0000\u0dc0\u0000\u0de0\u0000\u0e00\u0000\u0e20\u0000\u0e40\u0000\u0e60\u0000\u0e80\u0000\u0ea0\u0000\u0ec0\u0000\u0ee0\u0000\u0f00\u0000\u0100\u0000\u0f20\u0000\u0f40\u0000\u0f60\u0000\u0f80\u0000\u0fa0\u0000\u0100\u0000\u0fc0\u0000\u0fe0\u0000\u1000\u0000\u1020\u0000\u1040\u0000\u1060\u0000\u1080\u0000\u10a0\u0000\u10c0\u0000\u10e0\u0000\u1100\u0000\u1120\u0000\u1140\u0000\u1160\u0000\u1180\u0000\u11a0\u0000\u11c0\u0000\u11e0\u0000\u1200\u0000\u1220\u0000\u1240\u0000\u1260\u0000\u1280\u0000\u12a0\u0000\u0100\u0000\u12c0\u0000\u12e0\u0000\u1300\u0000\u1320\u0000\u1340\u0000\u0100\u0000\u1360\u0000\u1380\u0000\u13a0\u0000\u13c0\u0000\u13e0\u0000\u1400\u0000\u1420\u0000\u1440\u0000\u1460\u0000\u1480\u0000\u14a0\u0000\u14c0\u0000\u14e0\u0000\u1500\u0000\u1520\u0000\u1540\u0000\u1560\u0000\u1580\u0000\u15a0\u0000\u15c0\u0000\u15e0\u0000\u1600\u0000\u1620\u0000\u1640\u0000\u0100\u0000\u1660\u0000\u1680\u0000\u16a0\u0000\u16c0\u0000\u16e0\u0000\u1700\u0000\u1720\u0000\u1740\u0000\u1760\u0000\u0100\u0000\u1780\u0000\u17a0\u0000\u17c0\u0000\u17e0\u0000\u0100\u0000\u1800\u0000\u1820\u0000\u1840\u0000\u1860\u0000\u1880\u0000\u18a0\u0000\u0100\u0000\u18c0\u0000\u18e0\u0000\u1900\u0000\u0100\u0000\u1920\u0000\u1940\u0000\u0100\u0000\u1960\u0000\u1980\u0000\u19a0\u0000\u19c0\u0000\u19e0\u0000\u1a00\u0000\u1a20\u0000\u1a40\u0000\u1a60\u0000\u0100\u0000\u1a80\u0000\u1aa0\u0000\u1ac0\u0000\u1ae0\u0000\u0100\u0000\u1b00\u0000\u1b20\u0000\u1b40\u0000\u1b60\u0000\u1b80\u0000\u1ba0\u0000\u0100\u0000\u1bc0\u0000\u1be0\u0000\u1c00\u0000\u0100\u0000\u1c20\u0000\u1c40\u0000\u0100\u0000\u1c60\u0000\u1c80\u0000\u1ca0\u0000\u1cc0\u0000\u1ce0\u0000\u1d00\u0000\u0100\u0000\u1d20\u0000\u1d40\u0000\u1d60\u0000\u1d80\u0000\u1da0\u0000\u1dc0\u0000\u1de0\u0000\u0100\u0000\u1e00\u0000\u1e20\u0000\u1e40\u0000\u1e60\u0000\u1e80\u0000\u1ea0\u0000\u1ec0\u0000\u1ee0\u0000\u0100\u0000\u1f00\u0000\u1f20\u0000\u1f40\u0000\u1f60\u0000\u1f80\u0000\u1fa0\u0000\u0100\u0000\u1fc0\u0000\u1fe0\u0000\u2000\u0000\u2020\u0000\u2040\u0000\u2060\u0000\u2080\u0000\u0100\u0000\u20a0\u0000\u20c0\u0000\u20e0\u0000\u2100\u0000\u2120\u0000\u2140\u0000\u2160\u0000\u2180\u0000\u0100\u0000\u21a0\u0000\u21c0\u0000\u0100\u0000\u0100\u0000\u21e0\u0000\u2200\u0000\u2220\u0000\u0100\u0000\u0100\u0000\u2240\u0000\u2260\u0000\u2280\u0000\u0100\u0000\u22a0\u0000\u22c0\u0000\u0100\u0000\u22e0\u0000\u2300\u0000\u0100\u0000\u2320\u0000\u2340\u0000\u2360\u0000\u2380\u0000\u0100\u0000\u0100\u0000\u23a0\u0000\u23c0\u0000\u23e0\u0000\u0100\u0000\u0100\u0000\u2400\u0000\u2420\u0000\u2440\u0000\u0100\u0000\u2460\u0000\u2480\u0000\u0100\u0000\u24a0\u0000\u24c0\u0000\u0100\u0000\u24e0\u0000\u2500\u0000\u2520\u0000\u2540\u0000\u2560\u0000\u2580\u0000\u25a0\u0000\u25c0\u0000\u25e0\u0000\u0100\u0000\u0100\u0000\u2600\u0000\u2620\u0000\u2640\u0000\u0100\u0000\u2660\u0000\u0100\u0000\u2680\u0000\u26a0\u0000\u26c0\u0000\u26e0\u0000\u2700\u0000\u2720\u0000\u0100\u0000\u0100\u0000\u2740\u0000\u2760\u0000\u2780\u0000\u0100\u0000\u27a0\u0000\u0100\u0000\u0100\u0000\u27c0\u0000\u27e0\u0000\u0100\u0000\u0100\u0000\u2800\u0000\u2820\u0000\u0100\u0000\u2840\u0000\u2860\u0000\u0100\u0000\u2880\u0000\u28a0\u0000\u0100\u0000\u0100\u0000\u28c0\u0000\u28e0\u0000\u0100\u0000\u2900\u0000\u2920\u0000\u0100\u0000\u2940\u0000\u0100\u0000\u2960\u0000\u2980\u0000\u29a0\u0000\u0100\u0000\u29c0\u0000\u0100\u0000\u29e0\u0000\u2a00\u0000\u2a20\u0000\u0100\u0000\u2a40\u0000\u2a60\u0000\u0100\u0000\u0100\u0000\u0100\u0000\u2a80\u0000\u2aa0\u0000\u0100\u0000\u0100\u0000\u2ac0\u0000\u2ae0\u0000\u2b00\u0000\u2b20\u0000\u2b40\u0000\u2b60\u0000\u2b80\u0000\u2ba0\u0000\u0100\u0000\u2bc0\u0000\u0100\u0000\u2be0\u0000\u0100\u0000\u0100";
    private static final int[] ZZ_TRANS;
    private static final String ZZ_TRANS_PACKED_0 = "%\t\u0001\n\u001b\t\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\t\u0001\u000f\u001a\t\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\t\u0001\u000f\u0001\u0014\u0019\t\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u001c\t\u0001\u0019\u0001\u0016\u0001\u0017\u0001\u001a\u0002\t\u0001\u0014\u0019\t\u0001\u001b\u0001\u0016\u0001\u0017\u0001\u001c\u001c\t\u0001\u001d\u0001\u0016\u0001\u0017\u0001\u001e\u0002\t\u0001\u001f\u0018\t$\u0000\u0001 \u001c\u0000\u0001!\u0002\u0000\u0001\"\u0001\u0000\u0001#\u001b\u0000\u0001\f\"\u0000\u0001$\u001b\u0000\u0001%\u0001#\u0001&\u001d\u0000\u0001'\u0001\u0011\u0001\u0012\u0001(\u0001\u0000\u0001#\u0001)\u001a\u0000\u0001\u0011\u001e\u0000\u0001*\u0001\u0011\u0001\u0012\u0001\u0000\u0001+\u0001\u0000\u0001) \u0000\u0001,\u0001\u0000\u0001-\u0001.\u0001/\u00010\u00011\u00012\u0002\u0000\u00013\u0001\u0000\u00014\u00015\u00016\u0001\u0000\u00017\u00018\u00019\u0001:\u0001\u0000\u0001;\u0003\u0000\u0001<\u0002\u0000\u0001=\u001d\u0000\u0001\u0016\"\u0000\u0001>\u001b\u0000\u0001\u0019\u0002\u0000\u0001\u001a\u0002\u0000\u0001)\u0019\u0000\u0001?\u0003\u0000\u0001>\u0001\u0000\u0001)\u0019\u0000\u0001@\u0002\u0000\u0001A \u0000\u0001B\u001b\u0000\u0001\u001d\u0002\u0000\u0001\u001e\u0002\u0000\u0001C\u0019\u0000\u0001D\u0003\u0000\u0001B\u0001\u0000\u0001C \u0000\u0001E\u0001\u0000\u0001F\u0001G\u0001H\u0001I\u0001J\u0001K\u0002\u0000\u0001L\u0001\u0000\u0001M\u0001N\u0001O\u0001\u0000\u0001P\u0001Q\u0001R\u0001S\u0001\u0000\u0001T\u0006\u0000\u0001U\u001c\u0000\u0001% \u0000\u0001#\u001e\u0000\u0001*\u0001\u0011\u0001\u0012\u0003\u0000\u0001)!\u0000\u0001V\u0003\u0000\u0001W\u0001\u0000\u0001X\u001b\u0000\u0001Y\u0002\u0000\u0001Z\u0001[\u0005\u0000\u0001\\\u0019\u0000\u0001]\u0001^\u0001_\u001c\u0000\u0001`\u0019\u0000\u0001a\b\u0000\u0001b%\u0000\u0001c\u0012\u0000\u0001d.\u0000\u0001e\u000e\u0000\u0001f\u0003\u0000\u0001g%\u0000\u0001h\b\u0000\u0001i\u0012\u0000\u0001j\u001f\u0000\u0001k&\u0000\u0001l\u001f\u0000\u0001m\u0012\u0000\u0001n\u001f\u0000\u0001o\u0005\u0000\u0001p\u0012\u0000\u0001?\u0005\u0000\u0001)\u0019\u0000\u0001D\u0005\u0000\u0001C!\u0000\u0001q\u0003\u0000\u0001r\u0001\u0000\u0001s\u001b\u0000\u0001t\u0002\u0000\u0001u\u0001v\u0005\u0000\u0001w\u0019\u0000\u0001x\u0001y\u0001z\u001c\u0000\u0001{\u0019\u0000\u0001|\b\u0000\u0001}%\u0000\u0001~\u0012\u0000\u0001\u007f.\u0000\u0001\u0080\u000e\u0000\u0001\u0081\u0003\u0000\u0001\u0082%\u0000\u0001\u0083\b\u0000\u0001\u0084\u0012\u0000\u0001\u0085\u001f\u0000\u0001\u0086&\u0000\u0001\u0087\u001f\u0000\u0001\u0088\u0012\u0000\u0001\u0089\u001f\u0000\u0001\u008a\u0005\u0000\u0001\u008b\u0012\u0000\u0001U\u0001\u008c\u0001\u008d&\u0000\u0001\u008e\"\u0000\u0001\u008f\u001d\u0000\u0001\u0090\u001c\u0000\u0001\u0091%\u0000\u0001\u0092\u001a\u0000\u0001\u00931\u0000\u0001\u0094\u000f\u0000\u0001\u0095 \u0000\u0001\u0096)\u0000\u0001\u0097\u0014\u0000\u0001\u0098\u001f\u0000\u0001\u0099(\u0000\u0001\u009a\u0013\u0000\u0001\u009b%\u0000\u0001\u009c\"\u0000\u0001\u009d\u001a\u0000\u0001\u009e\u0001\u009f#\u0000\u0001\u00a0)\u0000\u0001\u00a1\u000f\u0000\u0001\u00a2\u001e\u0000\u0001\u00a3\t\u0000\u0001\u00a4\u0016\u0000\u0001\u00a5!\u0000\u0001\u00a6\r\u0000\u0001\u00a7\u001d\u0000\u0001\u00a8\u0001\u0000\u0001\u00a9\u001c\u0000\u0001\u00aa\u0013\u0000\u0001\u00ab\u001f\u0000\u0001\u00ac\u001d\u0000\u0001\u00ad\"\u0000\u0001\u00ae\u001d\u0000\u0001\u00af\u001c\u0000\u0001\u00b0%\u0000\u0001\u00b1\u001a\u0000\u0001\u00b21\u0000\u0001\u00b3\u000f\u0000\u0001\u00b4 \u0000\u0001\u00b5)\u0000\u0001\u00b6\u0014\u0000\u0001\u00b7\u001f\u0000\u0001\u00b8(\u0000\u0001\u00b9\u0013\u0000\u0001\u00ba%\u0000\u0001\u00bb\"\u0000\u0001\u00bc\u001a\u0000\u0001\u00bd\u0001\u00be#\u0000\u0001\u00bf)\u0000\u0001\u00c0\u000f\u0000\u0001\u00c1\u001e\u0000\u0001\u00c2\t\u0000\u0001\u00c3\u0016\u0000\u0001\u00c4!\u0000\u0001\u00c5\r\u0000\u0001\u00c6\u001d\u0000\u0001\u00c7\u0001\u0000\u0001\u00c8\u001c\u0000\u0001\u00c9\u0013\u0000\u0001\u00ca\u001f\u0000\u0001\u00cb\u0015\u0000\u0001\u008c(\u0000\u0001\u00cc\"\u0000\u0001\u00cd!\u0000\u0001\u00ce\u001a\u0000\u0001\u00cf(\u0000\u0001\u00d0\u0018\u0000\u0001\u00d1#\u0000\u0001\u00d2\u001f\u0000\u0001\u00d3\u001f\u0000\u0001\u00d4\u001d\u0000\u0001\u00d5\u001e\u0000\u0001\u00d6$\u0000\u0001\u00d7$\u0000\u0001\u00d8\u0011\u0000\u0001\u00d9\u001e\u0000\u0001\u00da\u001e\u0000\u0001\u00db3\u0000\u0001\u00dc\u0017\u0000\u0001\u00dd\u001c\u0000\u0001\u00de\u001c\u0000\u0001\u00df\u001e\u0000\u0001\u00e0\u001e\u0000\u0001\u00e1#\u0000\u0001\u00e2\u001d\u0000\u0001\u00e3-\u0000\u0001\u00e4\u0011\u0000\u0001\u00e5\u0019\u0000\u0001\u00e6%\u0000\u0001\u00e7\u001b\u0000\u0001\u00e8 \u0000\u0001\u00e9\"\u0000\u0001\u00ea!\u0000\u0001\u00eb\u001a\u0000\u0001\u00ec(\u0000\u0001\u00ed\u0018\u0000\u0001\u00ee#\u0000\u0001\u00ef\u001f\u0000\u0001\u00f0\u001f\u0000\u0001\u00f1\u001d\u0000\u0001\u00f2\u001e\u0000\u0001\u00f3$\u0000\u0001\u00f4$\u0000\u0001\u00f5\u0011\u0000\u0001\u00f6\u001e\u0000\u0001\u00f7\u001e\u0000\u0001\u00f83\u0000\u0001\u00f9\u0017\u0000\u0001\u00fa\u001c\u0000\u0001\u00fb\u001c\u0000\u0001\u00fc\u001e\u0000\u0001\u00fd\u001e\u0000\u0001\u00fe#\u0000\u0001\u00ff\u001d\u0000\u0001\u0100-\u0000\u0001\u0101\u0011\u0000\u0001\u0102\u0019\u0000\u0001\u0103%\u0000\u0001\u0104\u001b\u0000\u0001\u0105!\u0000\u0001\u0106\u001d\u0000\u0001\u0107&\u0000\u0001\u0108#\u0000\u0001\u0109\u0012\u0000\u0001\u010a%\u0000\u0001\u010b\u001d\u0000\u0001\u010c1\u0000\u0001\u010d\r\u0000\u0001\u010e%\u0000\u0001\u010f\u0019\u0000\u0001\u0110'\u0000\u0001\u0111\u0013\u0000\u0001\u0112/\u0000\u0001\u0113\u000f\u0000\u0001\u0114%\u0000\u0001\u0115\u001d\u0000\u0001\u0116\u001f\u0000\u0001\u0117!\u0000\u0001\u0118\"\u0000\u0001\u0119)\u0000\u0001\u011a\u000e\u0000\u0001\u011b.\u0000\u0001\u011c\u001b\u0000\u0001\u011d\u0016\u0000\u0001\u011e\u001d\u0000\u0001\u011f&\u0000\u0001\u0120#\u0000\u0001\u0121\u0012\u0000\u0001\u0122%\u0000\u0001\u0123\u001d\u0000\u0001\u01241\u0000\u0001\u0125\r\u0000\u0001\u0126%\u0000\u0001\u0127\u0019\u0000\u0001\u0128'\u0000\u0001\u0129\u0013\u0000\u0001\u012a/\u0000\u0001\u012b\u000f\u0000\u0001\u012c%\u0000\u0001\u012d\u001d\u0000\u0001\u012e\u001f\u0000\u0001\u012f!\u0000\u0001\u0130\"\u0000\u0001\u0131)\u0000\u0001\u0132\u000e\u0000\u0001\u0133.\u0000\u0001\u0134\u001b\u0000\u0001\u0135\u0012\u0000\u0001\u0136!\u0000\u0001\u0137!\u0000\u0001\u0138 \u0000\u0001\u0139\u001f\u0000\u0001\u013a'\u0000\u0001\u013b\u0014\u0000\u0001\u013c0\u0000\u0001\u013d\u0015\u0000\u0001\u013e#\u0000\u0001\u013f#\u0000\u0001\u0140\u001f\u0000\u0001\u0141\u0018\u0000\u0001\u0142\u0019\u0000\u0001\u0143!\u0000\u0001\u0144,\u0000\u0001\u0145\u0011\u0000\u0001\u0146(\u0000\u0001\u0147\u0013\u0000\u0001\u0148&\u0000\u0001\u0149\u001f\u0000\u0001\u014a\u0016\u0000\u0001\u014b!\u0000\u0001\u014c!\u0000\u0001\u014d \u0000\u0001\u014e\u001f\u0000\u0001\u014f'\u0000\u0001\u0150\u0014\u0000\u0001\u01510\u0000\u0001\u0152\u0015\u0000\u0001\u0153#\u0000\u0001\u0154#\u0000\u0001\u0155\u001f\u0000\u0001\u0156\u0018\u0000\u0001\u0157\u0019\u0000\u0001\u0158!\u0000\u0001\u0159,\u0000\u0001\u015a\u0011\u0000\u0001\u015b(\u0000\u0001\u015c\u0013\u0000\u0001\u015d&\u0000\u0001\u015e\u001f\u0000\u0001\u015f\u001b\u0000\u0001\u0160/\u0000\u0001\u0161\u001e\u0000\u0001\u0162\u000b\u0000\u0001\u0163#\u0000\u0001\u0164%\u0000\u0001\u0165\u001b\u0000\u0001\u0166\u001f\u0000\u0001\u0167\u001c\u0000\u0001\u0168\u001c\u0000\u0001\u0169\u001f\u0000\u0001\u016a%\u0000\u0001\u016b \u0000\u0001\u016c+\u0000\u0001\u016d\u0011\u0000\u0001\u016e/\u0000\u0001\u016f\u001e\u0000\u0001\u0170\u000b\u0000\u0001\u0171#\u0000\u0001\u0172%\u0000\u0001\u0173\u001b\u0000\u0001\u0174\u001f\u0000\u0001\u0175\u001c\u0000\u0001\u0176\u001c\u0000\u0001\u0177\u001f\u0000\u0001\u0178%\u0000\u0001\u0179 \u0000\u0001\u017a+\u0000\u0001\u017b\u000f\u0000\u0001\u017c\u001c\u0000\u0001\u017d\u001f\u0000\u0001\u017e0\u0000\u0001\u017f\u0019\u0000\u0001\u0180\u001c\u0000\u0001\u0181\"\u0000\u0001\u0182%\u0000\u0001\u0183\u0011\u0000\u0001\u0184 \u0000\u0001\u0185\u001e\u0000\u0001\u0186\u001c\u0000\u0001\u0187\u001f\u0000\u0001\u01880\u0000\u0001\u0189\u0019\u0000\u0001\u018a\u001c\u0000\u0001\u018b\"\u0000\u0001\u018c%\u0000\u0001\u018d\u0011\u0000\u0001\u018e \u0000\u0001\u018f\u001f\u0000\u0001\u0190%\u0000\u0001\u0191\u0018\u0000\u0001\u01923\u0000\u0001\u0193\u000e\u0000\u0001\u0194\u001e\u0000\u0001\u0195\u001e\u0000\u0001\u0196%\u0000\u0001\u0197\u0018\u0000\u0001\u01983\u0000\u0001\u0199\u000e\u0000\u0001\u019a\u001e\u0000\u0001\u019b \u0000\u0001\u019c\u001d\u0000\u0001\u019d\u0011\u0000\u0001\u019e\u0017\u0000\u0001\u019f\u0017\u0000\u0001\u01a0\u001f\u0000\u0001\u01a1\u001d\u0000\u0001\u01a2\u0011\u0000\u0001\u01a3\u0017\u0000\u0001\u01a4\u0017\u0000\u0001\u01a5\u001f\u0000\u0001\u01a6\u001d\u0000\u0001\u01a7!\u0000\u0001\u01a8\u001d\u0000\u0001\u01a9\u001b\u0000\u0001\u01aa,\u0000\u0001\u01ab\u0012\u0000\u0001\u01ac,\u0000\u0001\u01ad \u0000\u0001\u01ae\u0014\u0000\u0001\u01af*\u0000\u0001\u01b0\u0014\u0000\u0001\u01b1\"\u0000\u0001\u01b2\u001f\u0000\u0001\u01b3\u0011\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG;
    private static final int[] ZZ_ATTRIBUTE;
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0004\u0001\u0001\t\u0004\u0001\u0001\t\t\u0001\u0003\u0000\u0002\t\u0004\u0001\u0001\u0000\u0001\u0001\u0001\t\u0012\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\t\u0001\u0000\u0001\u0001\u0010\u0000\u0001\u00016\u0000\u0001\t\u0001\u0001\u0004\u0000\u0001\t\u0018\u0000\u0001\t\u0005\u0000\u0001\t\u0018\u0000\u0001\t\t\u0000\u0001\t\u0004\u0000\u0001\t\u0006\u0000\u0001\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\t\u0000\u0001\t\u0004\u0000\u0001\t\u0006\u0000\u0001\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0006\u0000\u0001\t\u0007\u0000\u0001\t\b\u0000\u0001\t\u0006\u0000\u0001\t\u0007\u0000\u0001\t\b\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0001\u0002\u0000\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0002\t\u0001\u0001\u0002\u0000\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\t\u0000\u0002\t\u0003\u0000\u0001\t\u0001\u0000\u0001\t\u0006\u0000\u0002\t\u0003\u0000\u0001\t\u0001\u0000\u0002\t\u0002\u0000\u0002\t\u0001\u0000\u0001\u0001\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0000\u0001\u0001\u0001\t\u0002\u0000\u0001\t\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u0002\u0000\u0003\t\u0002\u0000\u0002\t\b\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private String shortDesc = null;
    private String longDesc = null;
    private ArrayList<PHPDocTag> tagList = null;
    private int currTagId = 0;
    private int tagPosition = 0;
    private StringBuffer sBuffer = null;
    private int numOfLines = 0;
    private int startPos = 0;
    private List<Scalar> textList;
    int maxNumberofLines = 4;
    String oldString = null;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        ZZ_LEXSTATE = nArray;
        ZZ_CMAP = DocumentorLexer.zzUnpackCMap(ZZ_CMAP_PACKED);
        ZZ_ACTION = DocumentorLexer.zzUnpackAction();
        ZZ_ROWMAP = DocumentorLexer.zzUnpackRowMap();
        ZZ_TRANS = DocumentorLexer.zzUnpackTrans();
        ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
        ZZ_ATTRIBUTE = DocumentorLexer.zzUnpackAttribute();
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[435];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[435];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[11264];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[435];
        int offset = 0;
        offset = DocumentorLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public PHPDocBlock parse() {
        int start = this.zzStartRead - this.zzPushbackPos;
        this.longDesc = "";
        this.tagList = new ArrayList();
        this.textList = new ArrayList<Scalar>();
        this.sBuffer = new StringBuffer();
        this.numOfLines = 1;
        try {
            this.next_token();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        if (!this.tagList.isEmpty() && !this.textList.isEmpty()) {
            Scalar lastText = this.textList.get(this.textList.size() - 1);
            PHPDocTag lastTag = this.tagList.get(this.tagList.size() - 1);
            if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
                this.textList.remove(this.textList.size() - 1);
                if (!this.isBlank(lastText.getValue())) {
                    lastTag.getTexts().add(lastText);
                }
            }
        }
        PHPDocTag[] tags = new PHPDocTag[this.tagList.size()];
        this.tagList.toArray(tags);
        PHPDocBlock rv = new PHPDocBlock(start, this.zzMarkedPos - this.zzPushbackPos, this.shortDesc, this.longDesc, tags, this.textList);
        return rv;
    }

    private boolean isBlank(String value) {
        char[] line = value.toCharArray();
        int i = 0;
        while (i < line.length) {
            char c = line[i];
            if (c != '\t' && c != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void startTagsState(int firstState) {
        this.updateStartPos();
        this.hendleDesc();
        this.currTagId = firstState;
        this.tagPosition = this.findTagPosition();
        this.sBuffer = new StringBuffer();
        this.yybegin(6);
    }

    private int findTagPosition() {
        int i = this.zzStartRead;
        while (i < this.zzMarkedPos) {
            if (this.zzBuffer[i] == '@') {
                return i - this.zzPushbackPos;
            }
            ++i;
        }
        return -1;
    }

    private void setNewTag(int newTag) {
        this.updateStartPos();
        this.setTagValue();
        this.sBuffer = new StringBuffer();
        this.currTagId = newTag;
        this.tagPosition = this.findTagPosition();
    }

    private void setTagValue() {
        String value = this.sBuffer.toString();
        if (this.currTagId == 17) {
            this.shortDesc = String.valueOf(this.shortDesc) + value;
            return;
        }
        PHPDocTag basicPHPDocTag = new PHPDocTag(this.tagPosition, this.zzStartRead - this.zzPushbackPos, this.currTagId, value, this.getTexts(this.tagPosition, this.zzStartRead, true));
        this.tagList.add(basicPHPDocTag);
    }

    private List<Scalar> getTexts(int start, int end, boolean remove) {
        ArrayList<Scalar> result = new ArrayList<Scalar>();
        Iterator<Scalar> iterator = this.textList.iterator();
        while (iterator.hasNext()) {
            Scalar scalar = iterator.next();
            if (scalar.sourceStart() < start || scalar.sourceEnd() > end) continue;
            result.add(scalar);
            if (!remove) continue;
            iterator.remove();
        }
        return result;
    }

    private void appendText() {
        if (this.oldString != null) {
            this.sBuffer.append(this.oldString);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos);
        this.addText(sb.toString());
        this.sBuffer.append(sb);
        this.updateStartPos();
    }

    private void addText(String string) {
        this.textList.add(new Scalar(this.startPos, this.startPos + string.length(), string, 2));
    }

    private void hendleDesc() {
        if (this.zzLexicalState == 2) {
            this.shortDesc = this.sBuffer.toString().trim();
        } else {
            this.longDesc = this.sBuffer.toString().trim();
        }
        this.sBuffer = new StringBuffer();
    }

    private void startLongDescState(boolean withNewLine) {
        this.hendleDesc();
        this.updateStartPos();
        if (!withNewLine) {
            this.addText("");
        }
        this.yybegin(4);
    }

    private void hendleNewLine() {
        this.appendText();
        if (this.numOfLines == 4) {
            int firstLineEnd = this.sBuffer.indexOf("\n", 1);
            this.shortDesc = this.sBuffer.substring(0, firstLineEnd);
            this.shortDesc = this.shortDesc.trim();
            this.sBuffer.delete(0, firstLineEnd);
            this.yybegin(4);
        } else {
            ++this.numOfLines;
        }
    }

    private void appendLastText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos - 2);
        this.addText(sb.toString());
        this.sBuffer.append(sb);
        this.updateStartPos();
    }

    private void handleDocEnd_shortDesc() {
        this.appendLastText();
        if (this.numOfLines == this.maxNumberofLines) {
            int firstLineEnd = this.sBuffer.indexOf("\n", 1);
            this.shortDesc = this.sBuffer.substring(0, firstLineEnd);
            this.shortDesc = this.shortDesc.trim();
            this.sBuffer.delete(0, firstLineEnd);
            this.longDesc = this.sBuffer.toString().trim();
        } else {
            this.shortDesc = this.sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
        this.appendLastText();
        this.longDesc = this.sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        this.appendLastText();
        this.setTagValue();
    }

    private void updateStartPos() {
        this.startPos = this.zzMarkedPos;
        this.oldString = null;
    }

    @Override
    public void reset(Reader reader, char[] buffer, int[] parameters) {
        this.zzReader = reader;
        this.zzBuffer = buffer;
        this.zzMarkedPos = parameters[0];
        this.zzPushbackPos = parameters[1];
        this.zzCurrentPos = parameters[2];
        this.zzStartRead = parameters[3];
        this.zzEndRead = parameters[4];
        this.yyline = parameters[5];
    }

    @Override
    public int[] getParamenters() {
        return new int[]{this.zzMarkedPos, this.zzPushbackPos, this.zzCurrentPos, this.zzStartRead, this.zzEndRead, this.yyline, this.zzLexicalState};
    }

    @Override
    public char[] getBuffer() {
        return this.zzBuffer;
    }

    public DocumentorLexer(Reader in) {
        this.zzReader = in;
    }

    public DocumentorLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 134) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        this.oldString = new String(this.zzBuffer, this.startPos, this.zzMarkedPos - this.startPos);
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.startPos = 0;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int next_token() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block168: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            int zzCurrentPosL = this.zzStartRead;
            while (zzCurrentPosL < zzMarkedPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        break;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        break;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            break;
                        }
                        ++this.yyline;
                        break;
                    }
                    default: {
                        zzR = false;
                    }
                }
                ++zzCurrentPosL;
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof2 = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof2) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            if (zzMarkedPosL > this.zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        this.zzAtBOL = true;
                        break;
                    }
                    case '\r': {
                        if (zzMarkedPosL < zzEndReadL) {
                            this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                            break;
                        }
                        if (this.zzAtEOF) {
                            this.zzAtBOL = false;
                            break;
                        }
                        eof = this.zzRefill();
                        zzMarkedPosL = this.zzMarkedPos;
                        zzEndReadL = this.zzEndRead;
                        zzBufferL = this.zzBuffer;
                        if (eof) {
                            this.zzAtBOL = false;
                            break;
                        }
                        this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        break;
                    }
                    default: {
                        this.zzAtBOL = false;
                    }
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzAtBOL ? ZZ_LEXSTATE[this.zzLexicalState + 1] : ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 16: {
                    this.startTagsState(11);
                }
                case 80: {
                    continue block168;
                }
                case 44: {
                    this.setNewTag(6);
                }
                case 81: {
                    continue block168;
                }
                case 51: {
                    this.startTagsState(28);
                }
                case 82: {
                    continue block168;
                }
                case 45: {
                    this.setNewTag(4);
                }
                case 83: {
                    continue block168;
                }
                case 32: {
                    this.startTagsState(14);
                }
                case 84: {
                    continue block168;
                }
                case 71: {
                    this.startTagsState(2);
                }
                case 85: {
                    continue block168;
                }
                case 13: {
                    this.startTagsState(12);
                }
                case 86: {
                    continue block168;
                }
                case 69: {
                    this.setNewTag(16);
                }
                case 87: {
                    continue block168;
                }
                case 15: {
                    this.setNewTag(12);
                }
                case 88: {
                    continue block168;
                }
                case 42: {
                    this.setNewTag(9);
                }
                case 89: {
                    continue block168;
                }
                case 59: {
                    this.startTagsState(30);
                }
                case 90: {
                    continue block168;
                }
                case 18: {
                    this.startTagsState(17);
                }
                case 91: {
                    continue block168;
                }
                case 63: {
                    this.setNewTag(15);
                }
                case 92: {
                    continue block168;
                }
                case 12: {
                    this.startTagsState(8);
                }
                case 93: {
                    continue block168;
                }
                case 14: {
                    this.setNewTag(8);
                }
                case 94: {
                    continue block168;
                }
                case 50: {
                    this.startTagsState(22);
                }
                case 95: {
                    continue block168;
                }
                case 21: {
                    this.setNewTag(11);
                }
                case 96: {
                    continue block168;
                }
                case 43: {
                    this.setNewTag(29);
                }
                case 97: {
                    continue block168;
                }
                case 65: {
                    this.setNewTag(21);
                }
                case 98: {
                    continue block168;
                }
                case 20: {
                    this.startTagsState(5);
                }
                case 99: {
                    continue block168;
                }
                case 19: {
                    this.startTagsState(23);
                }
                case 100: {
                    continue block168;
                }
                case 17: {
                    this.startTagsState(27);
                }
                case 101: {
                    continue block168;
                }
                case 23: {
                    this.setNewTag(17);
                }
                case 102: {
                    continue block168;
                }
                case 52: {
                    this.setNewTag(18);
                }
                case 103: {
                    continue block168;
                }
                case 9: {
                    this.handleDocEnd_longDesc();
                    return -1;
                }
                case 104: {
                    continue block168;
                }
                case 29: {
                    this.setNewTag(24);
                }
                case 105: {
                    continue block168;
                }
                case 31: {
                    this.setNewTag(3);
                }
                case 106: {
                    continue block168;
                }
                case 79: {
                    this.setNewTag(32);
                }
                case 107: {
                    continue block168;
                }
                case 47: {
                    this.setNewTag(33);
                }
                case 108: {
                    continue block168;
                }
                case 55: {
                    this.setNewTag(28);
                }
                case 109: {
                    continue block168;
                }
                case 38: {
                    this.startTagsState(20);
                }
                case 110: {
                    continue block168;
                }
                case 67: {
                    this.startTagsState(16);
                }
                case 111: {
                    continue block168;
                }
                case 36: {
                    this.startTagsState(6);
                }
                case 112: {
                    continue block168;
                }
                case 68: {
                    this.setNewTag(10);
                }
                case 113: {
                    continue block168;
                }
                case 58: {
                    this.startTagsState(15);
                }
                case 114: {
                    continue block168;
                }
                case 78: {
                    this.startTagsState(32);
                }
                case 115: {
                    continue block168;
                }
                case 49: {
                    this.startTagsState(13);
                }
                case 116: {
                    continue block168;
                }
                case 37: {
                    this.startTagsState(4);
                }
                case 117: {
                    continue block168;
                }
                case 25: {
                    this.setNewTag(5);
                }
                case 118: {
                    continue block168;
                }
                case 26: {
                    this.startTagsState(24);
                }
                case 119: {
                    continue block168;
                }
                case 24: {
                    this.setNewTag(23);
                }
                case 120: {
                    continue block168;
                }
                case 41: {
                    this.setNewTag(1);
                }
                case 121: {
                    continue block168;
                }
                case 22: {
                    this.setNewTag(27);
                }
                case 122: {
                    continue block168;
                }
                case 60: {
                    this.startTagsState(21);
                }
                case 123: {
                    continue block168;
                }
                case 75: {
                    this.setNewTag(19);
                }
                case 124: {
                    continue block168;
                }
                case 61: {
                    this.setNewTag(0);
                }
                case 125: {
                    continue block168;
                }
                case 62: {
                    this.setNewTag(26);
                }
                case 126: {
                    continue block168;
                }
                case 54: {
                    this.setNewTag(22);
                }
                case 127: {
                    continue block168;
                }
                case 11: {
                    this.updateStartPos();
                    this.yybegin(2);
                }
                case 128: {
                    continue block168;
                }
                case 30: {
                    this.setNewTag(7);
                }
                case 129: {
                    continue block168;
                }
                case 3: {
                    this.hendleNewLine();
                }
                case 130: {
                    continue block168;
                }
                case 1: {
                    this.updateStartPos();
                }
                case 131: {
                    continue block168;
                }
                case 28: {
                    this.startTagsState(3);
                }
                case 132: {
                    continue block168;
                }
                case 35: {
                    this.startTagsState(29);
                }
                case 133: {
                    continue block168;
                }
                case 40: {
                    this.setNewTag(14);
                }
                case 134: {
                    continue block168;
                }
                case 6: {
                    this.appendText();
                    this.startLongDescState(true);
                }
                case 135: {
                    continue block168;
                }
                case 34: {
                    this.startTagsState(9);
                }
                case 136: {
                    continue block168;
                }
                case 4: {
                    this.startLongDescState(false);
                }
                case 137: {
                    continue block168;
                }
                case 73: {
                    this.setNewTag(25);
                }
                case 138: {
                    continue block168;
                }
                case 5: {
                    this.appendText();
                }
                case 139: {
                    continue block168;
                }
                case 77: {
                    this.setNewTag(31);
                }
                case 140: {
                    continue block168;
                }
                case 66: {
                    this.startTagsState(10);
                }
                case 141: {
                    continue block168;
                }
                case 39: {
                    this.startTagsState(33);
                }
                case 142: {
                    continue block168;
                }
                case 27: {
                    this.startTagsState(7);
                }
                case 143: {
                    continue block168;
                }
                case 53: {
                    this.setNewTag(13);
                }
                case 144: {
                    continue block168;
                }
                case 56: {
                    this.startTagsState(0);
                }
                case 145: {
                    continue block168;
                }
                case 57: {
                    this.startTagsState(26);
                }
                case 146: {
                    continue block168;
                }
                case 74: {
                    this.setNewTag(2);
                }
                case 147: {
                    continue block168;
                }
                case 72: {
                    this.startTagsState(19);
                }
                case 148: {
                    continue block168;
                }
                case 33: {
                    this.startTagsState(1);
                }
                case 149: {
                    continue block168;
                }
                case 76: {
                    this.startTagsState(31);
                }
                case 150: {
                    continue block168;
                }
                case 7: {
                    this.maxNumberofLines = 4;
                    this.handleDocEnd_shortDesc();
                    return -1;
                }
                case 151: {
                    continue block168;
                }
                case 46: {
                    this.setNewTag(20);
                }
                case 152: {
                    continue block168;
                }
                case 64: {
                    this.setNewTag(30);
                }
                case 153: {
                    continue block168;
                }
                case 10: {
                    this.handleDocEnd_inTags();
                    return -1;
                }
                case 154: {
                    continue block168;
                }
                case 70: {
                    this.startTagsState(25);
                }
                case 155: {
                    continue block168;
                }
                case 48: {
                    this.startTagsState(18);
                }
                case 156: {
                    continue block168;
                }
                case 2: 
                case 157: {
                    continue block168;
                }
                case 8: {
                    this.maxNumberofLines = 5;
                    this.handleDocEnd_shortDesc();
                    return -1;
                }
                case 158: {
                    continue block168;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return -1;
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java DocumentorLexer <inputfile>");
        } else {
            int i = 0;
            while (i < argv.length) {
                DocumentorLexer scanner = null;
                try {
                    scanner = new DocumentorLexer(new FileReader(argv[i]));
                    while (!scanner.zzAtEOF) {
                        scanner.next_token();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

