/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.php.internal.core.phar.PharArchiveEntry;
import org.eclipse.php.internal.core.phar.PharEntry;
import org.eclipse.php.internal.core.phar.PharException;
import org.eclipse.php.internal.core.phar.PharFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PharArchiveFile
implements IArchive {
    private PharFile pharFile;
    private File file;
    private static final Map<String, WeakReference<PharFile>> pharFiles = new HashMap<String, WeakReference<PharFile>>();

    public PharArchiveFile(String fileName) throws IOException, PharException {
        this(new File(fileName));
    }

    public PharArchiveFile(File file) throws IOException, PharException {
        this.file = file;
        String key = this.getFileKey(file);
        if (!pharFiles.containsKey(key)) {
            pharFiles.put(key, new WeakReference<PharFile>(new PharFile(file)));
        }
        WeakReference<PharFile> weakReference = pharFiles.get(key);
        this.pharFile = (PharFile)weakReference.get();
        this.makeSureInit(file);
    }

    private void makeSureInit(File file) throws IOException, PharException {
        if (this.pharFile == null) {
            String key = this.getFileKey(file);
            pharFiles.put(key, new WeakReference<PharFile>(new PharFile(file)));
            WeakReference<PharFile> weakReference = pharFiles.get(key);
            this.pharFile = (PharFile)weakReference.get();
        }
    }

    private String getFileKey(File file) {
        String key = String.valueOf(file.getAbsolutePath()) + file.lastModified();
        return key;
    }

    public void close() throws IOException {
        if (this.pharFile != null) {
            this.pharFile.close();
        }
    }

    public Enumeration<? extends IArchiveEntry> getArchiveEntries() {
        this.init();
        List<PharEntry> pharEntryList = this.pharFile.getPharEntryList();
        final Iterator<PharEntry> it = pharEntryList.iterator();
        return new Enumeration<IArchiveEntry>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public IArchiveEntry nextElement() {
                return new PharArchiveEntry((PharEntry)it.next());
            }
        };
    }

    public IArchiveEntry getArchiveEntry(String name) {
        this.init();
        return new PharArchiveEntry(this.pharFile.getEntry(name));
    }

    public InputStream getInputStream(IArchiveEntry entry) throws IOException {
        this.init();
        if (entry instanceof PharArchiveEntry) {
            PharArchiveEntry pharArchiveEntry = (PharArchiveEntry)entry;
            return this.pharFile.getInputStream(pharArchiveEntry.getPharEntry());
        }
        return null;
    }

    private void init() {
        try {
            this.makeSureInit(this.file);
        }
        catch (IOException iOException) {
        }
        catch (PharException pharException) {}
    }

    public String getName() {
        return this.pharFile.getName();
    }

    public int fileSize() {
        return this.pharFile.getFileNumber();
    }
}

