/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.digest.Digest;

public class SignatureBufferedOutputStream
extends OutputStream {
    private MessageDigest digest;
    private BufferedOutputStream innerOutputStream;

    public SignatureBufferedOutputStream(OutputStream out) {
        this.innerOutputStream = new BufferedOutputStream(out);
    }

    public SignatureBufferedOutputStream(OutputStream out, int size) {
        this.innerOutputStream = new BufferedOutputStream(out, size);
    }

    public SignatureBufferedOutputStream(OutputStream out, PharPackage pharData) {
        this(out);
        this.digest = !pharData.isUseSignature() || !Digest.DIGEST_MAP.containsKey(pharData.getSignature()) ? Digest.NULL_DIGEST : Digest.DIGEST_MAP.get(pharData.getSignature()).getDigest();
        this.digest.reset();
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public synchronized void write(byte[] b2, int off, int len) throws IOException {
        this.innerOutputStream.write(b2, off, len);
        this.digest.update(b2, off, len);
    }

    public synchronized void write(int b2) throws IOException {
        this.innerOutputStream.write(b2);
        this.digest.update((byte)b2);
    }

    public void close() throws IOException {
        this.innerOutputStream.close();
    }

    public byte[] getSignature() {
        return this.digest.digest();
    }
}

