/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.tar;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.php.internal.core.phar.PharEntryBufferedRandomInputStream;

public class GZIPInputStreamForPhar
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public GZIPInputStreamForPhar(InputStream in, int size) throws IOException {
        super(in, new Inflater(true), size);
        this.crc.reset();
    }

    public GZIPInputStreamForPhar(InputStream in) throws IOException {
        this(in, 512);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.eos) {
            return -1;
        }
        len = this.in instanceof PharEntryBufferedRandomInputStream && ((PharEntryBufferedRandomInputStream)this.in).isEnd() ? -1 : super.read(buf, off, len);
        if (len == -1) {
            this.eos = true;
        } else {
            this.crc.update(buf, off, len);
        }
        return len;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.inf.end();
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }
}

